/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.command;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.command.ModCommands;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.HEData;
import com.henny.hennyessentials.data.PlayerData;
import com.henny.hennyessentials.data.objects.Home;
import com.henny.hennyessentials.data.objects.SpawnPosData;
import com.henny.hennyessentials.data.objects.Tpa;
import com.henny.hennyessentials.handler.TpaHandler;
import com.henny.hennyessentials.permission.Permissions;
import com.henny.hennyessentials.task.Task;
import com.henny.hennyessentials.task.TaskManager;
import com.henny.hennyessentials.util.BackHandler;
import com.henny.hennyessentials.util.Pagination;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class TeleportCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> buildTeleportCommands() {
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> returnList = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        LiteralArgumentBuilder tpaCommand = Commands.literal((String)"tpa");
        tpaCommand.then(((RequiredArgumentBuilder)Commands.argument((String)"playerName", (ArgumentType)EntityArgument.player()).executes(TeleportCommands::executeTpa)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.tpa"))));
        returnList.add(tpaCommand);
        LiteralArgumentBuilder tpaHereCommand = Commands.literal((String)"tpahere");
        tpaHereCommand.then(((RequiredArgumentBuilder)Commands.argument((String)"playerName", (ArgumentType)EntityArgument.player()).executes(TeleportCommands::executeTpaHere)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.tpahere"))));
        returnList.add(tpaHereCommand);
        LiteralArgumentBuilder backCommand = Commands.literal((String)"back");
        backCommand.executes(TeleportCommands::executeBack);
        backCommand.requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.back")));
        returnList.add(backCommand);
        LiteralArgumentBuilder tpaAcceptCommand = Commands.literal((String)"tpaaccept");
        tpaAcceptCommand.then(((RequiredArgumentBuilder)Commands.argument((String)"requestUUID", (ArgumentType)UuidArgument.uuid()).executes(TeleportCommands::executeTpaAccept)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.tpaaccept"))));
        LiteralArgumentBuilder tpaDenyCommand = Commands.literal((String)"tpadeny");
        tpaDenyCommand.then(((RequiredArgumentBuilder)Commands.argument((String)"requestUUID", (ArgumentType)UuidArgument.uuid()).executes(TeleportCommands::executeTpaDeny)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.tpadeny"))));
        LiteralArgumentBuilder setHomeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sethome").executes(TeleportCommands::executeSetHome)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.sethome")))).then(((RequiredArgumentBuilder)Commands.argument((String)"homeName", (ArgumentType)StringArgumentType.word()).executes(TeleportCommands::executeSetHome)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.sethome"))));
        LiteralArgumentBuilder delHomeCommand = (LiteralArgumentBuilder)Commands.literal((String)"delhome").then(((RequiredArgumentBuilder)Commands.argument((String)"homeName", (ArgumentType)StringArgumentType.word()).executes(TeleportCommands::executeDelHome)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.delhome"))));
        delHomeCommand.requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.delhome")));
        LiteralArgumentBuilder homeCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"home").executes(TeleportCommands::executeGoHome)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.home")))).then(((RequiredArgumentBuilder)Commands.argument((String)"homeName", (ArgumentType)StringArgumentType.word()).executes(TeleportCommands::executeGoHome)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.home"))));
        LiteralArgumentBuilder listHomes = (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"homes").executes(TeleportCommands::executeListHomes)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.listhomes")));
        LiteralArgumentBuilder spawnCommand = Commands.literal((String)"spawn");
        spawnCommand.executes(TeleportCommands::executeTeleportToSpawn);
        spawnCommand.requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.spawn")));
        LiteralArgumentBuilder setSpawnCommand = Commands.literal((String)"setspawn");
        ((LiteralArgumentBuilder)setSpawnCommand.executes(context -> {
            if (!((CommandSourceStack)context.getSource()).isPlayer()) {
                return 1;
            }
            ServerPlayer p = ((CommandSourceStack)context.getSource()).getPlayer();
            SpawnPosData spd = new SpawnPosData(GlobalPos.of((ResourceKey)p.serverLevel().dimension(), (BlockPos)p.getOnPos()), p.getYRot());
            HEData.getHEData().addSpawnPoint(spd);
            p.serverLevel().setDefaultSpawnPos(p.getOnPos(), p.getYRot());
            p.sendSystemMessage((Component)TextUtils.formatAndHighlight("Set the spawn position for dimension: [" + String.valueOf(p.serverLevel().dimension().location()) + "] to: [" + p.getOnPos().toShortString() + "]"));
            return 1;
        })).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.setspawn")));
        returnList.add(tpaAcceptCommand);
        returnList.add(tpaDenyCommand);
        if (ConfigManager.CONFIG.commandConfigs.teleportConfigs.spawnCommandEnabled) {
            returnList.add(spawnCommand);
        }
        if (ConfigManager.CONFIG.commandConfigs.teleportConfigs.setSpawnCommandEnabled) {
            returnList.add(setSpawnCommand);
        }
        if (ConfigManager.CONFIG.commandConfigs.teleportConfigs.homeCommandsEnabled) {
            returnList.add((LiteralArgumentBuilder<CommandSourceStack>)setHomeCommand);
            returnList.add((LiteralArgumentBuilder<CommandSourceStack>)delHomeCommand);
            returnList.add((LiteralArgumentBuilder<CommandSourceStack>)homeCommand);
            returnList.add((LiteralArgumentBuilder<CommandSourceStack>)listHomes);
        }
        return returnList;
    }

    private static int executeTeleportToSpawn(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer p = ((CommandSourceStack)context.getSource()).getPlayer();
        ServerLevel ow = p.serverLevel();
        if (ConfigManager.CONFIG.commandConfigs.teleportConfigs.spawnCommandAlwaysTeleportsToOverworld) {
            ow = p.getServer().overworld();
        }
        BlockPos owS = ow.getSharedSpawnPos();
        if (HEData.getHEData().SPAWN_DATA.containsKey(p.serverLevel().dimension().location().toString())) {
            SpawnPosData spd = HEData.getHEData().SPAWN_DATA.get(p.serverLevel().dimension().location().toString());
            TeleportCommands.teleportPlayer(p, spd.pos, ConfigManager.CONFIG.commandConfigs.teleportConfigs.spawnCommandWarmupSeconds, spd.rotation);
        } else {
            TeleportCommands.teleportPlayer(p, GlobalPos.of((ResourceKey)ow.dimension(), (BlockPos)ow.getSharedSpawnPos()), ConfigManager.CONFIG.commandConfigs.teleportConfigs.spawnCommandWarmupSeconds, p.getYRot());
        }
        return 1;
    }

    private static int executeSetHome(CommandContext<CommandSourceStack> context) {
        int maxHomes;
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        String name = "home";
        boolean hasHome = context.getNodes().stream().anyMatch(node -> node.getNode().getName().equals("homeName"));
        if (hasHome) {
            name = StringArgumentType.getString(context, (String)"homeName");
        }
        name = name.toLowerCase();
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        UUID uuid = player.getUUID();
        int currentHomes = PlayerData.getUserData().countPlayerHomes(uuid);
        if (currentHomes >= (maxHomes = ConfigManager.CONFIG.permissionConfigs.permissionsEnabled ? Permissions.getMaxHomeLimit(uuid) : ConfigManager.CONFIG.commandConfigs.teleportConfigs.defaultNumberOfHomes)) {
            player.sendSystemMessage((Component)TextUtils.formatMessage("You have reached your home limit of " + maxHomes + "."));
            if (maxHomes == 0) {
                player.sendSystemMessage((Component)TextUtils.formatMessage("Your max homes is: 0. This is odd... Does your user group have a home.limit.NUMBER permission set? (eg: home.limit.5)"));
            }
            return 1;
        }
        boolean success = PlayerData.getUserData().addPlayerHome(uuid, new Home(name, GlobalPos.of((ResourceKey)player.level().dimension(), (BlockPos)BlockPos.containing((Position)player.getOnPos().getCenter()))));
        if (success) {
            player.sendSystemMessage((Component)TextUtils.formatMessage("").append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.setHomeText.replace("%homename%", name))));
        } else {
            player.sendSystemMessage((Component)TextUtils.formatMessage("").append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.failedToSetHomeText.replace("%homename%", name))));
        }
        return 1;
    }

    private static int executeDelHome(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        String name = "home";
        boolean hasHome = context.getNodes().stream().anyMatch(node -> node.getNode().getName().equals("homeName"));
        if (hasHome) {
            name = StringArgumentType.getString(context, (String)"homeName");
        }
        name = name.toLowerCase();
        if (PlayerData.getUserData().removePlayerHome(((CommandSourceStack)context.getSource()).getPlayer().getUUID(), name)) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("").append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.delHomeText.replace("%homename%", name))));
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("").append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.failedToDelHomeText.replace("%homename%", name))));
        }
        return 1;
    }

    private static int executeGoHome(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        String name = "home";
        boolean hasHome = context.getNodes().stream().anyMatch(node -> node.getNode().getName().equals("homeName"));
        if (hasHome) {
            name = StringArgumentType.getString(context, (String)"homeName");
        }
        name = name.toLowerCase();
        ServerPlayer p = ((CommandSourceStack)context.getSource()).getPlayer();
        if (PlayerData.getUserData().getPlayerHome(p.getUUID(), name) != null) {
            if (!Permissions.cooldownChecker(p.getUUID(), "he.home")) {
                Permissions.handleCooldownNotExpired(p, "he.home");
                return 1;
            }
            Permissions.updateCooldown(p.getUUID(), "he.home", System.currentTimeMillis() + (long)ConfigManager.CONFIG.commandConfigs.teleportConfigs.homeCommandCooldownSeconds * 1000L);
            Home home = PlayerData.getUserData().getPlayerHome(p.getUUID(), name);
            ServerLevel levelToTPTo = CommonClass.minecraftServer.getLevel(home.pos.dimension());
            if (levelToTPTo != null) {
                TeleportCommands.teleportPlayer(p, home.pos, ConfigManager.CONFIG.commandConfigs.teleportConfigs.homeCommandWarmupSeconds, home.rotation);
            } else {
                p.sendSystemMessage((Component)TextUtils.formatMessage("Error finding dimension to teleport to"));
            }
        } else {
            p.sendSystemMessage((Component)TextUtils.formatMessage("Couldn't find a home with the name: " + name));
        }
        return 1;
    }

    private static int executeListHomes(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer p = ((CommandSourceStack)context.getSource()).getPlayer();
        Collection<Home> data = PlayerData.getUserData().listPlayerHomes(p.getUUID());
        ArrayList<MutableComponent> comps = new ArrayList<MutableComponent>();
        for (Home entry : data) {
            MutableComponent comp = Component.literal((String)("~ " + entry.name));
            Style style = Style.EMPTY.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click here to teleport to this home"))).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/he home " + entry.name)).withColor(ChatFormatting.GOLD);
            comp.setStyle(style);
            comps.add(comp);
        }
        new Pagination.PaginationBuilder(((CommandSourceStack)context.getSource()).getPlayer(), comps).linesPerPage(ConfigManager.CONFIG.commandConfigs.teleportConfigs.homeListLinesPerPage).header(ConfigManager.CONFIG.commandConfigs.teleportConfigs.homeListHeader).padding(ConfigManager.CONFIG.commandConfigs.teleportConfigs.homeListPadding).build().send();
        return 1;
    }

    private static int executeBack(CommandContext<CommandSourceStack> context) {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayer();
        if (!BackHandler.hasBackLocation(player)) {
            player.sendSystemMessage((Component)TextUtils.formatMessage("").append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.backCommandNoSavedDeathLocation)));
            return 0;
        }
        GlobalPos deathPos = BackHandler.getLastDeathLocation(player);
        ServerLevel level = player.server.getLevel(deathPos.dimension());
        BlockPos safePos = BackHandler.findSafeNearby(level, deathPos.pos(), 5);
        if (safePos != null) {
            if (!Permissions.cooldownChecker(player.getUUID(), "he.back")) {
                Permissions.handleCooldownNotExpired(player, "he.back");
                return 1;
            }
            Permissions.updateCooldown(player.getUUID(), "he.back", System.currentTimeMillis() + (long)ConfigManager.CONFIG.commandConfigs.teleportConfigs.backCommandCooldownSeconds * 1000L);
            player.sendSystemMessage((Component)TextUtils.formatMessage("").append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.backCommandTeleportSuccess)));
            TeleportCommands.teleportPlayer(player, GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)safePos), ConfigManager.CONFIG.commandConfigs.teleportConfigs.backCommandWarmupSeconds, player.getYRot());
            return 1;
        }
        player.sendSystemMessage((Component)TextUtils.formatMessage("").append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.backCommandNoSafeLocationFound)));
        return 0;
    }

    private static int executeTpa(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer p = ((CommandSourceStack)context.getSource()).getPlayer();
        ServerPlayer toP = EntityArgument.getPlayer(context, (String)"playerName");
        if (p.getScoreboardName().equals(toP.getScoreboardName())) {
            p.sendSystemMessage((Component)TextUtils.formatMessage("Can't send a TPA request to yourself!"));
            return 1;
        }
        if (!Permissions.cooldownChecker(p.getUUID(), "he.tpa")) {
            Permissions.handleCooldownNotExpired(p, "he.tpa");
            return 1;
        }
        Permissions.updateCooldown(p.getUUID(), "he.tpa", System.currentTimeMillis() + (long)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaCommandCooldownSeconds * 1000L);
        UUID reqID = UUID.randomUUID();
        TpaHandler.addTpaRequest(reqID, new Tpa(p.getUUID(), toP.getUUID(), reqID));
        p.sendSystemMessage((Component)TextUtils.getModPrefix().append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaRequestSentText)));
        Style acceptStyle = Style.EMPTY;
        acceptStyle = acceptStyle.withColor(ChatFormatting.GREEN);
        acceptStyle = acceptStyle.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/he tpaaccept " + String.valueOf(reqID)));
        acceptStyle = acceptStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaAcceptHoverText)));
        MutableComponent acceptComp = Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaAcceptText).withStyle(acceptStyle);
        Style denyStyle = Style.EMPTY;
        denyStyle = denyStyle.withColor(ChatFormatting.RED);
        denyStyle = denyStyle.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/he tpadeny " + String.valueOf(reqID)));
        denyStyle = denyStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaDenyHoverText)));
        MutableComponent denyComp = Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaDenyText).withStyle(denyStyle);
        MutableComponent separator = Component.literal((String)" | ").withStyle(ChatFormatting.GOLD);
        toP.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaRequestText.replace("%playername%", p.getName().getString())));
        MutableComponent finalMsg = Component.literal((String)"").append((Component)acceptComp).append((Component)separator).append((Component)denyComp);
        toP.sendSystemMessage((Component)TextUtils.formatMessage("").append((Component)finalMsg));
        return 1;
    }

    private static int executeTpaHere(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        ServerPlayer toP = ((CommandSourceStack)context.getSource()).getPlayer();
        ServerPlayer p = EntityArgument.getPlayer(context, (String)"playerName");
        if (p.getScoreboardName().equals(toP.getScoreboardName())) {
            toP.sendSystemMessage((Component)TextUtils.formatMessage("Can't send a TPA request to yourself!"));
            return 1;
        }
        if (!Permissions.cooldownChecker(toP.getUUID(), "he.tpa")) {
            Permissions.handleCooldownNotExpired(toP, "he.tpa");
            return 1;
        }
        Permissions.updateCooldown(toP.getUUID(), "he.tpa", System.currentTimeMillis() + (long)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaCommandCooldownSeconds * 1000L);
        UUID reqID = UUID.randomUUID();
        TpaHandler.addTpaRequest(reqID, new Tpa(p.getUUID(), toP.getUUID(), reqID));
        p.sendSystemMessage((Component)TextUtils.getModPrefix().append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaRequestSentText)));
        Style acceptStyle = Style.EMPTY;
        acceptStyle = acceptStyle.withColor(ChatFormatting.GREEN);
        acceptStyle = acceptStyle.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/he tpaaccept " + String.valueOf(reqID)));
        acceptStyle = acceptStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaAcceptHoverText)));
        MutableComponent acceptComp = Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaAcceptText).withStyle(acceptStyle);
        Style denyStyle = Style.EMPTY;
        denyStyle = denyStyle.withColor(ChatFormatting.RED);
        denyStyle = denyStyle.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/he tpadeny " + String.valueOf(reqID)));
        denyStyle = denyStyle.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaDenyHoverText)));
        MutableComponent denyComp = Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaDenyText).withStyle(denyStyle);
        MutableComponent separator = Component.literal((String)" | ").withStyle(ChatFormatting.GOLD);
        p.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaHereRequestText.replace("%playername%", toP.getName().getString())));
        MutableComponent finalMsg = Component.literal((String)"").append((Component)acceptComp).append((Component)separator).append((Component)denyComp);
        p.sendSystemMessage((Component)TextUtils.formatMessage("").append((Component)finalMsg));
        return 1;
    }

    private static int executeTpaAccept(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        UUID reqUUID = UuidArgument.getUuid(context, (String)"requestUUID");
        if (!TpaHandler.tpaReqs.containsKey(reqUUID)) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaErrorText));
            return 1;
        }
        Tpa tpa = TpaHandler.tpaReqs.get(reqUUID);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.getModPrefix().append((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaRequestAcceptText)));
        ServerPlayer playerToTeleport = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(tpa.UUIDToTeleport);
        ServerPlayer playerToTeleportTO = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(tpa.teleportToUUID);
        String dim = playerToTeleportTO.serverLevel().dimension().location().toString();
        if (ConfigManager.CONFIG.permissionConfigs.permissionRequiredToEnterDimensions && !dim.equals(ConfigManager.CONFIG.permissionConfigs.defaultDimensionNoPermsRequired) && !Permissions.permissionCheck(playerToTeleport.getUUID(), "dimension." + dim + ".tpa", ((CommandSourceStack)context.getSource()).getServer())) {
            playerToTeleport.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaNoPermissionDimension.replace("%dimension%", dim)));
            return 1;
        }
        TpaHandler.tpaReqs.remove(reqUUID);
        TeleportCommands.teleportPlayer(playerToTeleport, GlobalPos.of((ResourceKey)playerToTeleportTO.level().dimension(), (BlockPos)playerToTeleportTO.getOnPos()), ConfigManager.CONFIG.commandConfigs.teleportConfigs.tpaCommandWarmupSeconds, playerToTeleport.getYRot());
        return 1;
    }

    public static void teleportPlayer(ServerPlayer playerToTeleport, GlobalPos location, int warmupSeconds, float rotation) {
        if (warmupSeconds <= 0) {
            ServerLevel sLevel = CommonClass.minecraftServer.getLevel(location.dimension());
            if (ConfigManager.CONFIG.permissionConfigs.permissionRequiredToEnterDimensions && !ConfigManager.CONFIG.permissionConfigs.defaultDimensionNoPermsRequired.equals(sLevel.dimension().location().toString()) && !Permissions.permissionCheck(playerToTeleport.getUUID(), "dimension." + String.valueOf(sLevel.dimension().location()), CommonClass.minecraftServer)) {
                playerToTeleport.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.teleportConfigs.normalTeleportToDimNoPermission.replace("%dimension%", sLevel.dimension().location().toString())));
                return;
            }
            if (ConfigManager.CONFIG.commandConfigs.teleportConfigs.backCommandSavesLastTeleport) {
                BackHandler.setLastDeathLocation(playerToTeleport, GlobalPos.of((ResourceKey)playerToTeleport.level().dimension(), (BlockPos)playerToTeleport.getOnPos()));
            }
            playerToTeleport.teleportTo(sLevel, location.pos().getCenter().x(), location.pos().getCenter().y() + 1.0, location.pos().getCenter().z(), rotation, playerToTeleport.getXRot());
            return;
        }
        AtomicInteger seconds = new AtomicInteger(warmupSeconds);
        UUID taskID = UUID.randomUUID();
        playerToTeleport.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.teleportConfigs.beforeTPText.replace("%warmupseconds%", String.valueOf(warmupSeconds))));
        CommonClass.teleportMoveLock.put(playerToTeleport.getUUID(), playerToTeleport.getOnPos());
        TaskManager.addTask(Task.builder().name(taskID.toString()).interval(1, TimeUnit.SECONDS).execute(task -> {
            seconds.getAndDecrement();
            if (seconds.get() == 0) {
                if (playerToTeleport != null && location != null) {
                    boolean isPos;
                    BlockPos prev = CommonClass.teleportMoveLock.get(playerToTeleport.getUUID());
                    BlockPos now = playerToTeleport.getOnPos();
                    boolean bl = isPos = prev.getX() == now.getX() && prev.getZ() == now.getZ();
                    if (isPos || !ConfigManager.CONFIG.commandConfigs.teleportConfigs.teleportsShouldEnforceNoMovementWhileWaitingForWarmup) {
                        if (ConfigManager.CONFIG.commandConfigs.teleportConfigs.backCommandSavesLastTeleport) {
                            BackHandler.setLastDeathLocation(playerToTeleport, GlobalPos.of((ResourceKey)playerToTeleport.level().dimension(), (BlockPos)playerToTeleport.getOnPos()));
                        }
                        playerToTeleport.teleportTo(CommonClass.minecraftServer.getLevel(location.dimension()), location.pos().getCenter().x(), location.pos().getCenter().y() + 0.5, location.pos().getCenter().z(), rotation, 0.0f);
                    } else {
                        playerToTeleport.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.teleportConfigs.teleportCancelledText));
                    }
                }
                task.completed = true;
            }
        }).build());
    }

    private static int executeTpaDeny(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        UUID reqUUID = UuidArgument.getUuid(context, (String)"requestUUID");
        if (!TpaHandler.tpaReqs.containsKey(reqUUID)) {
            return 1;
        }
        Tpa tpa = TpaHandler.tpaReqs.get(reqUUID);
        ServerPlayer playerToTeleport = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(tpa.UUIDToTeleport);
        ServerPlayer playerToTeleportTO = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(tpa.teleportToUUID);
        playerToTeleport.sendSystemMessage((Component)TextUtils.formatMessage("TPA request denied."));
        playerToTeleportTO.sendSystemMessage((Component)TextUtils.formatMessage("TPA request denied."));
        TpaHandler.tpaReqs.remove(reqUUID);
        return 1;
    }
}

