/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.command;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.command.ModCommands;
import com.henny.hennyessentials.command.TeleportCommands;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.WarpData;
import com.henny.hennyessentials.data.objects.Warp;
import com.henny.hennyessentials.menu.WarpsMenu;
import com.henny.hennyessentials.permission.Permissions;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class WarpCommands {
    public static List<LiteralArgumentBuilder<CommandSourceStack>> buildWarpCommands() {
        ArrayList<LiteralArgumentBuilder<CommandSourceStack>> returnList = new ArrayList<LiteralArgumentBuilder<CommandSourceStack>>();
        LiteralArgumentBuilder setWarpCommand = Commands.literal((String)"setwarp");
        setWarpCommand.then(((RequiredArgumentBuilder)Commands.argument((String)"warpName", (ArgumentType)StringArgumentType.string()).executes(WarpCommands::executeSetWarp)).then(((RequiredArgumentBuilder)Commands.argument((String)"category", (ArgumentType)StringArgumentType.word()).executes(WarpCommands::executeSetWarp)).then(Commands.argument((String)"displayItem", (ArgumentType)ItemArgument.item((CommandBuildContext)Commands.createValidationContext((HolderLookup.Provider)VanillaRegistries.createLookup()))).executes(WarpCommands::executeSetWarp))));
        setWarpCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.setwarp")));
        returnList.add(setWarpCommand);
        LiteralArgumentBuilder setTempWarpCommand = Commands.literal((String)"settempwarp");
        setTempWarpCommand.then(Commands.argument((String)"warpName", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"duration", (ArgumentType)StringArgumentType.word()).executes(WarpCommands::executeSetTempWarp)).then(((RequiredArgumentBuilder)Commands.argument((String)"category", (ArgumentType)StringArgumentType.word()).executes(WarpCommands::executeSetTempWarp)).then(Commands.argument((String)"displayItem", (ArgumentType)ItemArgument.item((CommandBuildContext)Commands.createValidationContext((HolderLookup.Provider)VanillaRegistries.createLookup()))).executes(WarpCommands::executeSetTempWarp)))));
        setTempWarpCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.settempwarp")));
        returnList.add(setTempWarpCommand);
        LiteralArgumentBuilder delWarpCommand = Commands.literal((String)"delwarp");
        delWarpCommand.then(((RequiredArgumentBuilder)Commands.argument((String)"warpName", (ArgumentType)StringArgumentType.word()).executes(WarpCommands::executeRemoveWarp)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.delwarp"))));
        delWarpCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.delwarp")));
        returnList.add(delWarpCommand);
        LiteralArgumentBuilder warpCommand = Commands.literal((String)"warp");
        warpCommand.then(((RequiredArgumentBuilder)Commands.argument((String)"warpName", (ArgumentType)StringArgumentType.word()).executes(WarpCommands::executeWarp)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.warp"))));
        LiteralArgumentBuilder setWarpCategoryCommand = Commands.literal((String)"setCategory");
        setWarpCategoryCommand.then(Commands.argument((String)"warpName", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"category", (ArgumentType)StringArgumentType.word()).executes(WarpCommands::executeSetWarpCategory)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.setwarpcategory")))));
        LiteralArgumentBuilder setWarpDisplayIconCommand = Commands.literal((String)"setDisplayIcon");
        setWarpDisplayIconCommand.then(Commands.literal((String)"warp").then(((RequiredArgumentBuilder)Commands.argument((String)"warpName", (ArgumentType)StringArgumentType.word()).executes(WarpCommands::executeSetWarpDisplayIcon)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.setwarpdisplay")))));
        setWarpDisplayIconCommand.then(Commands.literal((String)"category").then(((RequiredArgumentBuilder)Commands.argument((String)"categoryName", (ArgumentType)StringArgumentType.word()).suggests(WarpCommands::suggestCategoryOptions).executes(WarpCommands::executeSetWarpCategoryDisplayIcon)).requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.setwarp")))));
        setWarpCategoryCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.setwarpcategory")));
        setWarpDisplayIconCommand.requires(src -> ModCommands.getRequirements(src, List.of("he.admin", "command.he.setwarpdisplay")));
        warpCommand.then((ArgumentBuilder)setWarpCategoryCommand);
        warpCommand.then((ArgumentBuilder)setWarpDisplayIconCommand);
        returnList.add(warpCommand);
        LiteralArgumentBuilder warpsCommand = (LiteralArgumentBuilder)Commands.literal((String)"warps").executes(WarpCommands::executeListWarps);
        LiteralArgumentBuilder listWarpsCommand = Commands.literal((String)"listwarps");
        ((LiteralArgumentBuilder)warpsCommand.executes(WarpCommands::executeListWarps)).then(((RequiredArgumentBuilder)Commands.argument((String)"category", (ArgumentType)StringArgumentType.word()).executes(WarpCommands::executeListWarps)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.listwarps"))));
        listWarpsCommand.executes(WarpCommands::executeListWarps);
        listWarpsCommand.then(((RequiredArgumentBuilder)Commands.argument((String)"category", (ArgumentType)StringArgumentType.word()).executes(WarpCommands::executeListWarps)).requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.listwarps"))));
        warpsCommand.requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.listwarps")));
        listWarpsCommand.requires(src -> ModCommands.getPlayerRequirements(src, List.of("he.user", "command.he.listwarps")));
        returnList.add(warpsCommand);
        returnList.add(listWarpsCommand);
        return returnList;
    }

    private static int executeSetWarpDisplayIcon(CommandContext<CommandSourceStack> context) {
        String warpName = StringArgumentType.getString(context, (String)"warpName");
        ItemStack item = ((CommandSourceStack)context.getSource()).getPlayer().getMainHandItem();
        if (item != null && !item.isEmpty() && WarpData.getWarpData((MinecraftServer)CommonClass.minecraftServer).warps.containsKey(warpName)) {
            WarpData.getWarpData(((CommandSourceStack)context.getSource()).getServer()).setWarpDisplayItem(warpName, item);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Set display icon for warp: " + warpName + " to: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item.getItem()))));
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Error setting display icon."));
        }
        return 1;
    }

    private static int executeSetWarpCategoryDisplayIcon(CommandContext<CommandSourceStack> context) {
        String categoryName = StringArgumentType.getString(context, (String)"categoryName");
        ItemStack item = ((CommandSourceStack)context.getSource()).getPlayer().getMainHandItem();
        if (item != null && !item.isEmpty()) {
            WarpData.getWarpData(((CommandSourceStack)context.getSource()).getServer()).setCategoryDisplayItem(categoryName, item);
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Set display icon for warp category: " + categoryName + " to: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)item.getItem()))));
        } else {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Error setting display icon. "));
        }
        return 1;
    }

    private static int executeRemoveWarp(CommandContext<CommandSourceStack> context) {
        String warpName = StringArgumentType.getString(context, (String)"warpName");
        WarpData warpData = WarpData.getWarpData(((CommandSourceStack)context.getSource()).getServer());
        if (!warpData.warps.containsKey(warpName)) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Warp '" + warpName + "' does not exist."));
            return 1;
        }
        warpData.removeWarp(warpName);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Warp '" + warpName + "' removed."));
        return 1;
    }

    private static int executeSetWarpCategory(CommandContext<CommandSourceStack> context) {
        String warpName = StringArgumentType.getString(context, (String)"warpName");
        String category = StringArgumentType.getString(context, (String)"category");
        WarpData warpData = WarpData.getWarpData(((CommandSourceStack)context.getSource()).getServer());
        if (!warpData.warps.containsKey(warpName)) {
            ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Warp '" + warpName + "' does not exist."));
            return 1;
        }
        warpData.setWarpCategory(warpName, category);
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)TextUtils.formatMessage("Warp '" + warpName + "' has been added to category: " + category));
        return 1;
    }

    private static int executeSetWarp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String warpName = StringArgumentType.getString(context, (String)"warpName");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        WarpData warpData = WarpData.getWarpData(((CommandSourceStack)context.getSource()).getServer());
        Warp warp = new Warp(warpName, player.getOnPos(), player.serverLevel().dimension().location().toString());
        warp.rotation = player.getYRot();
        if (context.getNodes().stream().anyMatch(node -> node.getNode().getName().equals("category"))) {
            warp.category = StringArgumentType.getString(context, (String)"category");
        }
        if (context.getNodes().stream().anyMatch(node -> node.getNode().getName().equals("displayItem"))) {
            warp.displayItem = ItemArgument.getItem(context, (String)"displayItem").createItemStack(1, false);
        }
        warpData.addWarp(warp);
        player.sendSystemMessage((Component)TextUtils.formatAndHighlight("Set warp with the name [" + warpName + "] at position: [" + warp.dimension + "~" + warp.blockPos.toShortString() + "]"));
        return 1;
    }

    private static int executeSetTempWarp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String warpName = StringArgumentType.getString(context, (String)"warpName");
        String duration = StringArgumentType.getString(context, (String)"duration");
        if (TextUtils.canBeParsed(duration)) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            long durationMillis = Duration.parse(TextUtils.parseToISO8601(duration)).toMillis();
            WarpData warpData = WarpData.getWarpData(((CommandSourceStack)context.getSource()).getServer());
            Warp warp = new Warp(warpName, player.getOnPos(), player.serverLevel().dimension().location().toString(), System.currentTimeMillis() + durationMillis);
            warp.rotation = player.getYRot();
            if (context.getNodes().stream().anyMatch(node -> node.getNode().getName().equals("categor"))) {
                warp.category = StringArgumentType.getString(context, (String)"category");
            }
            if (context.getNodes().stream().anyMatch(node -> node.getNode().getName().equals("displayItem"))) {
                warp.displayItem = ItemArgument.getItem(context, (String)"displayItem").createItemStack(1, false);
            }
            warpData.addWarp(warp);
            player.sendSystemMessage((Component)TextUtils.formatAndHighlight("Set temp warp with the name [" + warpName + "] at position: [" + warp.dimension + "~" + warp.blockPos.toShortString() + "]"));
            player.sendSystemMessage((Component)TextUtils.formatAndHighlight("This warp will expire in: [" + TextUtils.readableDuration(warp.expiry - System.currentTimeMillis()) + "]"));
        } else {
            TextUtils.sendParseError((CommandSourceStack)context.getSource(), duration);
        }
        return 1;
    }

    public static int executeWarp(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (!((CommandSourceStack)context.getSource()).isPlayer()) {
            return 1;
        }
        String warpName = StringArgumentType.getString(context, (String)"warpName");
        warpName = warpName.toLowerCase();
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        WarpData warpData = WarpData.getWarpData(((CommandSourceStack)context.getSource()).getServer());
        if (!warpData.warps.containsKey(warpName)) {
            player.sendSystemMessage((Component)TextUtils.formatMessage("Warp '" + warpName + "' does not exist."));
        }
        Warp warp = warpData.warps.get(warpName);
        String warpcat = warp.category;
        if (warpcat == null || warpcat.isBlank()) {
            warpcat = "default";
        }
        if (ConfigManager.CONFIG.permissionConfigs.permissionsRequiredForIndividualWarps && !Permissions.permissionCheckList(player.getUUID(), List.of("warp." + warpName, "warpcategory." + warpcat), CommonClass.minecraftServer)) {
            player.sendSystemMessage((Component)Component.literal((String)"").append((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.warpConfigs.noPermissionForWarpMessage.replace("%warpname%", warpName))));
            return 1;
        }
        if (!Permissions.cooldownChecker(player.getUUID(), "he.warp")) {
            Permissions.handleCooldownNotExpired(player, "he.warp");
            return 1;
        }
        Permissions.updateCooldown(player.getUUID(), "he.warp", System.currentTimeMillis() + (long)ConfigManager.CONFIG.commandConfigs.warpConfigs.cooldownSeconds * 1000L);
        ServerLevel serverLevel = server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)warp.dimension)));
        GlobalPos pos = GlobalPos.of((ResourceKey)serverLevel.dimension(), (BlockPos)warp.blockPos);
        TeleportCommands.teleportPlayer(player, pos, ConfigManager.CONFIG.commandConfigs.teleportConfigs.warpCommandWarmupSeconds, warp.rotation);
        return 1;
    }

    private static int executeListWarps(CommandContext<CommandSourceStack> context) {
        WarpData warpData = WarpData.getWarpData(((CommandSourceStack)context.getSource()).getServer());
        if (ConfigManager.CONFIG.commandConfigs.warpConfigs.shouldUseInventoryMenuForWarps) {
            WarpCommands.openWarpsMenu(((CommandSourceStack)context.getSource()).getPlayer());
        } else {
            String category = "";
            boolean hasCategory = context.getNodes().stream().anyMatch(node -> node.getNode().getName().equals("category"));
            if (hasCategory) {
                category = StringArgumentType.getString(context, (String)"category");
            }
            ArrayList<Component> components = new ArrayList<Component>();
            HashMap<String, List> categories = new HashMap<String, List>();
            warpData.warps.values().forEach(warp -> {
                String expiry = warp.expiry > 0L ? " | Expires: " + TextUtils.readableDuration(warp.expiry - System.currentTimeMillis()) : "";
                MutableComponent warpComponent = Component.literal((String)"").append("~ " + warp.name + expiry).withStyle(ChatFormatting.GOLD);
                warpComponent.withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + ModCommands.BASE_COMMAND_ALIAS + " warp " + warp.name)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click here to warp to: " + warp.name)))));
                components.add((Component)warpComponent);
                categories.computeIfAbsent(warp.category, k -> new ArrayList()).add(warpComponent);
            });
            if (!hasCategory) {
                if (categories.size() == 1) {
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"~ WARP LIST ~").withStyle(ChatFormatting.GREEN));
                    components.forEach(component -> ((CommandSourceStack)context.getSource()).sendSystemMessage(component));
                } else {
                    ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)"~ WARP CATEGORIES ~").withStyle(ChatFormatting.GREEN));
                    categories.forEach((s, mutableComponents) -> {
                        MutableComponent categoryComp = Component.literal((String)("~ " + s));
                        Style style = Style.EMPTY.withColor(ChatFormatting.GOLD).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Click here to expand this warp category"))).withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/he listwarps " + s));
                        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)categoryComp.withStyle(style));
                    });
                }
            } else {
                ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.literal((String)("~ " + category + " ~")).withStyle(ChatFormatting.GREEN));
                ((List)categories.getOrDefault(category, new ArrayList())).forEach(mutableComponent -> ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)mutableComponent));
            }
        }
        return 1;
    }

    public static void openWarpsMenu(ServerPlayer player) {
        SimpleContainer container = new SimpleContainer(90);
        player.openMenu(new MenuProvider(){

            @Nullable
            public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
                return new WarpsMenu(i, inventory, WarpData.getWarpData(CommonClass.minecraftServer), player.getUUID());
            }

            public Component getDisplayName() {
                return Component.literal((String)"Warps Menu");
            }
        });
    }

    private static CompletableFuture<Suggestions> suggestCategoryOptions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        if (CommonClass.minecraftServer != null) {
            WarpData data = WarpData.getWarpData(CommonClass.minecraftServer);
            HashSet<String> categories = new HashSet<String>();
            for (Map.Entry<String, Warp> warp : data.warps.entrySet()) {
                categories.add(warp.getValue().category);
            }
            categories.forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        }
        return builder.buildFuture();
    }
}

