/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.compat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;

public class LuckPermsIntegration {
    public static boolean isLuckPermsLoaded = false;

    public static boolean checkPermission(UUID uuid, String perm) {
        if (LuckPermsProvider.get().getUserManager().getUser(uuid) == null) {
            return false;
        }
        return LuckPermsProvider.get().getUserManager().getUser(uuid).getCachedData().getPermissionData().checkPermission(perm).asBoolean();
    }

    public static boolean checkPermission(UUID uuid, List<String> perms) {
        boolean hasPermission = false;
        if (LuckPermsProvider.get().getUserManager().getUser(uuid) == null) {
            return false;
        }
        for (String perm : perms) {
            if (!LuckPermsProvider.get().getUserManager().getUser(uuid).getCachedData().getPermissionData().checkPermission(perm).asBoolean()) continue;
            hasPermission = true;
        }
        return hasPermission;
    }

    public static String getPrefix(UUID uuid) {
        if (!isLuckPermsLoaded) {
            return "";
        }
        LuckPerms luckPerms = LuckPermsProvider.get();
        User user = luckPerms.getUserManager().getUser(uuid);
        if (user == null) {
            return "";
        }
        QueryOptions context = (QueryOptions)luckPerms.getContextManager().getQueryOptions(user).orElseThrow();
        CachedMetaData metaData = user.getCachedData().getMetaData(context);
        return metaData.getPrefix() != null ? metaData.getPrefix() : "";
    }

    public static String getSuffix(UUID uuid) {
        if (!isLuckPermsLoaded) {
            return "";
        }
        LuckPerms luckPerms = LuckPermsProvider.get();
        User user = luckPerms.getUserManager().getUser(uuid);
        if (user == null) {
            return "";
        }
        QueryOptions context = (QueryOptions)luckPerms.getContextManager().getQueryOptions(user).orElseThrow();
        CachedMetaData metaData = user.getCachedData().getMetaData(context);
        return metaData.getSuffix() != null ? metaData.getSuffix() : "";
    }

    public static int getMaxHomeLimit(UUID uuid) {
        if (!isLuckPermsLoaded) {
            return 0;
        }
        User user = LuckPermsProvider.get().getUserManager().getUser(uuid);
        if (user == null) {
            return 0;
        }
        QueryOptions context = (QueryOptions)LuckPermsProvider.get().getContextManager().getQueryOptions(user).orElseThrow();
        CachedPermissionData data = user.getCachedData().getPermissionData(context);
        return data.getPermissionMap().entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(Map.Entry::getKey).filter(perm -> perm.startsWith("home.limit.")).map(perm -> perm.substring("home.limit.".length())).mapToInt(limitStr -> {
            try {
                return Integer.parseInt(limitStr);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }).filter(num -> num >= 0).max().orElse(0);
    }

    public static List<String> getUserPermissions(UUID uuid) {
        if (!isLuckPermsLoaded) {
            return new ArrayList<String>();
        }
        User user = LuckPermsProvider.get().getUserManager().getUser(uuid);
        if (user == null) {
            return List.of();
        }
        QueryOptions context = (QueryOptions)LuckPermsProvider.get().getContextManager().getQueryOptions(user).orElseThrow();
        CachedPermissionData data = user.getCachedData().getPermissionData(context);
        return data.getPermissionMap().entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static boolean hasPermission(UUID playerUUID, String permission) {
        try {
            if (!isLuckPermsLoaded) {
                return false;
            }
            return LuckPermsIntegration.checkPermission(playerUUID, permission);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

