/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.henny.hennyessentials.Constants;
import com.henny.hennyessentials.config.objects.AnnouncementsConfig;
import com.henny.hennyessentials.config.objects.BannedItemsConfig;
import com.henny.hennyessentials.config.objects.CommandTokensConfig;
import com.henny.hennyessentials.config.objects.ConditionsConfig;
import com.henny.hennyessentials.config.objects.MainConfig;
import com.henny.hennyessentials.config.objects.PagesConfig;
import com.henny.hennyessentials.data.objects.Announcement;
import com.henny.hennyessentials.data.objects.CommandToken;
import com.henny.hennyessentials.data.objects.Condition;
import com.henny.hennyessentials.data.objects.ConfigPage;
import com.henny.hennyessentials.task.TaskManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigManager {
    private static File cfgFile;
    public static String configDir;
    public static MainConfig CONFIG;
    public static CommandTokensConfig commandTokensConfig;
    public static AnnouncementsConfig announcementsConfig;
    public static BannedItemsConfig bannedItemsConfig;
    public static ConditionsConfig conditionsConfig;
    public static PagesConfig pagesConfig;
    public static Map<String, BannedItemsConfig.BannedItem> BANNED_ITEMS_MAP;
    public static List<Condition> conditions;
    public static Map<String, ConfigPage> PAGES;
    private static final Gson GSON;
    public static Map<String, CommandToken> TOKENS;

    public static void reloadPagesConfig() {
        File configFile = new File(configDir, "Pages.json");
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                pagesConfig = new PagesConfig();
                ConfigManager.savePagesConfig();
            }
            catch (IOException e) {
                Constants.LOG.info(e.getLocalizedMessage());
            }
        }
        try {
            pagesConfig = (PagesConfig)GSON.fromJson((Reader)new FileReader(configFile), PagesConfig.class);
            for (ConfigPage page : ConfigManager.pagesConfig.pages) {
                PAGES.put(page.pageID, page);
            }
            ConfigManager.savePagesConfig();
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to load config: {}", (Object)e.getLocalizedMessage());
        }
    }

    public static void savePagesConfig() throws IOException {
        try (FileWriter w = new FileWriter(new File(configDir, "Pages.json"));){
            w.write(GSON.toJson((Object)pagesConfig));
        }
    }

    public static void reloadConditionsConfig() {
        File configFile = new File(configDir, "Conditions.json");
        if (!configFile.exists()) {
            try {
                configFile.createNewFile();
                conditionsConfig = new ConditionsConfig();
                ConfigManager.saveConditionsConfig();
            }
            catch (IOException e) {
                Constants.LOG.info(e.getLocalizedMessage());
            }
        }
        try {
            conditionsConfig = (ConditionsConfig)GSON.fromJson((Reader)new FileReader(configFile), ConditionsConfig.class);
            conditions.clear();
            conditions.addAll(ConfigManager.conditionsConfig.conditions);
            ConfigManager.saveConditionsConfig();
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to load config: {}", (Object)e.getLocalizedMessage());
        }
    }

    public static void saveConditionsConfig() throws IOException {
        try (FileWriter w = new FileWriter(new File(configDir, "Conditions.json"));){
            w.write(GSON.toJson((Object)conditionsConfig));
        }
    }

    public static void reloadHEConfig(boolean restartTasks) {
        cfgFile = new File(configDir, "HennyEssentials.json");
        try {
            JsonObject defaultJson = GSON.toJsonTree((Object)new MainConfig()).getAsJsonObject();
            if (cfgFile.exists()) {
                JsonObject userJson = JsonParser.parseReader((Reader)new FileReader(cfgFile)).getAsJsonObject();
                ConfigManager.mergeJsonObjects(defaultJson, userJson);
            }
            CONFIG = (MainConfig)GSON.fromJson((JsonElement)defaultJson, MainConfig.class);
            ConfigManager.handleConfigUpdates();
            ConfigManager.save();
            if (restartTasks) {
                TaskManager.startHETasks();
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to load config: {}", (Object)e.getLocalizedMessage());
        }
    }

    public static void reloadCommandTokens() {
        File cmdTokensCfgFile = new File(configDir, "CommandTokens.json");
        if (cmdTokensCfgFile.exists()) {
            try {
                commandTokensConfig = (CommandTokensConfig)GSON.fromJson((Reader)new FileReader(cmdTokensCfgFile), CommandTokensConfig.class);
                for (CommandToken token : ConfigManager.commandTokensConfig.tokens) {
                    if (token.permission == null) {
                        token.permission = "";
                    }
                    if (!token.shouldWriteToAuditLog) {
                        token.shouldWriteToAuditLog = false;
                    }
                    TOKENS.put(token.alias, token);
                }
                try {
                    ConfigManager.saveCommandTokensConfig();
                }
                catch (IOException e) {
                    Constants.LOG.info("Saving command tokens error: {}", (Object)e.getLocalizedMessage());
                }
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void reloadAnnouncements() {
        File announcementsCfgFile = new File(configDir, "Announcements.json");
        if (announcementsCfgFile.exists()) {
            try {
                announcementsConfig = (AnnouncementsConfig)GSON.fromJson((Reader)new FileReader(announcementsCfgFile), AnnouncementsConfig.class);
                for (Announcement announcement : ConfigManager.announcementsConfig.announcements) {
                    if (announcement.dimensions != null) continue;
                    announcement.dimensions = new ArrayList<String>();
                }
                TaskManager.startAnnouncementTasks();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void mergeJsonObjects(JsonObject base, JsonObject override) {
        for (String key : override.keySet()) {
            JsonElement overrideElement = override.get(key);
            if (base.has(key)) {
                JsonElement baseElement = base.get(key);
                if (baseElement.isJsonObject() && overrideElement.isJsonObject()) {
                    ConfigManager.mergeJsonObjects(baseElement.getAsJsonObject(), overrideElement.getAsJsonObject());
                    continue;
                }
                base.add(key, overrideElement);
                continue;
            }
            base.add(key, overrideElement);
        }
    }

    public static void load(String configDirPath) {
        configDir = configDirPath;
        File dir = new File(configDirPath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        cfgFile = new File(configDirPath, "HennyEssentials.json");
        try {
            JsonObject defaultJson = GSON.toJsonTree((Object)new MainConfig()).getAsJsonObject();
            if (cfgFile.exists()) {
                JsonObject userJson = JsonParser.parseReader((Reader)new FileReader(cfgFile)).getAsJsonObject();
                ConfigManager.mergeJsonObjects(defaultJson, userJson);
            }
            CONFIG = (MainConfig)GSON.fromJson((JsonElement)defaultJson, MainConfig.class);
            ConfigManager.handleConfigUpdates();
            ConfigManager.save();
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to load config: {}", (Object)e.getLocalizedMessage());
        }
    }

    public static void handleConfigUpdates() {
        if (ConfigManager.CONFIG.configVersion_DO_NOT_CHANGE < 104 || ConfigManager.CONFIG.configVersion_DO_NOT_CHANGE == 104 && ConfigManager.CONFIG.configSubVersion_DO_NOT_CHANGE < 7) {
            ConfigManager.CONFIG.configVersion_DO_NOT_CHANGE = 104;
            ConfigManager.CONFIG.configSubVersion_DO_NOT_CHANGE = 7;
            if (!ConfigManager.CONFIG.permissionConfigs.permissionsEnabled && ConfigManager.CONFIG.permissionConfigs.luckPermsOverridePermissions) {
                ConfigManager.CONFIG.permissionConfigs.permissionsEnabled = true;
            }
            if (ConfigManager.CONFIG.aliasConfigs.aliasMap != null && !ConfigManager.CONFIG.aliasConfigs.aliasMap.isEmpty()) {
                for (Map.Entry<String, String> entry : ConfigManager.CONFIG.aliasConfigs.aliasMap.entrySet()) {
                    ConfigManager.CONFIG.aliasConfigs.aliasList.put(entry.getKey(), List.of(entry.getValue()));
                }
                ConfigManager.CONFIG.aliasConfigs.aliasMap.clear();
            }
        }
        ConfigManager.CONFIG.configVersion_DO_NOT_CHANGE = 104;
        ConfigManager.CONFIG.configSubVersion_DO_NOT_CHANGE = 7;
    }

    public static void loadBannedItems() {
        File bannedItemsConfigFile;
        if (!new File(configDir).exists()) {
            new File(configDir).mkdirs();
        }
        if ((bannedItemsConfigFile = new File(configDir, "BannedItems.json")).exists()) {
            try {
                bannedItemsConfig = (BannedItemsConfig)GSON.fromJson((Reader)new FileReader(bannedItemsConfigFile), BannedItemsConfig.class);
                BANNED_ITEMS_MAP.clear();
                for (BannedItemsConfig.BannedItem bi : ConfigManager.bannedItemsConfig.bannedItems) {
                    BANNED_ITEMS_MAP.put(bi.id(), bi);
                }
            }
            catch (IOException e) {
                Constants.LOG.error(e.getLocalizedMessage());
            }
        } else {
            try {
                bannedItemsConfigFile.createNewFile();
                ConfigManager.saveBannedItems();
                ConfigManager.loadBannedItems();
            }
            catch (IOException e) {
                Constants.LOG.error(e.getLocalizedMessage());
            }
        }
    }

    public static void loadAnnouncements(String cfgDir) {
        File announcementsCfgFile;
        if (!new File(cfgDir).exists()) {
            new File(cfgDir).mkdirs();
        }
        if ((announcementsCfgFile = new File(cfgDir, "Announcements.json")).exists()) {
            try {
                announcementsConfig = (AnnouncementsConfig)GSON.fromJson((Reader)new FileReader(announcementsCfgFile), AnnouncementsConfig.class);
            }
            catch (IOException e) {
                Constants.LOG.error(e.getLocalizedMessage());
            }
        } else {
            try {
                announcementsCfgFile.createNewFile();
                ConfigManager.saveAnnouncements();
                ConfigManager.loadAnnouncements(cfgDir);
            }
            catch (IOException e) {
                Constants.LOG.error(e.getLocalizedMessage());
            }
        }
    }

    public static void save() throws IOException {
        Gson versionedGson = new GsonBuilder().setVersion(104.0).setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().disableHtmlEscaping().create();
        try (FileWriter w = new FileWriter(cfgFile);){
            w.write(versionedGson.toJson((Object)CONFIG));
        }
    }

    public static void saveAnnouncements() throws IOException {
        try (FileWriter w = new FileWriter(new File(configDir, "Announcements.json"));){
            w.write(GSON.toJson((Object)announcementsConfig));
        }
    }

    public static void saveBannedItems() throws IOException {
        try (FileWriter w = new FileWriter(new File(configDir, "BannedItems.json"));){
            w.write(GSON.toJson((Object)bannedItemsConfig));
        }
    }

    public static void loadCommandTokensConfig(String configDirPath) {
        File ctokensCfgFile = new File(configDirPath, "CommandTokens.json");
        if (ctokensCfgFile.exists()) {
            try {
                commandTokensConfig = (CommandTokensConfig)GSON.fromJson((Reader)new FileReader(ctokensCfgFile), CommandTokensConfig.class);
                for (CommandToken token : ConfigManager.commandTokensConfig.tokens) {
                    if (token.permission == null) {
                        token.permission = "";
                    }
                    if (!token.shouldWriteToAuditLog) {
                        token.shouldWriteToAuditLog = false;
                    }
                    TOKENS.put(token.alias, token);
                }
                ConfigManager.saveCommandTokensConfig();
            }
            catch (Exception e) {
                Constants.LOG.info(e.getLocalizedMessage());
            }
        } else {
            try {
                ctokensCfgFile.createNewFile();
                ConfigManager.saveCommandTokensConfig();
                ConfigManager.loadCommandTokensConfig(configDirPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void saveCommandTokensConfig() throws IOException {
        try (FileWriter w = new FileWriter(new File(configDir, "CommandTokens.json"));){
            w.write(GSON.toJson((Object)commandTokensConfig));
        }
    }

    static {
        CONFIG = new MainConfig();
        commandTokensConfig = new CommandTokensConfig();
        announcementsConfig = new AnnouncementsConfig();
        bannedItemsConfig = new BannedItemsConfig();
        conditionsConfig = new ConditionsConfig();
        pagesConfig = new PagesConfig();
        BANNED_ITEMS_MAP = new HashMap<String, BannedItemsConfig.BannedItem>();
        conditions = new ArrayList<Condition>();
        PAGES = new HashMap<String, ConfigPage>();
        GSON = new GsonBuilder().setPrettyPrinting().excludeFieldsWithoutExposeAnnotation().disableHtmlEscaping().create();
        TOKENS = new HashMap<String, CommandToken>();
    }
}

