/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.config.objects;

import com.google.gson.annotations.Expose;
import com.henny.hennyessentials.Constants;
import com.henny.hennyessentials.config.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class BannedItemsConfig {
    @Expose
    public List<BannedItem> bannedItems = new ArrayList<BannedItem>();

    public void addBannedItems(String itemID, String reason) {
        try {
            this.bannedItems.add(new BannedItem(itemID, reason));
            ConfigManager.saveBannedItems();
            ConfigManager.loadBannedItems();
        }
        catch (Exception e) {
            Constants.LOG.info(e.getLocalizedMessage());
        }
    }

    public void removeBannedItems(String itemID) {
        try {
            ListIterator<BannedItem> li = this.bannedItems.listIterator();
            while (li.hasNext()) {
                BannedItem bitem = li.next();
                if (!bitem.id.equals(itemID)) continue;
                li.remove();
            }
            ConfigManager.saveBannedItems();
            ConfigManager.loadBannedItems();
        }
        catch (Exception e) {
            Constants.LOG.info(e.getLocalizedMessage());
        }
    }

    public record BannedItem(@Expose String id, @Expose String reason) {
    }
}

