/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.config.objects;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.Until;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MainConfig {
    @Expose
    public String modMessagePrefix = "\u00a78[\u00a7aHE\u00a78]";
    @Expose
    public PermissionConfigs permissionConfigs = new PermissionConfigs(this);
    @Expose
    public AliasConfigs aliasConfigs = new AliasConfigs(this);
    @Expose
    public ChatConfigs chatConfigs = new ChatConfigs(this);
    @Expose
    public ModerationConfigs moderationConfigs = new ModerationConfigs(this);
    @Expose
    public TokenConfigs tokenConfigs = new TokenConfigs(this);
    @Expose
    public CommandConfigs commandConfigs = new CommandConfigs(this);
    @Expose
    public int configVersion_DO_NOT_CHANGE = 104;
    @Expose
    public int configSubVersion_DO_NOT_CHANGE = 2;

    public class PermissionConfigs {
        @Expose
        public boolean permissionsEnabled = false;
        @Expose
        public boolean luckPermsOverridePermissions = false;
        @Expose
        public boolean shouldIncludeArgumentNodesInPermissions = false;
        @Expose
        public boolean permissionRequiredToEnterDimensions = false;
        @Expose
        public boolean permissionsRequiredForIndividualWarps = false;
        @Expose
        public String defaultDimensionNoPermsRequired = "minecraft:overworld";

        public PermissionConfigs(MainConfig this$0) {
        }
    }

    public class AliasConfigs {
        @Expose
        @Until(value=104.0)
        public Map<String, String> aliasMap = new HashMap<String, String>(){
            {
                this.put("he kits", "kits");
                this.put("he warps", "warps");
            }
        };
        @Expose
        public Map<String, List<String>> aliasList = new HashMap<String, List<String>>(){
            {
                this.put("he kits", List.of("kits", "listkits"));
                this.put("he warps", List.of("warps", "listwarps"));
            }
        };

        public AliasConfigs(MainConfig this$0) {
        }
    }

    public class ChatConfigs {
        @Expose
        public String playerChatMessageFormat = "%prefix%<%username%>%suffix%: %message%";
        @Expose
        public boolean chatFormattingEnabled = true;
        @Expose
        public boolean chatColorsEnabled = true;
        @Expose
        public boolean permissionCheckForChatColors = true;
        @Expose
        public String chatColorCode = "&";

        public ChatConfigs(MainConfig this$0) {
        }
    }

    public class ModerationConfigs {
        @Expose
        public RestartConfigs restartConfigs = new RestartConfigs(this);
        @Expose
        public BanConfigs banConfigs = new BanConfigs(this);
        @Expose
        public MuteConfigs muteConfigs = new MuteConfigs(this);
        @Expose
        public TaskConfigs taskConfigs = new TaskConfigs(this);
        @Expose
        public BannedItemsConfigs bannedItemsConfigs = new BannedItemsConfigs(this);
        @Expose
        public AuditConfigs auditConfigs = new AuditConfigs(this);
        @Expose
        public AfkConfigs afkConfigs = new AfkConfigs(this);
        @Expose
        public RulesConfigs rulesConfigs = new RulesConfigs(this);

        public ModerationConfigs(MainConfig this$0) {
        }

        public class RestartConfigs {
            @Expose
            public boolean autoRestartEnabled = true;
            @Expose
            public int restartEveryXMinutes = 360;
            @Expose
            public boolean restartWarningShouldPlaySound = true;
            @Expose
            public String restartWarningText = "\u00a76Server restarting in %m minute(s)!";
            @Expose
            public String restartText = "\u00a76Server is restarting.";
            @Expose
            public String restartDisconnectText = "\u00a76You have been disconnected because the server is restarting.";

            public RestartConfigs(ModerationConfigs this$1) {
            }
        }

        public class BanConfigs {
            @Expose
            public String bannedMessage = "\u00a7cYou are currently banned from this server for reason: %reason%";
            @Expose
            public String expiryMessage = "\u00a7cYour ban will expire in: %expiry%";

            public BanConfigs(ModerationConfigs this$1) {
            }
        }

        public class MuteConfigs {
            @Expose
            public String mutedMessage = "\u00a7cYou are currently muted from participating in chat for reason: %reason%";
            @Expose
            public String expiryMessage = "\u00a7cYour mute will expire in: %expiry%";

            public MuteConfigs(ModerationConfigs this$1) {
            }
        }

        public class TaskConfigs {
            @Expose
            public boolean shouldRunCommandPermCheckTask = true;
            @Expose
            public int checkPlayersHavePermissionsForCommandsTaskIntervalSeconds = 900;
            @Expose
            public boolean shouldRunDimensionPermCheckTask = true;
            @Expose
            public int checkPlayersHavePermissionsForDimensionTaskIntervalSeconds = 900;
            @Expose
            public int purgeExpiredWarpsTaskIntervalMinutes = 2;
            @Expose
            public int purgeExpiredBansAndMutesTaskIntervalMinutes = 5;
            @Expose
            public boolean shouldRunBannedItemsInventoryCheckTask = true;
            @Expose
            public int bannedItemsInventoryCheckTaskIntervalSeconds = 300;
            @Expose
            public boolean shouldRunPlaytimeTrackerTask = true;
            @Expose
            public int playtimeTrackerTaskIntervalSeconds = 10;

            public TaskConfigs(ModerationConfigs this$1) {
            }
        }

        public class BannedItemsConfigs {
            @Expose
            public String bannedItemMessageToPlayer = "\u00a7cThe item %item% is banned for reason: '%reason%'. It has been removed from your inventory.";
            @Expose
            public int bannedItemsPerPage = 3;
            @Expose
            public String bannedItemsListHeader = "\u00a76Banned Items";
            @Expose
            public String bannedItemsListPadding = "\u00a78~";
            @Expose
            public String bannedItemsListSeparator = "\u00a76\u2192";
            @Expose
            public boolean shouldRemoveBannedItemFromPlayer = true;

            public BannedItemsConfigs(ModerationConfigs this$1) {
            }
        }

        public class AuditConfigs {
            @Expose
            public String auditLogTimestampFormat = "yyyy-MM-dd HH:mm:ss";
            @Expose
            public boolean shouldWriteBansToAuditLog = true;
            @Expose
            public boolean shouldWriteMutesToAuditLog = true;
            @Expose
            public boolean shouldWriteBannedItemPickupToAuditLog = true;
            @Expose
            public boolean shouldWriteCommandTokenUsagesToAuditLog = false;

            public AuditConfigs(ModerationConfigs this$1) {
            }
        }

        public class AfkConfigs {
            @Expose
            public int afkTimeoutSeconds = 600;
            @Expose
            public String afkMessageToPlayer = "\u00a76You are now AFK.";
            @Expose
            public String afkReturnMessageToPlayer = "\u00a76You are no longer AFK.";
            @Expose
            public boolean broadcastAFKToEntireServer = false;
            @Expose
            public String broadcastAFKToServerMessage = "\u00a76%playername% is now AFK.";
            @Expose
            public String broadcastReturnToServerMessage = "\u00a76%playername% is no longer AFK.";
            @Expose
            public int kickAFKPlayerAfterXSeconds = 600;
            @Expose
            public boolean enableAFKKick = true;
            @Expose
            public String afkKickMessage = "\u00a76You have been kicked for being AFK too long.";
            @Expose
            public boolean rightClickItemCountsAsMovement = true;
            @Expose
            public boolean rightClickBlockCountsAsMovement = true;
            @Expose
            public boolean chatMessageOrCommandCountsAsMovement = true;
            @Expose
            public boolean shouldAFKCountAsPlaytime = false;

            public AfkConfigs(ModerationConfigs this$1) {
            }
        }

        public class RulesConfigs {
            @Expose
            public String rulesPageHeader = "\u00a76Server Rules";
            @Expose
            public String rulesPagePadding = "\u00a78~";
            @Expose
            public int rulesPerPage = 5;
            @Expose
            public List<String> rules = new ArrayList<String>(){
                {
                    this.add("1. Be kind.");
                    this.add("2. Do not grief.");
                }
            };

            public RulesConfigs(ModerationConfigs this$1) {
            }
        }
    }

    public class TokenConfigs {
        @Expose
        public String lockedTokenNoPermissionMessage = "\u00a7cThis token does not belong to you!";
        @Expose
        public String tokenNoPermissionMessage = "\u00a7cYou do not have the required permission to use this token";
        @Expose
        public String usageLoreText = "\u00a78Right click with token in hand to redeem.";
        @Expose
        public String reusableText = "\u00a76This token is reusable.";
        @Expose
        public String maxUsagesText = "\u00a7cYou have reached your maximum number of uses for this token.";

        public TokenConfigs(MainConfig this$0) {
        }
    }

    public class CommandConfigs {
        @Expose
        public WarpConfigs warpConfigs = new WarpConfigs(this);
        @Expose
        public KitConfigs kitConfigs = new KitConfigs(this);
        @Expose
        public TeleportConfigs teleportConfigs = new TeleportConfigs(this);
        @Expose
        public PlayerCommandConfigs playerCommandConfigs = new PlayerCommandConfigs(this);
        @Expose
        public VanishConfigs vanishConfigs = new VanishConfigs(this);

        public CommandConfigs(MainConfig this$0) {
        }

        public void validate() {
            if (this.warpConfigs == null) {
                this.warpConfigs = new WarpConfigs(this);
            }
            if (this.kitConfigs == null) {
                this.kitConfigs = new KitConfigs(this);
            }
            if (this.teleportConfigs == null) {
                this.teleportConfigs = new TeleportConfigs(this);
            }
            if (this.playerCommandConfigs == null) {
                this.playerCommandConfigs = new PlayerCommandConfigs(this);
            }
        }

        public class WarpConfigs {
            @Expose
            public int cooldownSeconds = 10;
            @Expose
            public boolean warpCommandEnabled = true;
            @Expose
            public String noPermissionForWarpMessage = "You do not have permission to access the warp: %warpname%";
            @Expose
            public boolean shouldUseInventoryMenuForWarps = true;

            public WarpConfigs(CommandConfigs this$1) {
            }
        }

        public class KitConfigs {
            @Expose
            public boolean kitsEnabled = true;
            @Expose
            public boolean claimingKitsPlaysSound = true;
            @Expose
            public boolean shouldUseInventoryMenuForKits = true;

            public KitConfigs(CommandConfigs this$1) {
            }
        }

        public class TeleportConfigs {
            @Expose
            public boolean tpaCommandsEnabled = true;
            @Expose
            public boolean homeCommandsEnabled = true;
            @Expose
            public boolean spawnCommandEnabled = true;
            @Expose
            public boolean setSpawnCommandEnabled = true;
            @Expose
            public boolean spawnCommandAlwaysTeleportsToOverworld = true;
            @Expose
            public boolean backCommandSavesLastTeleport = false;
            @Expose
            public boolean teleportsShouldEnforceNoMovementWhileWaitingForWarmup = true;
            @Expose
            public int defaultNumberOfHomes = 3;
            @Expose
            public int homeCommandWarmupSeconds = 3;
            @Expose
            public int spawnCommandWarmupSeconds = 3;
            @Expose
            public int backCommandWarmupSeconds = 3;
            @Expose
            public int warpCommandWarmupSeconds = 3;
            @Expose
            public int tpaCommandWarmupSeconds = 3;
            @Expose
            public int tpaCommandCooldownSeconds = 5;
            @Expose
            public int homeCommandCooldownSeconds = 5;
            @Expose
            public int backCommandCooldownSeconds = 30;
            @Expose
            public String tpaRequestSentText = "\u00a7aTPA request sent.";
            @Expose
            public String tpaRequestText = "\u00a76%playername% \u00a7ais requesting to teleport to you";
            @Expose
            public String tpaHereRequestText = "\u00a76%playername% \u00a7ais requesting that you teleport to them";
            @Expose
            public String beforeTPText = "\u00a7aYou will be teleported in %warmupseconds% seconds. Please do not move...";
            @Expose
            public String teleportCancelledText = "\u00a7cYou moved! Teleport cancelled.";
            @Expose
            public String tpaErrorText = "\u00a7cError completing TPA request.";
            @Expose
            public String tpaRequestAcceptText = "\u00a7aTPA request accepted";
            @Expose
            public String tpaAcceptText = "\u00a7a[ACCEPT]";
            @Expose
            public String tpaAcceptHoverText = "\u00a7aClick here to ACCEPT this TPA request";
            @Expose
            public String tpaDenyText = "\u00a7c[DENY]";
            @Expose
            public String tpaDenyHoverText = "\u00a7cClick here to DENY this TPA request";
            @Expose
            public String tpaNoPermissionDimension = "\u00a7cYou do not have permission to TPA to the dimension: %dimension%";
            @Expose
            public String normalTeleportToDimNoPermission = "\u00a7cYou do not have permission be in the dimension: %dimension%";
            @Expose
            public String backCommandNoSavedDeathLocation = "\u00a7cCouldn't find a valid death location to teleport back to.";
            @Expose
            public String backCommandTeleportSuccess = "\u00a7aTeleporting you back to your last location...";
            @Expose
            public String backCommandNoSafeLocationFound = "\u00a7cCouldn't find a safe location near your death point.";
            @Expose
            public String setHomeText = "\u00a7aSet home with name: \u00a76%homename%";
            @Expose
            public String delHomeText = "\u00a7cRemoved home with name: \u00a76%homename%";
            @Expose
            public String maxHomesText = "\u00a7cYou have reached your maximum number of homes: \u00a76%maxhomes%\u00a7c.";
            @Expose
            public String homeListHeader = "\u00a76Home List";
            @Expose
            public String homeListPadding = "\u00a78~";
            @Expose
            public int homeListLinesPerPage = 5;
            @Expose
            public String failedToSetHomeText = "\u00a7cFailed to set home with name: \u00a76%homename%\u00a7c. Do you already have a home by that name?";
            @Expose
            public String failedToDelHomeText = "\u00a7cFailed to remove home with name: \u00a76%homename%\u00a7c. Are you sure you have a home by that name?";

            public TeleportConfigs(CommandConfigs this$1) {
            }
        }

        public class PlayerCommandConfigs {
            @Expose
            public boolean vanishCommandEnabled = true;
            @Expose
            public String vanishText = "\u00a7aVanish mode set to:\u00a76 %b";
            @Expose
            public boolean feedCommandEnabled = true;
            @Expose
            public boolean healCommandEnabled = true;
            @Expose
            public boolean repairCommandEnabled = true;
            @Expose
            public boolean flyCommandEnabled = true;
            @Expose
            public boolean enderChestCommandEnabled = true;
            @Expose
            public boolean adminViewPlayerEnderChestCommandEnabled = true;
            @Expose
            public String flyText = "\u00a7aFly mode set to:\u00a76 %b";
            @Expose
            public String playtimeText = "\u00a7aYour playtime is:\u00a76 %playtime%";

            public PlayerCommandConfigs(CommandConfigs this$1) {
            }
        }

        public class VanishConfigs {
            @Expose
            public boolean EXPERIMENTAL_shouldHideVanishedPlayersFromTabList = false;

            public VanishConfigs(CommandConfigs this$1) {
            }
        }
    }
}

