/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.data;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.data.objects.SpawnPosData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class HEData
extends SavedData {
    public Map<String, SpawnPosData> SPAWN_DATA = new HashMap<String, SpawnPosData>();

    public HEData(Map<String, SpawnPosData> SPAWN_DATA) {
        this.SPAWN_DATA = SPAWN_DATA;
    }

    public HEData() {
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag HEDataTag = new CompoundTag();
        CompoundTag spawnDataTag = new CompoundTag();
        for (Map.Entry<String, SpawnPosData> entry : this.SPAWN_DATA.entrySet()) {
            CompoundTag individualSpawnDataTag = new CompoundTag();
            individualSpawnDataTag.putString("dimension", entry.getValue().pos.dimension().location().toString());
            individualSpawnDataTag.put("blockPos", NbtUtils.writeBlockPos((BlockPos)entry.getValue().pos.pos()));
            individualSpawnDataTag.putFloat("rotation", entry.getValue().rotation);
            spawnDataTag.put(entry.getKey(), (Tag)individualSpawnDataTag);
        }
        HEDataTag.put("spawnData", (Tag)spawnDataTag);
        compoundTag.put("HEData", (Tag)HEDataTag);
        return compoundTag;
    }

    private static HEData load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        HashMap<String, SpawnPosData> TEMP_SPAWN_DATA = new HashMap<String, SpawnPosData>();
        CompoundTag HEDataTag = compoundTag.getCompound("HEData");
        CompoundTag spawnDataTag = HEDataTag.getCompound("spawnData");
        for (String spawnDataKey : spawnDataTag.getAllKeys()) {
            CompoundTag individualSpawnDataTag = spawnDataTag.getCompound(spawnDataKey);
            String dimension = individualSpawnDataTag.getString("dimension");
            BlockPos pos = (BlockPos)NbtUtils.readBlockPos((CompoundTag)individualSpawnDataTag, (String)"blockPos").get();
            float rotation = individualSpawnDataTag.getFloat("rotation");
            SpawnPosData spd = new SpawnPosData();
            spd.pos = GlobalPos.of((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dimension)), (BlockPos)pos);
            spd.rotation = rotation;
            TEMP_SPAWN_DATA.put(dimension, spd);
        }
        return new HEData(TEMP_SPAWN_DATA);
    }

    public static SavedData.Factory<HEData> factory() {
        return new SavedData.Factory(HEData::new, HEData::load, DataFixTypes.LEVEL);
    }

    public static HEData getHEData() {
        return (HEData)CommonClass.minecraftServer.overworld().getDataStorage().computeIfAbsent(HEData.factory(), "hennyessentials-hedata");
    }

    public void addSpawnPoint(SpawnPosData spd) {
        this.SPAWN_DATA.put(spd.pos.dimension().location().toString(), spd);
        this.setDirty();
    }
}

