/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.data;

import com.henny.hennyessentials.data.objects.Kit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public class KitData
extends SavedData {
    public Map<String, Kit> kits;

    public KitData() {
        this.kits = new HashMap<String, Kit>();
    }

    public KitData(Map<String, Kit> kits) {
        this.kits = kits;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag kitList = new CompoundTag();
        for (Kit kit : this.kits.values()) {
            CompoundTag kitTag = new CompoundTag();
            kitTag.putString("name", kit.name);
            kitTag.putInt("cooldownSeconds", kit.cooldownSeconds);
            ListTag itemList = new ListTag();
            for (ItemStack itemStack : kit.items) {
                CompoundTag individualItemTag = new CompoundTag();
                if (itemStack.isEmpty()) continue;
                itemList.add((Object)itemStack.save(provider, (Tag)individualItemTag));
            }
            if (kit.displayItem.isEmpty()) {
                Tag displayItemTag = kit.displayItem.save(provider);
                kitTag.put("displayItem", displayItemTag);
            }
            if (!kit.categoryDisplayItem.isEmpty()) {
                Tag categoryDisplayItemTag = kit.categoryDisplayItem.save(provider);
                kitTag.put("categoryDisplayItem", categoryDisplayItemTag);
            }
            kitTag.put("items", (Tag)itemList);
            if (kit.category != null) {
                kitTag.putString("category", kit.category);
            }
            kitList.put(kit.name, (Tag)kitTag);
        }
        compoundTag.put("kits", (Tag)kitList);
        return compoundTag;
    }

    private static KitData load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        HashMap<String, Kit> kitListTemp = new HashMap<String, Kit>();
        CompoundTag kitsTag = compoundTag.getCompound("kits");
        for (String kit : kitsTag.getAllKeys()) {
            CompoundTag kitCompound = kitsTag.getCompound(kit);
            String kitName = kitCompound.getString("name");
            kitName = kitName.toLowerCase();
            int kitCooldownSeconds = kitCompound.getInt("cooldownSeconds");
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ListTag kitItemList = (ListTag)kitCompound.get("items");
            kitItemList.forEach(tag -> items.add(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)tag))));
            Kit newKit = new Kit(kitName, kitCooldownSeconds, items);
            if (kitCompound.contains("displayItem")) {
                ItemStack displayItem;
                newKit.displayItem = displayItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)kitCompound.get("displayItem")));
            }
            if (kitCompound.contains("categoryDisplayItem")) {
                ItemStack categoryDisplayItem;
                newKit.categoryDisplayItem = categoryDisplayItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)kitCompound.get("categoryDisplayItem")));
            }
            if (kitCompound.contains("category")) {
                newKit.category = kitCompound.getString("category");
            }
            kitListTemp.put(kitName, newKit);
        }
        return new KitData(kitListTemp);
    }

    public void addKit(Kit kit) {
        kit.name = kit.name.toLowerCase();
        this.kits.put(kit.name, kit);
        this.setDirty();
    }

    public void removeKit(String kitName) {
        this.kits.remove(kitName);
        this.setDirty();
    }

    public void setKitDisplayItem(String kitName, ItemStack item) {
        if (this.kits.containsKey(kitName)) {
            this.kits.get((Object)kitName).displayItem = item.copy();
        }
        this.setDirty();
    }

    public void setCategoryDisplayItem(String categoryName, ItemStack item) {
        for (Kit k : this.kits.values()) {
            if (!Objects.equals(k.category, categoryName)) continue;
            k.categoryDisplayItem = item.copy();
        }
        this.setDirty();
    }

    public void editKit(String kitName, List<ItemStack> newItems) {
        if (this.kits.containsKey(kitName)) {
            Kit kit = this.kits.get(kitName);
            kit.items.clear();
            kit.items.addAll(newItems);
        }
        this.setDirty();
    }

    public boolean currentlyMoreThanOneCategory() {
        HashSet<String> counter = new HashSet<String>();
        for (Kit k : this.kits.values()) {
            counter.add(k.category);
        }
        return counter.size() != 1;
    }

    public static void createKitFromWorldItems(String name, int cooldownSeconds, List<ItemStack> items) {
    }

    public static SavedData.Factory<KitData> factory() {
        return new SavedData.Factory(KitData::new, KitData::load, DataFixTypes.LEVEL);
    }

    public static KitData getKitData(MinecraftServer minecraftServer) {
        return (KitData)minecraftServer.overworld().getDataStorage().computeIfAbsent(KitData.factory(), "hennyessentials-kits");
    }
}

