/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.data;

import com.henny.hennyessentials.CommonClass;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class PermissionGroupData
extends SavedData {
    public Map<String, List<String>> groupPermissions;
    public Map<String, Component> groupPrefixes;
    public Map<String, Component> groupSuffixes;

    public PermissionGroupData(Map<String, List<String>> groupPermissions, Map<String, Component> groupPrefixes, Map<String, Component> groupSuffixes) {
        this.groupPermissions = groupPermissions;
        this.groupPrefixes = groupPrefixes;
        this.groupSuffixes = groupSuffixes;
    }

    public PermissionGroupData() {
        this.groupPermissions = new HashMap<String, List<String>>();
        this.groupPrefixes = new HashMap<String, Component>();
        this.groupSuffixes = new HashMap<String, Component>();
    }

    public static SavedData.Factory<PermissionGroupData> factory() {
        return new SavedData.Factory(PermissionGroupData::new, PermissionGroupData::load, DataFixTypes.LEVEL);
    }

    private static PermissionGroupData load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        HashMap<String, List<String>> allGroupPermsTempList = new HashMap<String, List<String>>();
        HashMap<String, Component> allGroupPrefixesList = new HashMap<String, Component>();
        HashMap<String, Component> allGroupSuffixesList = new HashMap<String, Component>();
        CompoundTag groupPermsTag = compoundTag.getCompound("groupPerms");
        CompoundTag groupPrefixesTag = compoundTag.getCompound("groupPrefixes");
        CompoundTag groupSuffixesTag = compoundTag.getCompound("groupSuffixes");
        for (String groupName : groupPermsTag.getAllKeys()) {
            ArrayList<String> specificGroupPermsTempList = new ArrayList<String>();
            ListTag specificGroupPermsNBTList = (ListTag)groupPermsTag.get(groupName);
            specificGroupPermsNBTList.forEach(tag -> specificGroupPermsTempList.add(tag.getAsString()));
            if (!specificGroupPermsTempList.stream().anyMatch(s -> s.startsWith("weight."))) {
                specificGroupPermsTempList.add("weight.1");
            }
            allGroupPermsTempList.put(groupName, specificGroupPermsTempList);
        }
        for (String groupName : groupPrefixesTag.getAllKeys()) {
            String prefix = groupPrefixesTag.getString(groupName);
            allGroupPrefixesList.put(groupName, (Component)Component.Serializer.fromJsonLenient((String)prefix, (HolderLookup.Provider)provider));
        }
        for (String groupName : groupSuffixesTag.getAllKeys()) {
            String suffix = groupSuffixesTag.getString(groupName);
            allGroupSuffixesList.put(groupName, (Component)Component.Serializer.fromJsonLenient((String)suffix, (HolderLookup.Provider)provider));
        }
        return new PermissionGroupData(allGroupPermsTempList, allGroupPrefixesList, allGroupSuffixesList);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag groupPerms = new CompoundTag();
        CompoundTag groupPrefxs = new CompoundTag();
        CompoundTag groupSuffxs = new CompoundTag();
        for (Map.Entry<String, List<String>> entry : this.groupPermissions.entrySet()) {
            ListTag individualGroupPerms = new ListTag();
            for (String individualPermNode : entry.getValue()) {
                individualGroupPerms.add((Object)StringTag.valueOf((String)individualPermNode));
            }
            groupPerms.put(entry.getKey(), (Tag)individualGroupPerms);
        }
        for (Map.Entry<String, List<String>> entry : this.groupPrefixes.entrySet()) {
            Component prefix = (Component)entry.getValue();
            String prefixString = Component.Serializer.toJson((Component)prefix, (HolderLookup.Provider)provider);
            groupPrefxs.put(entry.getKey(), (Tag)StringTag.valueOf((String)prefixString));
        }
        for (Map.Entry<String, List<String>> entry : this.groupSuffixes.entrySet()) {
            Component suffix = (Component)entry.getValue();
            String suffixString = Component.Serializer.toJson((Component)suffix, (HolderLookup.Provider)provider);
            groupSuffxs.put(entry.getKey(), (Tag)StringTag.valueOf((String)suffixString));
        }
        compoundTag.put("groupPerms", (Tag)groupPerms);
        compoundTag.put("groupPrefixes", (Tag)groupPrefxs);
        compoundTag.put("groupSuffixes", (Tag)groupSuffxs);
        return compoundTag;
    }

    public static List<String> getPermissionsForGroup(String group, MinecraftServer server) {
        return PermissionGroupData.getPermissionGroupData((MinecraftServer)CommonClass.minecraftServer).groupPermissions.getOrDefault(group, List.of(""));
    }

    public static boolean permissionCheckGroup(String groupName, String permission, MinecraftServer minecraftServer) {
        String commandWildcard;
        PermissionGroupData perms = PermissionGroupData.getPermissionGroupData(minecraftServer);
        List groupPerms = perms.groupPermissions.getOrDefault(groupName, List.of());
        if (groupPerms.contains(permission)) {
            return true;
        }
        String[] parts = permission.split("\\.");
        if (parts.length >= 2 && groupPerms.contains(commandWildcard = parts[0] + "." + parts[1] + ".*")) {
            return true;
        }
        if (groupPerms.contains(parts[0] + ".*")) {
            return true;
        }
        for (String group : groupPerms) {
            String inheritedGroup;
            if (!group.startsWith("group.") || !PermissionGroupData.permissionCheckGroup(inheritedGroup = group.substring(6), permission, minecraftServer)) continue;
            return true;
        }
        return false;
    }

    public void addGroupPermission(String groupName, String permission) {
        List<String> groupPermList;
        if (!this.groupPermissions.containsKey(groupName)) {
            this.groupPermissions.put(groupName, new ArrayList());
        }
        if (!(groupPermList = this.groupPermissions.get(groupName)).contains(permission.toLowerCase())) {
            groupPermList.add(permission.toLowerCase());
        }
        this.groupPermissions.put(groupName, groupPermList);
        this.setDirty();
    }

    public void removeGroupPermission(String groupName, String permission) {
        if (!this.groupPermissions.containsKey(groupName)) {
            this.groupPermissions.put(groupName, new ArrayList());
        }
        List<String> groupPermList = this.groupPermissions.get(groupName);
        groupPermList.removeIf(next -> Objects.equals(next, permission));
        this.groupPermissions.put(groupName, groupPermList);
        this.setDirty();
    }

    public static Optional<String> findHighestWeightedGroup(List<String> groups, MinecraftServer minecraftServer) {
        return groups.stream().max(Comparator.comparingInt(group -> PermissionGroupData.getGroupWeight(group, minecraftServer)));
    }

    public static Optional<Component> getGroupPrefix(String group, MinecraftServer minecraftServer) {
        PermissionGroupData perms = PermissionGroupData.getPermissionGroupData(minecraftServer);
        return Optional.ofNullable(perms.groupPrefixes.get(group));
    }

    public static Optional<Component> getGroupSuffix(String group, MinecraftServer minecraftServer) {
        PermissionGroupData perms = PermissionGroupData.getPermissionGroupData(minecraftServer);
        return Optional.ofNullable(perms.groupSuffixes.get(group));
    }

    public static int getGroupWeight(String group, MinecraftServer minecraftServer) {
        return PermissionGroupData.getPermissionGroupData((MinecraftServer)minecraftServer).groupPermissions.getOrDefault(group, List.of()).stream().filter(perm -> perm.startsWith("weight.")).mapToInt(perm -> Integer.parseInt(perm.replace("weight.", ""))).max().orElse(0);
    }

    public void addGroupPrefix(String groupName, Component prefix) {
        this.groupPrefixes.put(groupName, prefix);
        this.setDirty();
    }

    public void removeGroupPrefix(String groupName) {
        this.groupPrefixes.remove(groupName);
        this.setDirty();
    }

    public void addGroupSuffix(String groupName, Component suffix) {
        this.groupSuffixes.put(groupName, suffix);
        this.setDirty();
    }

    public void removeGroupSuffix(String groupName) {
        this.groupSuffixes.remove(groupName);
        this.setDirty();
    }

    public static PermissionGroupData getPermissionGroupData(MinecraftServer minecraftServer) {
        return (PermissionGroupData)minecraftServer.overworld().getDataStorage().computeIfAbsent(PermissionGroupData.factory(), "hennyessentials-permissions-group");
    }
}

