/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.data;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.data.PermissionGroupData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;

public class PermissionUserData
extends SavedData {
    public Map<UUID, List<String>> userPermissions;
    public Map<UUID, Component> userPrefixes;
    public Map<UUID, Component> userSuffixes;

    public PermissionUserData(Map<UUID, List<String>> userPermissions, Map<UUID, Component> userPrefixes, Map<UUID, Component> userSuffixes) {
        this.userPermissions = userPermissions;
        this.userPrefixes = userPrefixes;
        this.userSuffixes = userSuffixes;
    }

    public PermissionUserData() {
        this.userPermissions = new HashMap<UUID, List<String>>();
        this.userPrefixes = new HashMap<UUID, Component>();
        this.userSuffixes = new HashMap<UUID, Component>();
    }

    public static SavedData.Factory<PermissionUserData> factory() {
        return new SavedData.Factory(PermissionUserData::new, PermissionUserData::load, DataFixTypes.LEVEL);
    }

    private static PermissionUserData load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        HashMap<UUID, List<String>> allUserPermsTempList = new HashMap<UUID, List<String>>();
        HashMap<UUID, Component> allUserPrefixesList = new HashMap<UUID, Component>();
        HashMap<UUID, Component> allUserSuffixesList = new HashMap<UUID, Component>();
        CompoundTag userPermsTag = compoundTag.getCompound("userPerms");
        CompoundTag userPrefixesTag = compoundTag.getCompound("userPrefixes");
        CompoundTag userSuffixesTag = compoundTag.getCompound("userSuffixes");
        for (String uuid : userPermsTag.getAllKeys()) {
            ArrayList specificGroupPermsTempList = new ArrayList();
            ListTag specificGroupPermsNBTList = (ListTag)userPermsTag.get(uuid);
            specificGroupPermsNBTList.forEach(tag -> specificGroupPermsTempList.add(tag.getAsString()));
            allUserPermsTempList.put(UUID.fromString(uuid), specificGroupPermsTempList);
        }
        for (String userUUID : userPrefixesTag.getAllKeys()) {
            String prefix = userPrefixesTag.getString(userUUID);
            allUserPrefixesList.put(UUID.fromString(userUUID), (Component)Component.Serializer.fromJsonLenient((String)prefix, (HolderLookup.Provider)provider));
        }
        for (String userUUID : userSuffixesTag.getAllKeys()) {
            String suffix = userSuffixesTag.getString(userUUID);
            allUserSuffixesList.put(UUID.fromString(userUUID), (Component)Component.Serializer.fromJsonLenient((String)suffix, (HolderLookup.Provider)provider));
        }
        return new PermissionUserData(allUserPermsTempList, allUserPrefixesList, allUserSuffixesList);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag userPerms = new CompoundTag();
        CompoundTag userPrefxs = new CompoundTag();
        CompoundTag userSuffxs = new CompoundTag();
        for (Map.Entry<UUID, List<String>> entry : this.userPermissions.entrySet()) {
            ListTag individualUserPerms = new ListTag();
            for (String individualPermNode : entry.getValue()) {
                individualUserPerms.add((Object)StringTag.valueOf((String)individualPermNode));
            }
            userPerms.put(String.valueOf(entry.getKey()), (Tag)individualUserPerms);
        }
        for (Map.Entry<UUID, List<String>> entry : this.userPrefixes.entrySet()) {
            Component prefix = (Component)entry.getValue();
            String prefixString = Component.Serializer.toJson((Component)prefix, (HolderLookup.Provider)provider);
            userPrefxs.put(String.valueOf(entry.getKey()), (Tag)StringTag.valueOf((String)prefixString));
        }
        for (Map.Entry<UUID, List<String>> entry : this.userSuffixes.entrySet()) {
            Component suffix = (Component)entry.getValue();
            String suffixString = Component.Serializer.toJson((Component)suffix, (HolderLookup.Provider)provider);
            userSuffxs.put(String.valueOf(entry.getKey()), (Tag)StringTag.valueOf((String)suffixString));
        }
        compoundTag.put("userPerms", (Tag)userPerms);
        compoundTag.put("userPrefixes", (Tag)userPrefxs);
        compoundTag.put("userSuffixes", (Tag)userSuffxs);
        return compoundTag;
    }

    public static List<String> getPermissionsForUser(UUID uuid) {
        return PermissionUserData.getPermissionUserData((MinecraftServer)CommonClass.minecraftServer).userPermissions.get(uuid);
    }

    public void addUserPermission(UUID user, String permission) {
        List<String> userPermList;
        permission = permission.toLowerCase();
        if (!this.userPermissions.containsKey(user)) {
            this.userPermissions.put(user, new ArrayList());
        }
        if (!(userPermList = this.userPermissions.get(user)).contains(permission)) {
            userPermList.add(permission);
        }
        this.userPermissions.put(user, userPermList);
        this.setDirty();
    }

    public void removeUserPermission(UUID user, String permission) {
        if (!this.userPermissions.containsKey(user)) {
            this.userPermissions.put(user, new ArrayList());
        }
        List<String> userPermList = this.userPermissions.get(user);
        userPermList.removeIf(next -> Objects.equals(next, permission));
        this.userPermissions.put(user, userPermList);
        this.setDirty();
    }

    public static boolean permissionCheckUser(UUID uuid, String permission, MinecraftServer minecraftServer) {
        String commandWildcard;
        PermissionUserData perms = PermissionUserData.getPermissionUserData(minecraftServer);
        if (!perms.userPermissions.containsKey(uuid)) {
            return false;
        }
        List<String> userPerms = perms.userPermissions.get(uuid);
        if (userPerms.contains(permission)) {
            return true;
        }
        String[] parts = permission.split("\\.");
        if (parts.length >= 2 && userPerms.contains(commandWildcard = parts[0] + "." + parts[1] + ".*")) {
            return true;
        }
        return userPerms.contains(parts[0] + ".*");
    }

    public static String getUserHighestGroup(UUID uuid, MinecraftServer minecraftServer) {
        PermissionUserData perms = PermissionUserData.getPermissionUserData(minecraftServer);
        if (!perms.userPermissions.containsKey(uuid)) {
            return "";
        }
        List<String> userGroups = perms.userPermissions.get(uuid).stream().filter(s -> s.startsWith("group.")).toList();
        return PermissionGroupData.findHighestWeightedGroup(userGroups, minecraftServer).orElse("");
    }

    public static MutableComponent getChatPrefix(UUID uuid, MinecraftServer minecraftServer) {
        List<String> userGroups = PermissionUserData.getAllUserGroupMemberships(uuid);
        HashMap<Integer, Component> prefixes = new HashMap<Integer, Component>();
        for (String string : userGroups) {
            PermissionGroupData.getGroupPrefix(string, minecraftServer).ifPresent(component -> prefixes.put(PermissionGroupData.getGroupWeight(string, minecraftServer), (Component)component));
        }
        int userPrefixWeight = 0;
        for (String perm : PermissionUserData.getPermissionUserData((MinecraftServer)minecraftServer).userPermissions.getOrDefault(uuid, List.of(""))) {
            if (!perm.startsWith("weight.")) continue;
            userPrefixWeight = Integer.valueOf(perm.replace("weight.", ""));
        }
        prefixes.put(userPrefixWeight, PermissionUserData.getPermissionUserData((MinecraftServer)minecraftServer).userPrefixes.getOrDefault(uuid, (Component)Component.literal((String)"")));
        Optional<Component> optional = prefixes.entrySet().stream().filter(entry -> !((Component)entry.getValue()).getString().isBlank()).max(Map.Entry.comparingByKey()).map(Map.Entry::getValue);
        MutableComponent prefixComp = Component.literal((String)"");
        optional.ifPresent(arg_0 -> ((MutableComponent)prefixComp).append(arg_0));
        return prefixComp;
    }

    public static MutableComponent getChatSuffix(UUID uuid, MinecraftServer minecraftServer) {
        List<String> userGroups = PermissionUserData.getAllUserGroupMemberships(uuid);
        HashMap<Integer, Component> suffixes = new HashMap<Integer, Component>();
        for (String string : userGroups) {
            PermissionGroupData.getGroupSuffix(string, minecraftServer).ifPresent(component -> suffixes.put(PermissionGroupData.getGroupWeight(string, minecraftServer), (Component)component));
        }
        int userSuffixWeight = 0;
        for (String perm : PermissionUserData.getPermissionUserData((MinecraftServer)minecraftServer).userPermissions.getOrDefault(uuid, List.of(""))) {
            if (!perm.startsWith("weight.")) continue;
            userSuffixWeight = Integer.valueOf(perm.replace("weight.", ""));
        }
        suffixes.put(userSuffixWeight, PermissionUserData.getPermissionUserData((MinecraftServer)minecraftServer).userSuffixes.getOrDefault(uuid, (Component)Component.literal((String)"")));
        Optional<Component> optional = suffixes.entrySet().stream().filter(entry -> !((Component)entry.getValue()).getString().isBlank()).max(Map.Entry.comparingByKey()).map(Map.Entry::getValue);
        MutableComponent suffixComp = Component.literal((String)"");
        optional.ifPresent(arg_0 -> ((MutableComponent)suffixComp).append(arg_0));
        return suffixComp;
    }

    public static List<String> getAllUserGroupMemberships(UUID uuid) {
        PermissionUserData perms = PermissionUserData.getPermissionUserData(CommonClass.minecraftServer);
        if (!perms.userPermissions.containsKey(uuid)) {
            return List.of();
        }
        return perms.userPermissions.get(uuid).stream().filter(s -> s.startsWith("group.")).map(s -> s.replace("group.", "")).toList();
    }

    public void addUserPrefix(UUID userUUID, Component prefix) {
        this.userPrefixes.put(userUUID, prefix);
        this.setDirty();
    }

    public void removeUserPrefix(UUID userUUID) {
        this.userPrefixes.remove(userUUID);
        this.setDirty();
    }

    public void addUserSuffix(UUID userUUID, Component prefix) {
        this.userSuffixes.put(userUUID, prefix);
        this.setDirty();
    }

    public void removeUserSuffix(UUID userUUID) {
        this.userSuffixes.remove(userUUID);
        this.setDirty();
    }

    public static PermissionUserData getPermissionUserData(MinecraftServer minecraftServer) {
        return (PermissionUserData)minecraftServer.overworld().getDataStorage().computeIfAbsent(PermissionUserData.factory(), "hennyessentials-permissions-user");
    }
}

