/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.data;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.data.objects.Ban;
import com.henny.hennyessentials.data.objects.HEPlayer;
import com.henny.hennyessentials.data.objects.Home;
import com.henny.hennyessentials.data.objects.Mute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.Nullable;

public class PlayerData
extends SavedData {
    public Map<UUID, HEPlayer> HEPlayerData;
    public Map<UUID, Ban> bannedPlayers = new HashMap<UUID, Ban>();
    public Map<UUID, Mute> mutedPlayers = new HashMap<UUID, Mute>();

    public PlayerData() {
        this.HEPlayerData = new HashMap<UUID, HEPlayer>();
        this.bannedPlayers = new HashMap<UUID, Ban>();
        this.mutedPlayers = new HashMap<UUID, Mute>();
    }

    public PlayerData(Map<UUID, HEPlayer> HEPlayerData, Map<UUID, Ban> banMap, Map<UUID, Mute> muteMap) {
        this.HEPlayerData = HEPlayerData;
        this.bannedPlayers = banMap;
        this.mutedPlayers = muteMap;
    }

    public static SavedData.Factory<PlayerData> factory() {
        return new SavedData.Factory(PlayerData::new, PlayerData::load, DataFixTypes.LEVEL);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag parentPlayerData = new CompoundTag();
        CompoundTag parentBanData = new CompoundTag();
        CompoundTag parentMuteData = new CompoundTag();
        for (Map.Entry<UUID, HEPlayer> entry : this.HEPlayerData.entrySet()) {
            CompoundTag individualPlayerTag = new CompoundTag();
            UUID uuid = entry.getKey();
            HEPlayer playerData = entry.getValue();
            CompoundTag kitCooldownList = new CompoundTag();
            CompoundTag warpCooldownList = new CompoundTag();
            CompoundTag commandCooldownList = new CompoundTag();
            CompoundTag playerInfoMap = new CompoundTag();
            CompoundTag playerHomes = new CompoundTag();
            for (Map.Entry<String, Long> entry2 : playerData.kitCooldowns.entrySet()) {
                kitCooldownList.putLong(entry2.getKey(), entry2.getValue().longValue());
            }
            for (Map.Entry<String, Object> entry3 : playerData.homeList.entrySet()) {
                CompoundTag homeTag = new CompoundTag();
                Home home = (Home)entry3.getValue();
                homeTag.put("blockPos", NbtUtils.writeBlockPos((BlockPos)home.pos.pos()));
                homeTag.putString("name", home.name);
                homeTag.putString("dimension", home.pos.dimension().location().toString());
                playerHomes.put(home.name, (Tag)homeTag);
            }
            for (Map.Entry<String, Object> entry4 : playerData.playerInfo.entrySet()) {
                playerInfoMap.putString(entry4.getKey(), (String)entry4.getValue());
            }
            individualPlayerTag.put("kitCooldowns", (Tag)kitCooldownList);
            individualPlayerTag.put("warpCooldowns", (Tag)warpCooldownList);
            individualPlayerTag.put("commandCooldowns", (Tag)commandCooldownList);
            individualPlayerTag.put("playerInfoMap", (Tag)playerInfoMap);
            individualPlayerTag.put("playerHomes", (Tag)playerHomes);
            parentPlayerData.put(uuid.toString(), (Tag)individualPlayerTag);
        }
        compoundTag.put("playerData", (Tag)parentPlayerData);
        for (Map.Entry<UUID, Object> entry : this.bannedPlayers.entrySet()) {
            CompoundTag banInfo = new CompoundTag();
            banInfo.putUUID("uuid", entry.getKey());
            banInfo.putString("reason", ((Ban)entry.getValue()).banReason);
            banInfo.putLong("expiry", ((Ban)entry.getValue()).banExpiry);
            parentBanData.put(entry.getKey().toString(), (Tag)banInfo);
        }
        compoundTag.put("banData", (Tag)parentBanData);
        for (Map.Entry<UUID, Object> entry : this.mutedPlayers.entrySet()) {
            CompoundTag muteInfo = new CompoundTag();
            muteInfo.putUUID("uuid", entry.getKey());
            muteInfo.putString("reason", ((Mute)entry.getValue()).muteReason);
            muteInfo.putLong("expiry", ((Mute)entry.getValue()).muteExpiry);
            parentMuteData.put(entry.getKey().toString(), (Tag)muteInfo);
        }
        compoundTag.put("muteData", (Tag)parentMuteData);
        return compoundTag;
    }

    private static PlayerData load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        HashMap<UUID, HEPlayer> tempPlayerData = new HashMap<UUID, HEPlayer>();
        HashMap<UUID, Ban> tempBanMap = new HashMap<UUID, Ban>();
        HashMap<UUID, Mute> tempMuteMap = new HashMap<UUID, Mute>();
        CompoundTag parentPlayerData = compoundTag.getCompound("playerData");
        CompoundTag parentBanData = compoundTag.getCompound("banData");
        CompoundTag parentMuteData = compoundTag.getCompound("muteData");
        for (String uuid : parentPlayerData.getAllKeys()) {
            CompoundTag specificPlayerData = (CompoundTag)parentPlayerData.get(uuid);
            CompoundTag kitCooldowns = specificPlayerData.getCompound("kitCooldowns");
            CompoundTag playerHomesTag = specificPlayerData.getCompound("playerHomes");
            CompoundTag warpCooldowns = specificPlayerData.getCompound("warpCooldowns");
            CompoundTag commandCooldowns = specificPlayerData.getCompound("commandCooldowns");
            CompoundTag playerInfo = specificPlayerData.getCompound("playerInfoMap");
            HashMap<String, Long> kitCooldownsMap = new HashMap<String, Long>();
            HashMap<String, Long> warpCooldownsMap = new HashMap<String, Long>();
            HashMap<String, Long> commandCooldownsMap = new HashMap<String, Long>();
            HashMap<String, String> playerInfoMap = new HashMap<String, String>();
            HashMap<String, Home> playerHomes = new HashMap<String, Home>();
            for (String entry : kitCooldowns.getAllKeys()) {
                kitCooldownsMap.put(entry, kitCooldowns.getLong(entry));
            }
            for (String pInfo : playerInfo.getAllKeys()) {
                playerInfoMap.put(pInfo, playerInfo.getString(pInfo));
            }
            for (String home : playerHomesTag.getAllKeys()) {
                CompoundTag specificHomeTag = playerHomesTag.getCompound(home);
                Optional pos = NbtUtils.readBlockPos((CompoundTag)specificHomeTag, (String)"blockPos");
                String name = specificHomeTag.getString("name");
                ResourceKey dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)specificHomeTag.getString("dimension")));
                GlobalPos gPos = GlobalPos.of((ResourceKey)dim, (BlockPos)((BlockPos)pos.get()));
                playerHomes.put(name, new Home(name, gPos));
            }
            tempPlayerData.put(UUID.fromString(uuid), new HEPlayer(kitCooldownsMap, warpCooldownsMap, commandCooldownsMap, playerInfoMap, playerHomes));
        }
        for (String uuid : parentBanData.getAllKeys()) {
            CompoundTag specificPlayerBanData = parentBanData.getCompound(uuid);
            tempBanMap.put(UUID.fromString(uuid), new Ban(UUID.fromString(uuid), specificPlayerBanData.getLong("expiry"), specificPlayerBanData.getString("reason")));
        }
        for (String uuid : parentMuteData.getAllKeys()) {
            CompoundTag specificPlayerMuteData = parentMuteData.getCompound(uuid);
            tempMuteMap.put(UUID.fromString(uuid), new Mute(UUID.fromString(uuid), specificPlayerMuteData.getLong("expiry"), specificPlayerMuteData.getString("reason")));
        }
        return new PlayerData(tempPlayerData, tempBanMap, tempMuteMap);
    }

    public static PlayerData getUserData(MinecraftServer minecraftServer) {
        return (PlayerData)minecraftServer.overworld().getDataStorage().computeIfAbsent(PlayerData.factory(), "hennyessentials-userdata");
    }

    public static PlayerData getUserData() {
        return (PlayerData)CommonClass.minecraftServer.overworld().getDataStorage().computeIfAbsent(PlayerData.factory(), "hennyessentials-userdata");
    }

    public static HEPlayer getSpecificUserData(MinecraftServer minecraftServer, UUID playerUUID) {
        return PlayerData.getUserData((MinecraftServer)minecraftServer).HEPlayerData.getOrDefault(playerUUID, new HEPlayer());
    }

    public void updatePlayerInfo(UUID playerUUID, String key, String value) {
        Map<UUID, HEPlayer> alldata = PlayerData.getUserData((MinecraftServer)CommonClass.minecraftServer).HEPlayerData;
        if (!alldata.containsKey(playerUUID)) {
            alldata.put(playerUUID, new HEPlayer());
        }
        HEPlayer pData = alldata.get(playerUUID);
        pData.playerInfo.put(key, value);
        this.setDirty();
    }

    public String getPlayerInfoValue(UUID playerUUID, String key) {
        Map<UUID, HEPlayer> alldata = PlayerData.getUserData((MinecraftServer)CommonClass.minecraftServer).HEPlayerData;
        if (!alldata.containsKey(playerUUID)) {
            alldata.put(playerUUID, new HEPlayer());
        }
        HEPlayer pData = alldata.get(playerUUID);
        if (pData.playerInfo.containsKey(key)) {
            return pData.playerInfo.get(key);
        }
        return "";
    }

    @Nullable
    public Home getPlayerHome(UUID playerUUID, String homeName) {
        return PlayerData.getUserData().HEPlayerData.getOrDefault((Object)playerUUID, (HEPlayer)new HEPlayer()).homeList.getOrDefault(homeName.toLowerCase(), null);
    }

    public int countPlayerHomes(UUID playerUUID) {
        return PlayerData.getUserData().HEPlayerData.getOrDefault((Object)playerUUID, (HEPlayer)new HEPlayer()).homeList.size();
    }

    public Collection<Home> listPlayerHomes(UUID playerUUID) {
        return PlayerData.getUserData().HEPlayerData.getOrDefault((Object)playerUUID, (HEPlayer)new HEPlayer()).homeList.values();
    }

    public boolean addPlayerHome(UUID playerUUID, Home home) {
        Map<UUID, HEPlayer> alldata = PlayerData.getUserData((MinecraftServer)CommonClass.minecraftServer).HEPlayerData;
        home.name = home.name.toLowerCase();
        if (!alldata.containsKey(playerUUID)) {
            alldata.put(playerUUID, new HEPlayer());
        }
        HEPlayer pData = alldata.get(playerUUID);
        if (pData.homeList.containsKey(home.name)) {
            return false;
        }
        pData.homeList.put(home.name, home);
        return true;
    }

    public boolean removePlayerHome(UUID playerUUID, String homeName) {
        Map<UUID, HEPlayer> alldata = PlayerData.getUserData((MinecraftServer)CommonClass.minecraftServer).HEPlayerData;
        if (!alldata.containsKey(playerUUID)) {
            alldata.put(playerUUID, new HEPlayer());
        }
        HEPlayer pData = alldata.get(playerUUID);
        if (!pData.homeList.containsKey(homeName)) {
            return false;
        }
        pData.homeList.remove(homeName);
        return true;
    }

    public void updateKitCooldown(UUID playerUUID, String kitName, int kitCooldownSeconds) {
        Map<UUID, HEPlayer> allData = PlayerData.getUserData((MinecraftServer)CommonClass.minecraftServer).HEPlayerData;
        if (!allData.containsKey(playerUUID)) {
            allData.put(playerUUID, new HEPlayer());
        }
        HEPlayer pData = allData.get(playerUUID);
        pData.updateKitCooldown(kitName, kitCooldownSeconds);
        this.setDirty();
    }

    public void updateMuteList(Mute mute) {
        this.mutedPlayers.put(mute.mutedPlayerUUID, mute);
        this.setDirty();
    }

    public void updateBanList(Ban ban) {
        this.bannedPlayers.put(ban.bannedPlayerUUID, ban);
        this.setDirty();
    }

    public void unmutePlayer(UUID uuid) {
        this.mutedPlayers.remove(uuid);
        this.setDirty();
    }

    public void unbanPlayer(UUID uuid) {
        this.bannedPlayers.remove(uuid);
        this.setDirty();
    }

    public void purgeExpiredBansMutes() {
        this.bannedPlayers.entrySet().removeIf(entry -> ((Ban)entry.getValue()).banExpiry != 0L && ((Ban)entry.getValue()).banExpiry < System.currentTimeMillis());
        this.mutedPlayers.entrySet().removeIf(entry -> ((Mute)entry.getValue()).muteExpiry != 0L && ((Mute)entry.getValue()).muteExpiry < System.currentTimeMillis());
        this.setDirty();
    }
}

