/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.data;

import com.henny.hennyessentials.data.objects.Warp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.saveddata.SavedData;

public class WarpData
extends SavedData {
    public Map<String, Warp> warps;

    public static SavedData.Factory<WarpData> factory() {
        return new SavedData.Factory(WarpData::new, WarpData::load, DataFixTypes.LEVEL);
    }

    private static WarpData load(CompoundTag compoundTag, HolderLookup.Provider provider) {
        HashMap<String, Warp> warpListTemp = new HashMap<String, Warp>();
        CompoundTag warpsTag = compoundTag.getCompound("warps");
        for (String key : warpsTag.getAllKeys()) {
            String warpName = key.toLowerCase();
            Warp warp = new Warp(warpName, NbtUtils.readBlockPos((CompoundTag)warpsTag.getCompound(key), (String)"blockPos").orElse(BlockPos.ZERO), warpsTag.getCompound(key).getString("dimension"), warpsTag.getCompound(key).getLong("expiry"));
            if (warpsTag.getCompound(key).contains("displayItem")) {
                ItemStack displayItem;
                warp.displayItem = displayItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)warpsTag.getCompound(key).get("displayItem")));
            }
            if (warpsTag.getCompound(key).contains("categoryDisplayItem")) {
                ItemStack categoryDisplayItem;
                warp.categoryDisplayItem = categoryDisplayItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)((CompoundTag)warpsTag.getCompound(key).get("categoryDisplayItem")));
            }
            if (warpsTag.getCompound(key).contains("category")) {
                warp.category = warpsTag.getCompound(key).getString("category");
            }
            if (warpsTag.getCompound(key).contains("rotation")) {
                warp.rotation = warpsTag.getCompound(key).getFloat("rotation");
            }
            warp.displayItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)warpsTag.getCompound(key).getCompound("displayItem"));
            warp.categoryDisplayItem = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)warpsTag.getCompound(key).getCompound("categoryDisplayItem"));
            warpListTemp.put(warpName, warp);
        }
        return new WarpData(warpListTemp);
    }

    public WarpData() {
        this.warps = new HashMap<String, Warp>();
    }

    public WarpData(Map<String, Warp> warps) {
        this.warps = warps;
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        CompoundTag warpList = new CompoundTag();
        for (Warp warp : this.warps.values()) {
            warp.name = warp.name.toLowerCase();
            CompoundTag warpTag = new CompoundTag();
            warpTag.putString("name", warp.name.toLowerCase());
            warpTag.putString("category", warp.category);
            warpTag.putLong("expiry", warp.expiry);
            warpTag.put("blockPos", NbtUtils.writeBlockPos((BlockPos)warp.blockPos));
            warpTag.putString("dimension", warp.dimension);
            if (!warp.displayItem.isEmpty()) {
                warpTag.put("displayItem", warp.displayItem.save(provider));
            }
            if (!warp.displayItem.isEmpty()) {
                warpTag.put("categoryDisplayItem", warp.categoryDisplayItem.save(provider));
            }
            warpTag.putFloat("rotation", warp.rotation);
            warpList.put(warp.name, (Tag)warpTag);
        }
        compoundTag.put("warps", (Tag)warpList);
        return compoundTag;
    }

    public void addWarp(Warp warp) {
        warp.name = warp.name.toLowerCase();
        this.warps.put(warp.name, warp);
        this.setDirty();
    }

    public void removeWarp(String warpName) {
        this.warps.remove(warpName);
        this.setDirty();
    }

    public void setWarpCategory(String warpName, String category) {
        if (this.warps.containsKey(warpName)) {
            this.warps.get((Object)warpName).category = category;
        }
        this.setDirty();
    }

    public void setWarpDisplayItem(String warpName, ItemStack item) {
        if (this.warps.containsKey(warpName)) {
            this.warps.get((Object)warpName).displayItem = item.copy();
        }
        this.setDirty();
    }

    public void setCategoryDisplayItem(String categoryName, ItemStack item) {
        for (Warp k : this.warps.values()) {
            if (!Objects.equals(k.category, categoryName)) continue;
            k.categoryDisplayItem = item.copy();
        }
        this.setDirty();
    }

    public boolean currentlyMoreThanOneCategory() {
        HashSet<String> counter = new HashSet<String>();
        for (Warp w : this.warps.values()) {
            counter.add(w.category);
        }
        return counter.size() != 1;
    }

    public void purgeExpired() {
        this.warps.entrySet().removeIf(entry -> ((Warp)entry.getValue()).expiry != 0L && System.currentTimeMillis() > ((Warp)entry.getValue()).expiry);
        this.setDirty();
    }

    public static WarpData getWarpData(MinecraftServer minecraftServer) {
        return (WarpData)minecraftServer.overworld().getDataStorage().computeIfAbsent(WarpData.factory(), "hennyessentials-warps");
    }
}

