/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.data.objects;

import com.google.gson.annotations.Expose;
import com.henny.hennyessentials.config.ConfigManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;

public class CommandToken {
    @Expose
    public String name;
    @Expose
    public List<String> commands;
    @Expose
    public String alias;
    @Expose
    public String description;
    @Expose
    public boolean reusable = false;
    @Expose
    public boolean lockedToPlayer = false;
    @Expose
    public String permission = "";
    @Expose
    public boolean shouldWriteToAuditLog = false;
    @Expose
    public int reusableUsageLimit = 0;

    public CommandToken(String name, List<String> commands, String alias, String description, boolean reusable) {
        this.name = name;
        this.commands = commands;
        this.alias = alias;
        this.description = description;
        this.reusable = reusable;
        this.permission = "";
    }

    public CommandToken(String name, List<String> commands, String alias, String description, String permission) {
        this.name = name;
        this.commands = commands;
        this.alias = alias;
        this.description = description;
        this.lockedToPlayer = false;
        this.reusable = false;
        this.permission = permission;
    }

    public CommandToken(String name, List<String> commands, String alias, String description) {
        this.name = name;
        this.commands = commands;
        this.alias = alias;
        this.description = description;
        this.lockedToPlayer = false;
        this.reusable = false;
        this.permission = "";
    }

    public static ItemStack createTokenItemStack(ItemStack itemStack, String tokenName, boolean lockedToPlayer, ServerPlayer receivingPlayer) {
        String playerName;
        CompoundTag tokenData = new CompoundTag();
        CommandToken token = ConfigManager.TOKENS.get(tokenName);
        tokenData.putString("commandtoken", tokenName);
        if (lockedToPlayer) {
            tokenData.putString("locked", receivingPlayer.getUUID().toString());
        }
        itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tokenData));
        String string = playerName = receivingPlayer != null ? receivingPlayer.getName().getString() : null;
        if (token.name != null && !token.name.isEmpty()) {
            String name = playerName != null ? token.name.replace("%p", playerName) : token.name;
            itemStack.set(DataComponents.ITEM_NAME, (Object)Component.literal((String)name));
        }
        ArrayList<MutableComponent> loreLines = new ArrayList<MutableComponent>();
        if (token.description != null && !token.description.isEmpty()) {
            String desc = playerName != null ? token.description.replace("%p", playerName) : token.description;
            loreLines.add(Component.literal((String)desc));
        }
        loreLines.add(Component.literal((String)ConfigManager.CONFIG.tokenConfigs.usageLoreText));
        if (token.reusable) {
            loreLines.add(Component.literal((String)ConfigManager.CONFIG.tokenConfigs.reusableText));
        }
        itemStack.set(DataComponents.LORE, (Object)new ItemLore(loreLines));
        return itemStack;
    }

    public boolean isReusable() {
        return this.reusable;
    }

    public boolean isLockedToPlayer() {
        return this.lockedToPlayer;
    }
}

