/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.menu;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.LevelResource;

public class InvseeMenu
extends AbstractContainerMenu {
    private final Inventory targetInventory;
    public boolean isOffline;
    public UUID targetUUID;

    public InvseeMenu(int windowId, Inventory viewerInventory, Inventory targetInventory, boolean isOffline, UUID targetUUID) {
        super(MenuType.GENERIC_9x4, windowId);
        int i;
        int col;
        int row;
        this.targetInventory = targetInventory;
        this.isOffline = isOffline;
        this.targetUUID = targetUUID;
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)targetInventory, col + row * 9 + 9, 8 + col * 18, 18 + row * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)targetInventory, i, 8 + i * 18, 72));
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)viewerInventory, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)viewerInventory, i, 8 + i * 18, 198));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack originalStack = slot.getItem();
        ItemStack copy = originalStack.copy();
        int targetStart = 0;
        int targetEnd = 36;
        int viewerStart = 36;
        int viewerEnd = this.slots.size();
        if (index < targetEnd ? !this.moveItemStackTo(originalStack, viewerStart, viewerEnd, false) : !this.moveItemStackTo(originalStack, targetStart, targetEnd, false)) {
            return ItemStack.EMPTY;
        }
        if (originalStack.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return copy;
    }

    public void removed(Player pPlayer) {
        if (this.isOffline) {
            for (ItemStack stack : this.targetInventory.items) {
                if (stack.isEmpty()) continue;
                this.saveInventoryToTag();
            }
        }
    }

    public void saveInventoryToTag() {
        CompoundTag playerTag;
        Path datfile = CommonClass.minecraftServer.getWorldPath(LevelResource.PLAYER_DATA_DIR).resolve(String.valueOf(this.targetUUID) + ".dat");
        try (InputStream is = Files.newInputStream(datfile, new OpenOption[0]);){
            playerTag = NbtIo.readCompressed((InputStream)is, (NbtAccounter)NbtAccounter.unlimitedHeap());
        }
        catch (IOException e) {
            return;
        }
        ListTag newList = new ListTag();
        for (int i = 0; i < this.targetInventory.getContainerSize(); ++i) {
            ItemStack stack = this.targetInventory.getItem(i);
            if (stack.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)i);
            itemTag = (CompoundTag)stack.save((HolderLookup.Provider)CommonClass.minecraftServer.registryAccess(), (Tag)itemTag);
            newList.add((Object)itemTag);
        }
        playerTag.put("Inventory", (Tag)newList);
        try (OutputStream os = Files.newOutputStream(datfile, new OpenOption[0]);){
            NbtIo.writeCompressed((CompoundTag)playerTag, (OutputStream)os);
        }
        catch (IOException e) {
            Constants.LOG.info("Invsee offline error saving data: {}", (Object)e.getLocalizedMessage());
        }
    }
}

