/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.menu;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.Constants;
import com.henny.hennyessentials.data.KitData;
import com.henny.hennyessentials.data.objects.Kit;
import com.henny.hennyessentials.util.TextUtils;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class KitCreationMenu
extends ChestMenu {
    private final SimpleContainer container;
    public String kitName;
    public int kitCooldown;

    public KitCreationMenu(int id, Inventory playerInventory, SimpleContainer container, String kitName, int kitCooldown) {
        super(MenuType.GENERIC_9x3, id, playerInventory, (Container)container, 3);
        this.container = container;
        this.kitName = kitName;
        this.kitCooldown = kitCooldown;
    }

    public void removed(Player player) {
        ArrayList<ItemStack> kitItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack stack = this.container.getItem(i);
            if (stack.isEmpty()) continue;
            Constants.LOG.info("Adding {} of item: {} to kit: {}", new Object[]{this.container.getItem(i).getCount(), this.container.getItem(i).getDisplayName().getString(), this.kitName});
            kitItems.add(this.container.getItem(i));
        }
        if (!kitItems.isEmpty()) {
            KitData.getKitData(CommonClass.minecraftServer).addKit(new Kit(this.kitName, this.kitCooldown, kitItems));
            player.sendSystemMessage((Component)TextUtils.formatMessage("New kit with name: " + this.kitName + " was created."));
        }
    }
}

