/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.menu;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.Constants;
import com.henny.hennyessentials.data.KitData;
import com.henny.hennyessentials.util.TextUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class KitEditMenu
extends ChestMenu {
    private final SimpleContainer container;
    public String kitName;

    public KitEditMenu(int id, Inventory playerInventory, SimpleContainer container, String kitName, List<ItemStack> items) {
        super(MenuType.GENERIC_9x3, id, playerInventory, (Container)container, 3);
        this.container = container;
        this.kitName = kitName;
        for (ItemStack item : items) {
            this.container.addItem(item);
        }
    }

    public void removed(Player player) {
        ArrayList<ItemStack> kitItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            ItemStack stack = this.container.getItem(i);
            if (stack.isEmpty()) continue;
            Constants.LOG.info("Adding {} of item: {} to kit: {}", new Object[]{this.container.getItem(i).getCount(), this.container.getItem(i).getDisplayName().getString(), this.kitName});
            kitItems.add(this.container.getItem(i));
        }
        if (!kitItems.isEmpty()) {
            KitData.getKitData(CommonClass.minecraftServer).editKit(this.kitName, kitItems);
            player.sendSystemMessage((Component)TextUtils.formatMessage("Kit with name: " + this.kitName + " was edited."));
        }
    }
}

