/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.menu;

import com.henny.hennyessentials.command.KitCommands;
import com.henny.hennyessentials.data.KitData;
import com.henny.hennyessentials.data.objects.Kit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class KitsMenu
extends AbstractContainerMenu {
    private final SimpleContainer container;
    private final List<ItemStack> allItems;
    private int currentPage = 0;
    private String currentCategory = null;
    private final int itemsPerPage = 26;
    private final int totalSlots = 54;
    private static final int PREV_PAGE_SLOT = 52;
    private static final int NEXT_PAGE_SLOT = 53;
    private final KitData kitData;

    public KitsMenu(int id, Inventory playerInventory, KitData kitData) {
        super(MenuType.GENERIC_9x6, id);
        this.kitData = kitData;
        this.container = new SimpleContainer(54);
        this.allItems = new ArrayList<ItemStack>();
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            this.addSlot(new Slot(this, (Container)this.container, i, 8 + i % 9 * 18, 18 + i / 9 * 18){

                public boolean mayPlace(ItemStack pStack) {
                    return false;
                }

                public boolean mayPickup(Player pPlayer) {
                    return false;
                }
            });
        }
        if (kitData.currentlyMoreThanOneCategory()) {
            this.loadCategoryItems();
        } else {
            this.loadDefaultItems();
        }
        this.populatePage();
    }

    private void loadDefaultItems() {
        this.allItems.clear();
        for (Kit kit : this.kitData.kits.values()) {
            ItemStack kitItem = new ItemStack((ItemLike)Items.SHULKER_BOX);
            if (!kit.displayItem.isEmpty()) {
                kitItem = kit.displayItem;
            }
            kitItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Kit: " + kit.name)));
            CompoundTag tag = new CompoundTag();
            tag.putString("he-kit", kit.name);
            kitItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.allItems.add(kitItem);
        }
    }

    private void loadCategoryItems() {
        this.allItems.clear();
        ArrayList<String> categories = new ArrayList<String>();
        for (Kit kit : this.kitData.kits.values()) {
            String category = kit.category != null ? kit.category : "default";
            if (categories.contains(category)) continue;
            categories.add(category);
            ItemStack categoryItem = new ItemStack((ItemLike)Items.SHULKER_BOX);
            if (!kit.categoryDisplayItem.isEmpty()) {
                categoryItem = kit.categoryDisplayItem;
            }
            categoryItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Category: " + category)));
            CompoundTag tag = new CompoundTag();
            tag.putString("he-category", category);
            categoryItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.allItems.add(categoryItem);
        }
    }

    private void loadKitsForCategory(String category) {
        this.allItems.clear();
        for (Map.Entry<String, Kit> entry : this.kitData.kits.entrySet()) {
            Kit kit = entry.getValue();
            String kitCategory = kit.category != null ? kit.category : "default";
            if (!kitCategory.equals(category)) continue;
            ItemStack kitItem = new ItemStack((ItemLike)Items.CHEST);
            if (!kit.displayItem.isEmpty()) {
                kitItem = kit.displayItem;
            }
            kitItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Kit: " + entry.getKey())));
            CompoundTag tag = new CompoundTag();
            tag.putString("he-kit", entry.getKey());
            kitItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.allItems.add(kitItem);
        }
        ItemStack backItem = new ItemStack((ItemLike)Items.BARRIER);
        backItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Back to Categories"));
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("he-back", true);
        backItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        this.allItems.add(backItem);
    }

    public void clicked(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        CompoundTag itemCustomData;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (slotId == 52) {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.populatePage();
            }
            return;
        }
        if (slotId == 53) {
            if (this.currentPage < this.getMaxPage()) {
                ++this.currentPage;
                this.populatePage();
            }
            return;
        }
        if (slotId < 0 || slotId >= this.container.getContainerSize()) {
            return;
        }
        ItemStack clicked = this.getSlot(slotId).getItem();
        CompoundTag compoundTag = itemCustomData = clicked.has(DataComponents.CUSTOM_DATA) ? ((CustomData)clicked.get(DataComponents.CUSTOM_DATA)).copyTag() : new CompoundTag();
        if (itemCustomData.contains("he-kit")) {
            String kitName = itemCustomData.getString("he-kit");
            if (this.kitData.kits.containsKey(kitName)) {
                KitCommands.giveKitToPlayer(sp, kitName);
                sp.closeContainer();
            }
            return;
        }
        if (itemCustomData.contains("he-category")) {
            this.currentCategory = itemCustomData.getString("he-category");
            this.loadKitsForCategory(this.currentCategory);
            this.currentPage = 0;
            this.populatePage();
            return;
        }
        if (itemCustomData.contains("he-back")) {
            this.currentCategory = null;
            this.loadCategoryItems();
            this.currentPage = 0;
            this.populatePage();
            return;
        }
    }

    public ItemStack quickMoveStack(Player player, int i) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    private void populatePage() {
        for (int i = 0; i < 26; ++i) {
            this.container.setItem(i, ItemStack.EMPTY);
        }
        ItemStack blackGlass = new ItemStack((ItemLike)Items.BLACK_STAINED_GLASS_PANE);
        blackGlass.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Henny Essentials Mod").withStyle(ChatFormatting.GREEN));
        ItemStack limeGlass = new ItemStack((ItemLike)Items.LIME_STAINED_GLASS_PANE);
        limeGlass.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Henny Essentials Mod").withStyle(ChatFormatting.GREEN));
        for (int i = 0; i < 54; ++i) {
            boolean isBorder;
            boolean bl = isBorder = i < 9 || i >= 45 || i % 9 == 0 || i % 9 == 8;
            if (!isBorder || i == 52 || i == 53) continue;
            ItemStack glass = i % 2 == 0 ? blackGlass.copy() : limeGlass.copy();
            this.container.setItem(i, glass);
        }
        int start = this.currentPage * 26;
        int itemIndex = 0;
        for (int i = 0; i < 54; ++i) {
            int index;
            boolean isBorder;
            boolean bl = isBorder = i < 9 || i >= 45 || i % 9 == 0 || i % 9 == 8;
            if (isBorder || i == 52 || i == 53 || (index = start + itemIndex++) >= this.allItems.size()) continue;
            this.container.setItem(i, this.allItems.get(index));
        }
        ItemStack nextPage = new ItemStack((ItemLike)Items.ARROW);
        nextPage.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Next Page"));
        ItemStack prevPage = new ItemStack((ItemLike)Items.ARROW);
        prevPage.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Previous Page"));
        this.container.setItem(52, this.currentPage > 0 ? prevPage : ItemStack.EMPTY);
        this.container.setItem(53, this.currentPage < this.getMaxPage() ? nextPage : ItemStack.EMPTY);
    }

    private int getMaxPage() {
        return (int)Math.ceil((double)this.allItems.size() / 26.0) - 1;
    }
}

