/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.menu;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.command.TeleportCommands;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.WarpData;
import com.henny.hennyessentials.data.objects.Warp;
import com.henny.hennyessentials.permission.Permissions;
import com.henny.hennyessentials.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class WarpsMenu
extends AbstractContainerMenu {
    private final SimpleContainer container;
    private final List<ItemStack> allItems;
    private int currentPage = 0;
    private String currentCategory = null;
    private final int itemsPerPage = 26;
    private final int totalSlots = 54;
    private static final int PREV_PAGE_SLOT = 52;
    private static final int NEXT_PAGE_SLOT = 53;
    private final WarpData warpData;
    private UUID viewerUUID;

    public WarpsMenu(int id, Inventory playerInventory, WarpData warpData, UUID viewerUUID) {
        super(MenuType.GENERIC_9x6, id);
        this.warpData = warpData;
        this.container = new SimpleContainer(54);
        this.allItems = new ArrayList<ItemStack>();
        this.viewerUUID = viewerUUID;
        for (int i = 0; i < this.container.getContainerSize(); ++i) {
            this.addSlot(new Slot(this, (Container)this.container, i, 8 + i % 9 * 18, 18 + i / 9 * 18){

                public boolean mayPlace(ItemStack pStack) {
                    return false;
                }

                public boolean mayPickup(Player pPlayer) {
                    return false;
                }
            });
        }
        if (warpData.currentlyMoreThanOneCategory()) {
            this.loadCategoryItems();
        } else {
            this.loadDefaultItems();
        }
        this.populatePage();
    }

    private void loadDefaultItems() {
        this.allItems.clear();
        for (Warp warp : this.warpData.warps.values()) {
            if (ConfigManager.CONFIG.permissionConfigs.permissionsRequiredForIndividualWarps && !Permissions.permissionCheck(this.viewerUUID, "warp." + warp.name, CommonClass.minecraftServer)) continue;
            ItemStack warpItem = new ItemStack((ItemLike)Items.ENDER_PEARL);
            if (!warp.displayItem.isEmpty()) {
                warpItem = warp.displayItem;
            }
            warpItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Warp: " + warp.name)));
            CompoundTag tag = new CompoundTag();
            tag.putString("he-warp", warp.name);
            warpItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.allItems.add(warpItem);
        }
    }

    private void loadCategoryItems() {
        String category;
        this.allItems.clear();
        HashSet<String> addedCategories = new HashSet<String>();
        HashMap<String, List> warpsByCategory = new HashMap<String, List>();
        for (Warp warp2 : this.warpData.warps.values()) {
            category = warp2.category != null ? warp2.category : "default";
            warpsByCategory.computeIfAbsent(category, k -> new ArrayList()).add(warp2);
        }
        for (Map.Entry entry : warpsByCategory.entrySet()) {
            category = (String)entry.getKey();
            List warpsInCategory = (List)entry.getValue();
            boolean hasCategoryPermission = Permissions.permissionCheck(this.viewerUUID, "warpcategory." + category, CommonClass.minecraftServer);
            boolean hasWarpPermission = warpsInCategory.stream().anyMatch(warp -> Permissions.permissionCheck(this.viewerUUID, "warp." + warp.name, CommonClass.minecraftServer));
            if (!hasCategoryPermission && !hasWarpPermission && ConfigManager.CONFIG.permissionConfigs.permissionsRequiredForIndividualWarps || addedCategories.contains(category)) continue;
            addedCategories.add(category);
            ItemStack categoryItem = new ItemStack((ItemLike)Items.END_PORTAL_FRAME);
            if (!((Warp)warpsInCategory.get((int)0)).categoryDisplayItem.isEmpty()) {
                categoryItem = ((Warp)warpsInCategory.get((int)0)).categoryDisplayItem;
            }
            categoryItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Category: " + category)));
            CompoundTag tag = new CompoundTag();
            tag.putString("he-category", category);
            categoryItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.allItems.add(categoryItem);
        }
    }

    private void loadWarpsForCategory(String category) {
        this.allItems.clear();
        for (Map.Entry<String, Warp> entry : this.warpData.warps.entrySet()) {
            Warp warp = entry.getValue();
            String warpCategory = warp.category != null ? warp.category : "default";
            if (!warpCategory.equals(category) || ConfigManager.CONFIG.permissionConfigs.permissionsRequiredForIndividualWarps && !Permissions.permissionCheckList(this.viewerUUID, List.of("warp." + entry.getKey(), "warpcategory." + warpCategory), CommonClass.minecraftServer)) continue;
            ItemStack warpItem = new ItemStack((ItemLike)Items.ENDER_PEARL);
            if (!warp.displayItem.isEmpty()) {
                warpItem = warp.displayItem;
            }
            warpItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Warp: " + entry.getKey())));
            CompoundTag tag = new CompoundTag();
            tag.putString("he-warp", entry.getKey());
            warpItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            this.allItems.add(warpItem);
        }
        ItemStack backItem = new ItemStack((ItemLike)Items.BARRIER);
        backItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Back to Categories"));
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("he-back", true);
        backItem.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        this.allItems.add(backItem);
    }

    public void clicked(int slotId, int button, @NotNull ClickType clickType, @NotNull Player player) {
        CompoundTag itemCustomData;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (slotId == 52) {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.populatePage();
            }
            return;
        }
        if (slotId == 53) {
            if (this.currentPage < this.getMaxPage()) {
                ++this.currentPage;
                this.populatePage();
            }
            return;
        }
        if (slotId < 0 || slotId >= this.container.getContainerSize()) {
            return;
        }
        ItemStack clicked = this.getSlot(slotId).getItem();
        CompoundTag compoundTag = itemCustomData = clicked.has(DataComponents.CUSTOM_DATA) ? ((CustomData)clicked.get(DataComponents.CUSTOM_DATA)).copyTag() : new CompoundTag();
        if (itemCustomData.contains("he-warp")) {
            String warpName = itemCustomData.getString("he-warp");
            if (this.warpData.warps.containsKey(warpName)) {
                Warp warp = this.warpData.warps.get(warpName);
                String warpcat = warp.category;
                if (warpcat == null || warpcat.isBlank()) {
                    warpcat = "default";
                }
                if (ConfigManager.CONFIG.permissionConfigs.permissionsRequiredForIndividualWarps && !Permissions.permissionCheckList(player.getUUID(), List.of("warp." + warpName, "warpcategory." + warpcat), CommonClass.minecraftServer)) {
                    player.sendSystemMessage((Component)Component.literal((String)"").append((Component)TextUtils.formatMessage(ConfigManager.CONFIG.commandConfigs.warpConfigs.noPermissionForWarpMessage.replace("%warpname%", warpName))));
                    return;
                }
                if (!Permissions.cooldownChecker(player.getUUID(), "he.warp")) {
                    Permissions.handleCooldownNotExpired((ServerPlayer)player, "he.warp");
                    ((ServerPlayer)player).closeContainer();
                    return;
                }
                Permissions.updateCooldown(player.getUUID(), "he.warp", System.currentTimeMillis() + (long)ConfigManager.CONFIG.commandConfigs.warpConfigs.cooldownSeconds * 1000L);
                GlobalPos pos = GlobalPos.of((ResourceKey)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)warp.dimension)), (BlockPos)warp.blockPos);
                TeleportCommands.teleportPlayer((ServerPlayer)player, pos, ConfigManager.CONFIG.commandConfigs.teleportConfigs.warpCommandWarmupSeconds, warp.rotation);
                ((ServerPlayer)player).closeContainer();
            }
            return;
        }
        if (itemCustomData.contains("he-category")) {
            this.currentCategory = itemCustomData.getString("he-category");
            this.loadWarpsForCategory(this.currentCategory);
            this.currentPage = 0;
            this.populatePage();
            return;
        }
        if (itemCustomData.contains("he-back")) {
            this.currentCategory = null;
            this.loadCategoryItems();
            this.currentPage = 0;
            this.populatePage();
            return;
        }
    }

    public ItemStack quickMoveStack(Player player, int i) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return true;
    }

    private void populatePage() {
        for (int i = 0; i < 26; ++i) {
            this.container.setItem(i, ItemStack.EMPTY);
        }
        ItemStack blackGlass = new ItemStack((ItemLike)Items.BLACK_STAINED_GLASS_PANE);
        blackGlass.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Henny Essentials Mod").withStyle(ChatFormatting.GREEN));
        ItemStack limeGlass = new ItemStack((ItemLike)Items.LIME_STAINED_GLASS_PANE);
        limeGlass.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Henny Essentials Mod").withStyle(ChatFormatting.GREEN));
        for (int i = 0; i < 54; ++i) {
            boolean isBorder;
            boolean bl = isBorder = i < 9 || i >= 45 || i % 9 == 0 || i % 9 == 8;
            if (!isBorder || i == 52 || i == 53) continue;
            ItemStack glass = i % 2 == 0 ? blackGlass.copy() : limeGlass.copy();
            this.container.setItem(i, glass);
        }
        int start = this.currentPage * 26;
        int itemIndex = 0;
        for (int i = 0; i < 54; ++i) {
            int index;
            boolean isBorder;
            boolean bl = isBorder = i < 9 || i >= 45 || i % 9 == 0 || i % 9 == 8;
            if (isBorder || i == 52 || i == 53 || (index = start + itemIndex++) >= this.allItems.size()) continue;
            this.container.setItem(i, this.allItems.get(index));
        }
        ItemStack nextPage = new ItemStack((ItemLike)Items.ARROW);
        nextPage.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Next Page"));
        ItemStack prevPage = new ItemStack((ItemLike)Items.ARROW);
        prevPage.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Previous Page"));
        this.container.setItem(52, this.currentPage > 0 ? prevPage : ItemStack.EMPTY);
        this.container.setItem(53, this.currentPage < this.getMaxPage() ? nextPage : ItemStack.EMPTY);
    }

    private int getMaxPage() {
        return (int)Math.ceil((double)this.allItems.size() / 26.0) - 1;
    }
}

