/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.mixin.vanishmixins;

import com.henny.hennyessentials.CommonClass;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class CommonMobMixin {
    @Shadow
    private LivingEntity target;

    @Shadow
    public abstract void setTarget(@Nullable LivingEntity var1);

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        Mob mob = (Mob)this;
        if (mob.getTarget() instanceof ServerPlayer && CommonClass.entityChangeTargetEventResult((ServerPlayer)mob.getTarget())) {
            mob.setTarget(null);
            mob.getBrain().setActiveActivityToFirstValid(List.of(Activity.IDLE));
            mob.getBrain().eraseMemory(MemoryModuleType.ANGRY_AT);
            mob.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
            mob.getBrain().eraseMemory(MemoryModuleType.NEAREST_ATTACKABLE);
            mob.getBrain().eraseMemory(MemoryModuleType.NEAREST_VISIBLE_PLAYER);
            mob.getBrain().eraseMemory(MemoryModuleType.NEAREST_HOSTILE);
            mob.getBrain().eraseMemory(MemoryModuleType.NEAREST_PLAYERS);
            mob.getBrain().eraseMemory(MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER);
            mob.getBrain().setMemory(MemoryModuleType.AVOID_TARGET, (Object)mob.getTarget());
        }
    }

    @Inject(method={"setTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetTarget(LivingEntity target, CallbackInfo ci) {
        if (target != null && target instanceof ServerPlayer && CommonClass.entityChangeTargetEventResult((ServerPlayer)target)) {
            this.setTarget(null);
            ci.cancel();
        }
    }
}

