/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.mixin.vanishmixins;

import com.henny.hennyessentials.CommonClass;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WitherBoss.class})
public class CommonWitherBossMixin {
    @Inject(method={"performRangedAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelAttackOnVanished(int head, LivingEntity target, CallbackInfo ci) {
        ServerPlayer player;
        if (target instanceof ServerPlayer && CommonClass.playersInVanish.getOrDefault((player = (ServerPlayer)target).getUUID(), false).booleanValue()) {
            ci.cancel();
        }
    }

    @Inject(method={"setAlternativeTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelTargetSet(int head, int entityId, CallbackInfo ci) {
        ServerPlayer player;
        Level level = ((WitherBoss)this).level();
        Entity target = level.getEntity(entityId);
        if (target instanceof ServerPlayer && CommonClass.playersInVanish.getOrDefault((player = (ServerPlayer)target).getUUID(), false).booleanValue()) {
            ci.cancel();
        }
    }
}

