/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.permission;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.compat.LuckPermsIntegration;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.PermissionGroupData;
import com.henny.hennyessentials.data.PermissionUserData;
import com.henny.hennyessentials.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class Permissions {
    public static Map<UUID, Map<String, Long>> cooldownsMap = new HashMap<UUID, Map<String, Long>>();
    private static final Map<String, List<String>> groupPermissions = new HashMap<String, List<String>>(){
        {
            this.put(Permissions.USER_PERMISSIONS, List.of(Permissions.TELEPORT_GOHOME_PERMISSION, "command.he.kits", "command.he.kit", "command.he.warps", Permissions.WARP_PERMISSION, Permissions.TELEPORT_SETHOME_PERMISSION, Permissions.TELEPORT_DELHOME_PERMISSION, Permissions.TELEPORT_GOSPAWN_PERMISSION, "command.he.rules", "command.he.banneditems", Permissions.TELEPORT_TPA_PERMISSION, Permissions.TELEPORT_TPAHERE_PERMISSION, Permissions.TELEPORT_TPAACCEPT_PERMISSION, Permissions.TELEPORT_TPADENY_PERMISSION, "command.he.pcallback", Permissions.PLAYER_PLAYTIME_PERMISSION, Permissions.TELEPORT_BACK_PERMISSION, Permissions.PAGE_PERMISSION, Permissions.PLAYER_AFK_PERMISSION));
            this.put(Permissions.ADMIN_PERMISSIONS, List.of(Permissions.MODERATION_BAN_PERMISSION, Permissions.MODERATION_BAN_UUID_PERMISSION, Permissions.MODERATION_MUTE_PERMISSION, Permissions.MODERATION_MUTE_UUID_PERMISSION, Permissions.MODERATION_TEMP_BAN_PERMISSION, Permissions.MODERATION_TEMP_MUTE_PERMISSION, Permissions.PLAYER_VIEW_OTHER_ECHEST_PERMISSION, Permissions.TELEPORT_SET_SPAWN_PERMISSION, Permissions.WARP_SET_PERMISSION, Permissions.WARP_SET_TEMP_PERMISSION, Permissions.KIT_CREATE_PERMISSION, Permissions.KIT_EDIT_PERMISSION, "command.he.banitem", Permissions.MODERATION_BAN_HELD_ITEM_PERMISSION, Permissions.MODERATION_REMOVE_BANNED_ITEM_PERMISSION, "command.he.permission.*", "command.he.condition.*", Permissions.PLAYER_FLY_PERMISSION, "command.he.heal", Permissions.PLAYER_FEED_PERMISSION, Permissions.PLAYER_ANVIL_PERMISSION, "command.he.smithtable", "command.he.ctable", Permissions.PLAYER_STONECUTTER_PERMISSION, "command.he.*"));
        }
    };
    public static final String COMMAND_PERMISSION_BASE = "command.he.";
    public static final String USER_PERMISSIONS = "he.user";
    public static final String ADMIN_PERMISSIONS = "he.admin";
    public static final String RELOAD_ANNOUNCEMENTS_PERMISSION = "command.he.reloadannouncements";
    public static final String RELOAD_CONFIG_PERMISSION = "command.he.reloadconfig";
    public static final String WARP_SET_PERMISSION = "command.he.setwarp";
    public static final String WARP_SET_CATEGORY_PERMISSION = "command.he.setwarpcategory";
    public static final String WARP_SET_DISPLAY_ICON_PERMISSION = "command.he.setwarpdisplay";
    public static final String WARP_SET_TEMP_PERMISSION = "command.he.settempwarp";
    public static final String WARP_DELETE_PERMISSION = "command.he.delwarp";
    public static final String WARP_PERMISSION = "command.he.warp";
    public static final String WARP_LIST_PERMISSION = "command.he.listwarps";
    public static final String TOKEN_PERMISSION = "command.he.token";
    public static final String TOKEN_GIVE_PERMISSION = "command.he.givetoken";
    public static final String TOKEN_RELOAD_PERMISSION = "command.he.reloadtokens";
    public static final String KIT_SETCATEGORY_PERMISSION = "command.he.setkitcategory";
    public static final String KIT_SETDISPLAYICON_PERMISSION = "command.he.setkitdisplay";
    public static final String KIT_CREATE_PERMISSION = "command.he.createkit";
    public static final String KIT_DELETE_PERMISSION = "command.he.delkit";
    public static final String KIT_EDIT_PERMISSION = "command.he.editkit";
    public static final String KIT_LIST_PERMISSION = "command.he.listkits";
    public static final String MODERATION_BROADCAST_PERMISSION = "command.he.broadcsat";
    public static final String MODERATION_BAN_PERMISSION = "command.he.ban";
    public static final String MODERATION_TEMP_BAN_PERMISSION = "command.he.tempban";
    public static final String MODERATION_MUTE_PERMISSION = "command.he.mute";
    public static final String MODERATION_TEMP_MUTE_PERMISSION = "command.he.tempmute";
    public static final String MODERATION_UNMUTE_PERMISSION = "command.he.unmute";
    public static final String MODERATION_UNBAN_PERMISSION = "command.he.unban";
    public static final String MODERATION_UNBAN_UUID_PERMISSION = "command.he.unbanuuid";
    public static final String MODERATION_UNMUTE_UUID_PERMISSION = "command.he.unbanuuid";
    public static final String MODERATION_BAN_UUID_PERMISSION = "command.he.banuuid";
    public static final String MODERATION_MUTE_UUID_PERMISSION = "command.he.muteuuid";
    public static final String MODERATION_BAN_HELD_ITEM_PERMISSION = "command.he.banhelditem";
    public static final String MODERATION_BAN_ITEM_PERMISSION = "command.he.banitem";
    public static final String MODERATION_RULES_PERMISSION = "command.he.banitem";
    public static final String MODERATION_REMOVE_BANNED_ITEM_PERMISSION = "command.he.removebanneditem";
    public static final String MODERATION_LIST_BANNED_ITEMS_PERMISSION = "command.he.listbanneditems";
    public static final String MODERATION_INVSEE_PERMISSION = "command.he.invsee";
    public static final String PLAYER_VANISH_PERMISSION = "command.he.vanish";
    public static final String PLAYER_HEAL_PERMISSION = "command.he.vanish";
    public static final String PLAYER_FEED_PERMISSION = "command.he.feed";
    public static final String PLAYER_ANVIL_PERMISSION = "command.he.anvil";
    public static final String PLAYER_SMITHING_PERMISSION = "command.he.smithingtable";
    public static final String PLAYER_CRAFTINGTABLE_PERMISSION = "command.he.craftingtable";
    public static final String PLAYER_STONECUTTER_PERMISSION = "command.he.stonecutter";
    public static final String PLAYER_FLY_PERMISSION = "command.he.fly";
    public static final String PLAYER_REPAIR_PERMISSION = "command.he.repair";
    public static final String PLAYER_ECHEST_PERMISSION = "command.he.echest";
    public static final String PLAYER_VIEW_OTHER_ECHEST_PERMISSION = "command.he.viewechest";
    public static final String PLAYER_PLAYTIME_PERMISSION = "command.he.playtime";
    public static final String PLAYER_AFK_PERMISSION = "command.he.afk";
    public static final String PLAYER_HAT_PERMISSION = "command.he.hat";
    public static final String TELEPORT_SET_SPAWN_PERMISSION = "command.he.setspawn";
    public static final String TELEPORT_GOSPAWN_PERMISSION = "command.he.spawn";
    public static final String TELEPORT_BACK_PERMISSION = "command.he.back";
    public static final String TELEPORT_TPA_PERMISSION = "command.he.tpa";
    public static final String TELEPORT_TPAHERE_PERMISSION = "command.he.tpahere";
    public static final String TELEPORT_TPAACCEPT_PERMISSION = "command.he.tpaaccept";
    public static final String TELEPORT_TPADENY_PERMISSION = "command.he.tpadeny";
    public static final String TELEPORT_SETHOME_PERMISSION = "command.he.sethome";
    public static final String TELEPORT_DELHOME_PERMISSION = "command.he.delhome";
    public static final String TELEPORT_GOHOME_PERMISSION = "command.he.home";
    public static final String TELEPORT_LISTHOME_PERMISSION = "command.he.listhomes";
    public static final String PERMISSION_ADD_USER_PERMISSION = "command.he.adduserperm";
    public static final String PERMISSION_ADD_UUID_PERMISSION = "command.he.adduuidperm";
    public static final String PERMISSION_REMOVE_USER_PERMISSION = "command.he.removeuserperm";
    public static final String PERMISSION_REMOVE_UUID_PERMISSION = "command.he.removeuuidperm";
    public static final String PERMISSION_ADD_GROUP_PERMISSION = "command.he.addgroupperm";
    public static final String PERMISSION_REMOVE_GROUP_PERMISSION = "command.he.removegroupperm";
    public static final String PERMISSION_PREFIX_ADD_USER_PERMISSION = "command.he.adduserprefix";
    public static final String PERMISSION_PREFIX_REMOVE_USER_PERMISSION = "command.he.removeuserprefix";
    public static final String PERMISSION_PREFIX_ADD_GROUP_PERMISSION = "command.he.addgroupprefix";
    public static final String PERMISSION_PREFIX_REMOVE_GROUP_PERMISSION = "command.he.removegroupprefix";
    public static final String PERMISSION_SUFFIX_ADD_USER_PERMISSION = "command.he.addusersuffix";
    public static final String PERMISSION_SUFFIX_REMOVE_USER_PERMISSION = "command.he.removeusersuffix";
    public static final String PERMISSION_SUFFIX_ADD_GROUP_PERMISSION = "command.he.addgroupsuffix";
    public static final String PERMISSION_SUFFIX_REMOVE_GROUP_PERMISSION = "command.he.removegroupsuffix";
    public static final String CONDITION_PERMISSION = "command.he.condition";
    public static final String CONDITION_UNREDEEM_PERMISSION = "command.he.condition.unredeem";
    public static final String CONDITION_MANUALREDEEM_PERMISSION = "command.he.condition.manualredeem";
    public static final String CONDITION_RELOADCONFIG_PERMISSION = "command.he.condition.reloadconfig";
    public static final String PAGE_PERMISSION = "command.he.page";
    public static final String PAGE_RELOADCONFIG_PERMISSION = "command.he.page.reloadconfig";
    public static final String AFK_KICK_BYPASS_PERMISSION = "he.afk.nokick";
    public static final String BANNED_ITEM_BYPASS_BASE_PERMISSION = "he.banneditem.bypass.";
    public static final String VANISH_ON_LOGIN_PERMISSION = "he.vanishonlogin";
    public static final String CHAT_FORMAT_CODE_PERMISSION_BASE = "he.chat.format.";
    public static final Map<Character, String> COLOR_CODE_PERMISSIONS = Map.ofEntries(Map.entry(Character.valueOf('0'), "black"), Map.entry(Character.valueOf('1'), "dark_blue"), Map.entry(Character.valueOf('2'), "dark_green"), Map.entry(Character.valueOf('3'), "dark_aqua"), Map.entry(Character.valueOf('4'), "dark_red"), Map.entry(Character.valueOf('5'), "dark_purple"), Map.entry(Character.valueOf('6'), "gold"), Map.entry(Character.valueOf('7'), "gray"), Map.entry(Character.valueOf('8'), "dark_gray"), Map.entry(Character.valueOf('9'), "blue"), Map.entry(Character.valueOf('a'), "green"), Map.entry(Character.valueOf('b'), "aqua"), Map.entry(Character.valueOf('c'), "red"), Map.entry(Character.valueOf('d'), "light_purple"), Map.entry(Character.valueOf('e'), "yellow"), Map.entry(Character.valueOf('f'), "white"), Map.entry(Character.valueOf('k'), "obfuscated"), Map.entry(Character.valueOf('l'), "bold"), Map.entry(Character.valueOf('m'), "strikethrough"), Map.entry(Character.valueOf('n'), "underline"), Map.entry(Character.valueOf('o'), "italic"), Map.entry(Character.valueOf('r'), "reset"));
    public static final String WARP_COMMAND_COOLDOWN_KEY = "he.warp";
    public static final String HOME_COMMAND_COOLDOWN_KEY = "he.home";
    public static final String BACK_COMMAND_COOLDOWN_KEY = "he.back";
    public static final String TPA_COMMAND_COOLDOWN_KEY = "he.tpa";

    public static boolean permissionCheck(UUID uuid, String permission, MinecraftServer minecraftServer) {
        if (!ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
            return true;
        }
        if (LuckPermsIntegration.isLuckPermsLoaded && ConfigManager.CONFIG.permissionConfigs.luckPermsOverridePermissions) {
            return LuckPermsIntegration.hasPermission(uuid, permission);
        }
        if (PermissionUserData.permissionCheckUser(uuid, permission, minecraftServer)) {
            return true;
        }
        return PermissionUserData.getAllUserGroupMemberships(uuid).stream().anyMatch(group -> PermissionGroupData.permissionCheckGroup(group, permission, minecraftServer));
    }

    public static boolean permissionCheckList(UUID uuid, List<String> permission, MinecraftServer minecraftServer) {
        if (!ConfigManager.CONFIG.permissionConfigs.permissionsEnabled) {
            return true;
        }
        if (LuckPermsIntegration.isLuckPermsLoaded && ConfigManager.CONFIG.permissionConfigs.luckPermsOverridePermissions) {
            return LuckPermsIntegration.checkPermission(uuid, permission);
        }
        boolean hasPerm = false;
        for (String perm2 : permission) {
            if (!PermissionUserData.permissionCheckUser(uuid, perm2, minecraftServer)) continue;
            return true;
        }
        return permission.stream().anyMatch(perm -> PermissionUserData.getAllUserGroupMemberships(uuid).stream().anyMatch(group -> PermissionGroupData.permissionCheckGroup(group, perm, minecraftServer)));
    }

    public static void updateCooldown(UUID uuid, String command, long cooldown) {
        cooldownsMap.computeIfAbsent(uuid, k -> new HashMap()).put(command, cooldown);
    }

    private static int extractMaxHomeLimit(List<String> permissions) {
        int max = 0;
        for (String perm : permissions) {
            if (!perm.startsWith("home.limit.")) continue;
            try {
                int limit = Integer.parseInt(perm.substring("home.limit.".length()));
                if (limit <= max) continue;
                max = limit;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return max;
    }

    public static int getMaxHomeLimit(UUID playerUUID) {
        int maxLimit = 0;
        ArrayList<String> userPermissions = new ArrayList();
        if (ConfigManager.CONFIG.permissionConfigs.permissionsEnabled && ConfigManager.CONFIG.permissionConfigs.luckPermsOverridePermissions) {
            return LuckPermsIntegration.getMaxHomeLimit(playerUUID);
        }
        userPermissions = PermissionUserData.getPermissionsForUser(playerUUID);
        maxLimit = Math.max(maxLimit, Permissions.extractMaxHomeLimit(userPermissions));
        List<String> groups = PermissionUserData.getAllUserGroupMemberships(playerUUID);
        for (String group : groups) {
            List<String> groupPermissions = PermissionGroupData.getPermissionsForGroup(group, CommonClass.minecraftServer);
            if (groupPermissions == null) continue;
            maxLimit = Math.max(maxLimit, Permissions.extractMaxHomeLimit(groupPermissions));
        }
        return maxLimit;
    }

    public static boolean cooldownChecker(UUID uuid, String cooldownKey) {
        if (ConfigManager.CONFIG.permissionConfigs.permissionsEnabled && Permissions.permissionCheck(uuid, cooldownKey + ".nocooldown", CommonClass.minecraftServer)) {
            return true;
        }
        Map playerCooldowns = cooldownsMap.getOrDefault(uuid, new HashMap());
        if (playerCooldowns.isEmpty()) {
            return true;
        }
        Long cooldown = playerCooldowns.getOrDefault(cooldownKey, 0L);
        return cooldown == null || cooldown <= System.currentTimeMillis();
    }

    public static void handleCooldownNotExpired(ServerPlayer p, String command) {
        long warpCooldown = ((Map)cooldownsMap.getOrDefault(p.getUUID(), new HashMap())).getOrDefault(command, 0L);
        if (warpCooldown > System.currentTimeMillis()) {
            long timeLeft = warpCooldown - System.currentTimeMillis();
            String cooldown = TextUtils.readableDuration(timeLeft);
            p.sendSystemMessage((Component)TextUtils.formatAndHighlight("Can't use this command yet! Cooldown: [" + cooldown + "]."));
        }
    }

    public static boolean hasGroupPermission(String playerPermission, String actualCommand) {
        List<String> commands = groupPermissions.get(playerPermission);
        if (commands == null) {
            return false;
        }
        HashSet<Object> allForms = new HashSet<Object>();
        allForms.add(actualCommand);
        Map<String, List<String>> aliasList = ConfigManager.CONFIG.aliasConfigs.aliasList;
        for (Map.Entry<String, List<String>> entry : aliasList.entrySet()) {
            String original = "command." + entry.getKey().replace(" ", ".").toLowerCase();
            List<String> list = entry.getValue();
            if (original.equalsIgnoreCase(actualCommand)) {
                for (String alias : list) {
                    allForms.add("command." + alias.toLowerCase());
                }
            }
            for (String alias : list) {
                String aliasPermission = "command." + alias.toLowerCase();
                if (!aliasPermission.equalsIgnoreCase(actualCommand)) continue;
                allForms.add(original);
            }
        }
        for (String perm : commands) {
            if (perm.endsWith("*")) {
                String prefix = perm.substring(0, perm.length() - 1);
                for (String string : allForms) {
                    if (!string.startsWith(prefix)) continue;
                    return true;
                }
                continue;
            }
            for (String string : allForms) {
                if (!perm.equalsIgnoreCase(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getDefinedGroups() {
        return groupPermissions.keySet();
    }
}

