/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.task;

import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.minecraft.server.MinecraftServer;

public class Task {
    private String name;
    private long intervalTicks;
    private Consumer<Task> action;
    private long lastRunTick = 0L;
    public boolean completed = false;

    private Task() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public void tick(MinecraftServer server) {
        long currentTick = server.getTickCount();
        if (currentTick - this.lastRunTick >= this.intervalTicks) {
            this.action.accept(this);
            this.lastRunTick = currentTick;
        }
    }

    public String getName() {
        return this.name;
    }

    public long getIntervalTicks() {
        return this.intervalTicks;
    }

    public static class Builder {
        private final Task task = new Task();

        public Builder name(String name) {
            this.task.name = name;
            return this;
        }

        public Builder interval(int duration, TimeUnit unit) {
            this.task.intervalTicks = unit.toSeconds(duration) * 20L;
            return this;
        }

        public Builder execute(Consumer<Task> action) {
            this.task.action = action;
            return this;
        }

        public Task build() {
            if (this.task.name == null || this.task.action == null || this.task.intervalTicks <= 0L) {
                throw new IllegalStateException("Task is missing required fields!");
            }
            return this.task;
        }
    }
}

