/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.task;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.Constants;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.PlayerData;
import com.henny.hennyessentials.data.WarpData;
import com.henny.hennyessentials.data.objects.Announcement;
import com.henny.hennyessentials.data.objects.Condition;
import com.henny.hennyessentials.data.objects.HEPlayer;
import com.henny.hennyessentials.permission.Permissions;
import com.henny.hennyessentials.task.Task;
import com.henny.hennyessentials.util.AFKHandler;
import com.henny.hennyessentials.util.ModerationUtils;
import com.henny.hennyessentials.util.TextUtils;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;

public class TaskManager {
    private static final List<Task> tasks = new ArrayList<Task>();

    public static void addTask(Task task) {
        tasks.add(task);
    }

    public static void removeTask(Task task) {
        tasks.remove(task);
    }

    public static void removeTask(String taskName) {
        tasks.removeIf(task -> task.getName().equals(taskName));
    }

    public static void tick(MinecraftServer server) {
        ListIterator<Task> li = tasks.listIterator();
        while (li.hasNext()) {
            Task task = li.next();
            if (task.completed) {
                li.remove();
                continue;
            }
            task.tick(server);
        }
    }

    public static void startHETasks() {
        Constants.LOG.info("Starting HE Tasks...");
        ListIterator<Task> li = tasks.listIterator();
        while (li.hasNext()) {
            Task task2 = li.next();
            if (task2.getName().contains("AnnouncementTask")) continue;
            li.remove();
        }
        AtomicInteger minsSinceStarted = new AtomicInteger(1);
        int restartEveryXMins = ConfigManager.CONFIG.moderationConfigs.restartConfigs.restartEveryXMinutes;
        Task restartTask = Task.builder().name("Restart Task").interval(1, TimeUnit.MINUTES).execute(task -> {
            int elapsedMins = minsSinceStarted.getAndIncrement();
            int minsLeft = restartEveryXMins - elapsedMins;
            if (minsLeft <= 5 && minsLeft > 0) {
                CommonClass.minecraftServer.getPlayerList().getPlayers().forEach(sp -> {
                    if (ConfigManager.CONFIG.moderationConfigs.restartConfigs.restartWarningShouldPlaySound) {
                        sp.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_PLING.value(), SoundSource.AMBIENT, 1.0f, 1.0f);
                    }
                    sp.sendSystemMessage((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.restartConfigs.restartWarningText.replace("%m", String.valueOf(minsLeft))), true);
                });
            }
            if (minsLeft == 0) {
                for (ServerPlayer sp2 : new ArrayList(CommonClass.minecraftServer.getPlayerList().getPlayers())) {
                    sp2.connection.disconnect((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.restartConfigs.restartDisconnectText));
                }
                CommonClass.minecraftServer.getCommands().performCommand(CommonClass.minecraftServer.getCommands().getDispatcher().parse("stop", (Object)CommonClass.minecraftServer.createCommandSourceStack().withPermission(4)), "stop");
            }
        }).build();
        Task purgeExpiredBansMutesTask = Task.builder().name("purgeExpiredBansMutes").interval(ConfigManager.CONFIG.moderationConfigs.taskConfigs.purgeExpiredBansAndMutesTaskIntervalMinutes, TimeUnit.MINUTES).execute(task -> {
            if (CommonClass.minecraftServer != null) {
                PlayerData.getUserData(CommonClass.minecraftServer).purgeExpiredBansMutes();
            }
        }).build();
        Task purgeExpiredWarpsTask = Task.builder().name("purgeExpiredWarpsTask").interval(ConfigManager.CONFIG.moderationConfigs.taskConfigs.purgeExpiredWarpsTaskIntervalMinutes, TimeUnit.MINUTES).execute(task -> {
            if (CommonClass.minecraftServer != null) {
                WarpData.getWarpData(CommonClass.minecraftServer).purgeExpired();
            }
        }).build();
        Task playtimeTrackerTask = Task.builder().name("playtimeTrackerTask").interval(ConfigManager.CONFIG.moderationConfigs.taskConfigs.playtimeTrackerTaskIntervalSeconds, TimeUnit.SECONDS).execute(t -> {
            if (CommonClass.minecraftServer != null) {
                for (ServerPlayer sp : CommonClass.minecraftServer.getPlayerList().getPlayers()) {
                    HEPlayer pData = PlayerData.getSpecificUserData(CommonClass.minecraftServer, sp.getUUID());
                    if (AFKHandler.isPlayerAFK(sp.getUUID()) && !ConfigManager.CONFIG.moderationConfigs.afkConfigs.shouldAFKCountAsPlaytime) continue;
                    int playtime = Integer.parseInt(pData.playerInfo.getOrDefault("playtime", "0"));
                    pData.updatePlayerInfo("playtime", String.valueOf(playtime += ConfigManager.CONFIG.moderationConfigs.taskConfigs.playtimeTrackerTaskIntervalSeconds));
                    for (Condition condition : ConfigManager.conditions) {
                        String hasAlreadyRedeemed;
                        if (!condition.type.equals("playtime") || !(condition.triggerValue instanceof Double) || !((double)playtime >= (Double)condition.triggerValue) || Boolean.parseBoolean(hasAlreadyRedeemed = PlayerData.getUserData().getPlayerInfoValue(sp.getUUID(), condition.conditionID + "-condition"))) continue;
                        for (String cmd : condition.commands) {
                            cmd = cmd.replace("%p", sp.getScoreboardName());
                            Commands commands = CommonClass.minecraftServer.getCommands();
                            ParseResults parseRes = commands.getDispatcher().parse(cmd, (Object)CommonClass.minecraftServer.createCommandSourceStack());
                            try {
                                commands.getDispatcher().execute(parseRes);
                            }
                            catch (CommandSyntaxException e) {
                                Constants.LOG.info(e.getLocalizedMessage());
                            }
                        }
                        PlayerData.getUserData().updatePlayerInfo(sp.getUUID(), condition.conditionID + "-condition", String.valueOf(true));
                    }
                }
            }
        }).build();
        Task checkPlayersHavePermsCommandsTask = Task.builder().name("checkPlayersHavePermsCommandsTask").interval(ConfigManager.CONFIG.moderationConfigs.taskConfigs.checkPlayersHavePermissionsForCommandsTaskIntervalSeconds, TimeUnit.SECONDS).execute(task -> {
            if (CommonClass.minecraftServer != null) {
                ServerPlayer p;
                for (Map.Entry<UUID, Boolean> entry : CommonClass.playersInFly.entrySet()) {
                    p = CommonClass.minecraftServer.getPlayerList().getPlayer(entry.getKey());
                    if (p == null || Permissions.permissionCheck(p.getUUID(), "command.he.fly", CommonClass.minecraftServer)) continue;
                    p.getAbilities().mayfly = false;
                    p.getAbilities().flying = false;
                    p.onUpdateAbilities();
                    CommonClass.playersInFly.put(p.getUUID(), false);
                    if (!p.getTags().contains("he.fly")) continue;
                    p.removeTag("he.fly");
                }
                for (Map.Entry<UUID, Boolean> entry : CommonClass.playersInVanish.entrySet()) {
                    p = CommonClass.minecraftServer.getPlayerList().getPlayer(entry.getKey());
                    if (p == null || Permissions.permissionCheck(p.getUUID(), "command.he.vanish", CommonClass.minecraftServer)) continue;
                    CommonClass.playersInVanish.put(p.getUUID(), false);
                    p.removeEffect(MobEffects.INVISIBILITY);
                    p.setInvisible(false);
                    if (!p.getTags().contains("he.vanish")) continue;
                    p.removeTag("he.vanish");
                }
                if (CommonClass.minecraftServer != null) {
                    for (ServerPlayer p2 : CommonClass.minecraftServer.getPlayerList().getPlayers()) {
                        if (!(p2 instanceof ServerPlayer)) continue;
                        if (p2.getTags().contains("he.fly") && !Permissions.permissionCheck(p2.getUUID(), "command.he.fly", CommonClass.minecraftServer)) {
                            p2.getAbilities().mayfly = false;
                            p2.onUpdateAbilities();
                            CommonClass.playersInFly.put(p2.getUUID(), false);
                            p2.removeTag("he.fly");
                        }
                        if (!p2.getTags().contains("he.vanish") || Permissions.permissionCheck(p2.getUUID(), "command.he.vanish", CommonClass.minecraftServer)) continue;
                        p2.setInvisible(false);
                        CommonClass.playersInVanish.put(p2.getUUID(), false);
                        p2.removeTag("he.vanish");
                    }
                }
            }
        }).build();
        Task checkPlayersHavePermsDimensionsTask = Task.builder().name("checkPlayersHavePermsDimensionsTask").interval(ConfigManager.CONFIG.moderationConfigs.taskConfigs.checkPlayersHavePermissionsForDimensionTaskIntervalSeconds, TimeUnit.SECONDS).execute(task -> {
            if (CommonClass.minecraftServer != null) {
                for (ServerPlayer p : CommonClass.minecraftServer.getPlayerList().getPlayers()) {
                    if (!(p instanceof ServerPlayer) || p.serverLevel().dimension().location().toString().equals(ConfigManager.CONFIG.permissionConfigs.defaultDimensionNoPermsRequired) || Permissions.permissionCheck(p.getUUID(), "dimension." + p.serverLevel().dimension().location().toString(), CommonClass.minecraftServer)) continue;
                    ServerLevel ow = CommonClass.minecraftServer.overworld();
                    String prevLevel = p.serverLevel().dimension().location().toString();
                    p.teleportTo(ow, (double)ow.getSharedSpawnPos().getX(), (double)ow.getSharedSpawnPos().getY(), (double)ow.getSharedSpawnPos().getZ(), p.getXRot(), p.getYRot());
                    p.sendSystemMessage((Component)Component.literal((String)ConfigManager.CONFIG.commandConfigs.teleportConfigs.normalTeleportToDimNoPermission.replace("%dimension%", prevLevel)));
                }
            }
        }).build();
        Task bannedItemsCheckTask = Task.builder().name("BannedItemsChecker").interval(ConfigManager.CONFIG.moderationConfigs.taskConfigs.bannedItemsInventoryCheckTaskIntervalSeconds, TimeUnit.SECONDS).execute(t -> {
            for (ServerPlayer p : CommonClass.minecraftServer.getPlayerList().getPlayers()) {
                p.getInventory().items.stream().filter(itemStack -> ConfigManager.BANNED_ITEMS_MAP.containsKey(BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString())).findFirst().ifPresent(is -> {
                    if (!Permissions.permissionCheck(p.getUUID(), "he.banneditem.bypass." + BuiltInRegistries.ITEM.getKey((Object)is.getItem()).toString(), p.getServer())) {
                        ModerationUtils.handleBannedItem(is, p);
                    }
                });
            }
        }).build();
        if (ConfigManager.CONFIG.moderationConfigs.taskConfigs.shouldRunPlaytimeTrackerTask) {
            TaskManager.addTask(playtimeTrackerTask);
        }
        if (ConfigManager.CONFIG.moderationConfigs.taskConfigs.shouldRunBannedItemsInventoryCheckTask) {
            TaskManager.addTask(bannedItemsCheckTask);
        }
        if (ConfigManager.CONFIG.moderationConfigs.taskConfigs.shouldRunCommandPermCheckTask) {
            TaskManager.addTask(checkPlayersHavePermsCommandsTask);
        }
        if (ConfigManager.CONFIG.permissionConfigs.permissionRequiredToEnterDimensions && ConfigManager.CONFIG.moderationConfigs.taskConfigs.shouldRunDimensionPermCheckTask) {
            TaskManager.addTask(checkPlayersHavePermsDimensionsTask);
        }
        if (ConfigManager.CONFIG.moderationConfigs.restartConfigs.autoRestartEnabled) {
            TaskManager.addTask(restartTask);
            Constants.LOG.info("Starting restart task with delay of {} minutes", (Object)ConfigManager.CONFIG.moderationConfigs.restartConfigs.restartEveryXMinutes);
        }
        TaskManager.addTask(purgeExpiredWarpsTask);
        TaskManager.addTask(purgeExpiredBansMutesTask);
    }

    public static void startAnnouncementTasks() {
        ListIterator<Task> li = tasks.listIterator();
        while (li.hasNext()) {
            Task task = li.next();
            if (!task.getName().contains("AnnouncementTask")) continue;
            li.remove();
        }
        int counter = 0;
        for (Announcement announcement : ConfigManager.announcementsConfig.announcements) {
            Task task = Task.builder().interval(announcement.secondsDelay, TimeUnit.SECONDS).name("AnnouncementTask-" + ++counter).execute(t -> {
                MutableComponent msg2 = announcement.announcementText.contains("{\"text\":") ? Component.Serializer.fromJson((String)announcement.announcementText, (HolderLookup.Provider)CommonClass.minecraftServer.registryAccess()) : Component.literal((String)announcement.announcementText);
                MutableComponent msg = Component.Serializer.fromJsonLenient((String)announcement.announcementText, (HolderLookup.Provider)CommonClass.minecraftServer.registryAccess()) == null ? Component.literal((String)announcement.announcementText) : Component.Serializer.fromJsonLenient((String)announcement.announcementText, (HolderLookup.Provider)CommonClass.minecraftServer.registryAccess());
                MutableComponent prefix = TextUtils.formatMessage("");
                MutableComponent main = Component.literal((String)"");
                CommonClass.minecraftServer.getPlayerList().broadcastSystemMessage((Component)main.append((Component)prefix).append((Component)msg2), false);
            }).build();
            TaskManager.addTask(task);
        }
    }
}

