/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.util;

import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.data.objects.PlayerAFKData;
import com.henny.hennyessentials.permission.Permissions;
import com.henny.hennyessentials.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public class AFKHandler {
    public static Map<UUID, PlayerAFKData> AFKTracker = new HashMap<UUID, PlayerAFKData>();
    public static Map<UUID, Vec3> lastPositions = new HashMap<UUID, Vec3>();

    public static boolean isPlayerAFK(UUID playerUUID) {
        if (!AFKTracker.containsKey(playerUUID)) {
            return false;
        }
        return AFKHandler.AFKTracker.get((Object)playerUUID).isAFK;
    }

    public static void setAFKStatus(ServerPlayer player, boolean status) {
        AFKTracker.compute(player.getUUID(), (uuid, data) -> {
            if (data == null) {
                return new PlayerAFKData(System.currentTimeMillis(), status);
            }
            data.isAFK = true;
            return data;
        });
    }

    public static void updatePlayer(ServerPlayer player) {
        AFKTracker.compute(player.getUUID(), (uuid, data) -> {
            if (data == null) {
                return new PlayerAFKData(System.currentTimeMillis(), false);
            }
            if (data.isAFK && data.justWentAFK) {
                data.justWentAFK = false;
                return data;
            }
            if (!data.justWentAFK) {
                data.lastActiveTime = System.currentTimeMillis();
            }
            return data;
        });
    }

    public static void markAFK(ServerPlayer player) {
        long now = System.currentTimeMillis();
        PlayerAFKData data = AFKTracker.computeIfAbsent(player.getUUID(), uuid -> new PlayerAFKData(now, false));
        if (!data.isAFK) {
            data.isAFK = true;
            data.afkStartTime = now;
            data.justWentAFK = true;
            player.sendSystemMessage((Component)TextUtils.getModPrefix().append((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.afkConfigs.afkMessageToPlayer)));
            if (ConfigManager.CONFIG.moderationConfigs.afkConfigs.broadcastAFKToEntireServer) {
                player.server.getPlayerList().broadcastSystemMessage((Component)TextUtils.getModPrefix().append((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.afkConfigs.broadcastAFKToServerMessage.replace("%playername%", player.getName().getString()))), false);
            }
        }
    }

    public static void tick(MinecraftServer server) {
        long now = System.currentTimeMillis();
        long kickAfterMillis = TimeUnit.SECONDS.toMillis(ConfigManager.CONFIG.moderationConfigs.afkConfigs.kickAFKPlayerAfterXSeconds);
        int AFK_TIMEOUT_SECONDS = ConfigManager.CONFIG.moderationConfigs.afkConfigs.afkTimeoutSeconds;
        ArrayList<ServerPlayer> playersToKick = new ArrayList<ServerPlayer>();
        for (ServerPlayer p : server.getPlayerList().getPlayers()) {
            boolean isNowAFK;
            boolean hasMoved;
            Vec3 lastPos = lastPositions.computeIfAbsent(p.getUUID(), uuid -> p.position());
            boolean bl = hasMoved = !lastPos.equals((Object)p.position()) && !lastPos.closerThan((Position)p.position(), 0.1);
            if (hasMoved) {
                AFKHandler.updatePlayer(p);
                lastPositions.put(p.getUUID(), p.position());
            }
            PlayerAFKData data = AFKTracker.computeIfAbsent(p.getUUID(), uuid -> new PlayerAFKData(now, false));
            boolean wasAFK = data.isAFK;
            long timeSinceLastActive = now - data.lastActiveTime;
            boolean bl2 = isNowAFK = timeSinceLastActive > TimeUnit.SECONDS.toMillis(AFK_TIMEOUT_SECONDS);
            if (isNowAFK && !wasAFK) {
                data.isAFK = true;
                data.afkStartTime = now;
                p.sendSystemMessage((Component)Component.literal((String)"").append((Component)TextUtils.formatMessage("")).append((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.afkConfigs.afkMessageToPlayer)));
                if (ConfigManager.CONFIG.moderationConfigs.afkConfigs.broadcastAFKToEntireServer) {
                    server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)"").append((Component)TextUtils.formatMessage("")).append((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.afkConfigs.broadcastAFKToServerMessage.replace("%playername%", p.getName().getString()))), false);
                }
            }
            if (!isNowAFK && wasAFK && !data.justWentAFK) {
                data.isAFK = false;
                data.afkStartTime = 0L;
                p.sendSystemMessage((Component)Component.literal((String)"").append((Component)TextUtils.formatMessage("").append((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.afkConfigs.afkReturnMessageToPlayer))));
                if (ConfigManager.CONFIG.moderationConfigs.afkConfigs.broadcastAFKToEntireServer) {
                    server.getPlayerList().broadcastSystemMessage((Component)Component.literal((String)"").append((Component)TextUtils.formatMessage("")).append((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.afkConfigs.broadcastReturnToServerMessage.replace("%playername%", p.getName().getString()))), false);
                }
            }
            if (!ConfigManager.CONFIG.moderationConfigs.afkConfigs.enableAFKKick || !data.isAFK || now - data.afkStartTime <= kickAfterMillis) continue;
            playersToKick.add(p);
        }
        for (ServerPlayer p : playersToKick) {
            if (Permissions.permissionCheck(p.getUUID(), "he.afk.nokick", server)) continue;
            p.connection.disconnect((Component)Component.literal((String)ConfigManager.CONFIG.moderationConfigs.afkConfigs.afkKickMessage));
            AFKTracker.remove(p.getUUID());
        }
    }
}

