/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.util;

import com.henny.hennyessentials.CommonClass;
import com.henny.hennyessentials.data.PlayerData;
import com.henny.hennyessentials.util.TextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class BackHandler {
    private static final Map<UUID, GlobalPos> lastDeathLocations = new HashMap<UUID, GlobalPos>();

    public static void setLastDeathLocation(ServerPlayer player, GlobalPos pos) {
        lastDeathLocations.put(player.getUUID(), pos);
        PlayerData.getUserData(player.server).updatePlayerInfo(player.getUUID(), "lastDeath", TextUtils.serializeGlobalPos(pos));
    }

    public static GlobalPos getLastDeathLocation(ServerPlayer player) {
        return lastDeathLocations.get(player.getUUID());
    }

    public static boolean hasBackLocation(ServerPlayer player) {
        if (!lastDeathLocations.containsKey(player.getUUID())) {
            GlobalPos pos;
            if (!PlayerData.getUserData(CommonClass.minecraftServer).getPlayerInfoValue(player.getUUID(), "lastDeath").isBlank() && (pos = TextUtils.deserializeGlobalPos(PlayerData.getUserData(CommonClass.minecraftServer).getPlayerInfoValue(player.getUUID(), "lastDeath"))) != null) {
                lastDeathLocations.put(player.getUUID(), pos);
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public static boolean isSafe(ServerLevel level, BlockPos pos) {
        BlockState feet = level.getBlockState(pos);
        BlockState head = level.getBlockState(pos.above());
        BlockState below = level.getBlockState(pos.below());
        boolean spaceClear = !(!feet.isAir() && !feet.canBeReplaced() || !head.isAir() && !head.canBeReplaced());
        boolean notDangerous = !feet.is(Blocks.LAVA) && !feet.is(Blocks.FIRE) && !head.is(Blocks.LAVA) && !head.is(Blocks.FIRE);
        boolean hasGround = below.isSolid() && !below.isAir() && !below.liquid();
        return spaceClear && notDangerous && hasGround;
    }

    public static BlockPos findSafeNearby(ServerLevel level, BlockPos center, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -2; dy <= 2; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos check = center.offset(dx, dy, dz);
                    if (!BackHandler.isSafe(level, check)) continue;
                    return check;
                }
            }
        }
        return null;
    }
}

