/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.util;

import com.henny.hennyessentials.Constants;
import com.henny.hennyessentials.config.ConfigManager;
import com.henny.hennyessentials.util.TextUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ModerationUtils {
    public static boolean isBannedItem(Item item) {
        boolean isBannedItem = false;
        if (ConfigManager.bannedItemsConfig.bannedItems.stream().anyMatch(b -> b.id().equals(BuiltInRegistries.ITEM.getKey((Object)item).toString()))) {
            isBannedItem = true;
        }
        return isBannedItem;
    }

    public static void handleBannedItem(ItemStack item, ServerPlayer owner) {
        String regName = BuiltInRegistries.ITEM.getKey((Object)item.getItem()).toString();
        if (ConfigManager.CONFIG.moderationConfigs.bannedItemsConfigs.shouldRemoveBannedItemFromPlayer) {
            item.setCount(-item.getCount());
        }
        owner.getInventory().items.forEach(itemStack -> {
            if (BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem()).toString().equals(regName) && ConfigManager.CONFIG.moderationConfigs.bannedItemsConfigs.shouldRemoveBannedItemFromPlayer) {
                itemStack.shrink(itemStack.getCount());
            }
        });
        owner.sendSystemMessage((Component)TextUtils.formatMessage(ConfigManager.CONFIG.moderationConfigs.bannedItemsConfigs.bannedItemMessageToPlayer.replace("%item%", regName).replace("%reason%", ConfigManager.bannedItemsConfig.bannedItems.stream().filter(bannedItem -> bannedItem.id().equals(regName)).findFirst().get().reason())));
        if (ConfigManager.CONFIG.moderationConfigs.auditConfigs.shouldWriteBannedItemPickupToAuditLog) {
            String auditLogEntry = owner.getScoreboardName() + " was caught with item: " + regName + ". Player UUID is: " + String.valueOf(owner.getUUID());
            ModerationUtils.writeToAuditLog("BANNED ITEM", auditLogEntry);
        }
    }

    public static void writeToAuditLog(String type, String text) {
        String timestamp = new SimpleDateFormat(ConfigManager.CONFIG.moderationConfigs.auditConfigs.auditLogTimestampFormat).format(new Date());
        String line = "[" + timestamp + "] [" + type + "] " + text;
        File logDir = new File(ConfigManager.configDir, "logs");
        if (!logDir.exists()) {
            logDir.mkdirs();
        }
        File logFile = new File(logDir, "AuditLog.txt");
        try {
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Cannot create audit log: {}", (Object)e.getLocalizedMessage());
        }
        try (BufferedWriter w = new BufferedWriter(new FileWriter(logFile, StandardCharsets.UTF_8, true));){
            w.write(line);
            w.newLine();
        }
        catch (Exception e) {
            Constants.LOG.error("Error writing to audit log: {}", (Object)e.getLocalizedMessage());
        }
    }
}

