/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.util;

import com.henny.hennyessentials.data.objects.PaginationPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class Pagination {
    public ServerPlayer receiver;
    public List<PaginationPage> pages;
    public static Map<UUID, Runnable> callbackRunnables = new HashMap<UUID, Runnable>();
    public int currentIndex;
    public int linesPerPage;
    public String paddingString;
    public String headerString;
    private static final String FOOTER_MARKER = "[footer-marker]";

    public Pagination(PaginationBuilder builder) {
        this.receiver = builder.receiver;
        this.pages = builder.paginationPages;
        this.linesPerPage = builder.linesPerPage;
        this.paddingString = builder.paddingString;
        this.headerString = builder.headerString;
    }

    public void send() {
        if (this.pages.isEmpty()) {
            this.receiver.sendSystemMessage((Component)Component.literal((String)"No content to display."));
            return;
        }
        MutableComponent currPage = this.pages.get((int)this.currentIndex).contents;
        boolean found = false;
        for (Component comp : currPage.getSiblings()) {
            Style style = comp.getStyle();
            if (style.getFont() == null || !style.getFont().toString().equals("hennyessentials:invisible")) continue;
            found = true;
            break;
        }
        if (!found) {
            MutableComponent footer1 = Component.literal((String)String.valueOf(this.paddingString).repeat(18));
            MutableComponent footer3 = Component.literal((String)(this.currentIndex + 1 + "/" + this.pages.size()));
            MutableComponent footer5 = Component.literal((String)String.valueOf(this.paddingString).repeat(18));
            MutableComponent footer2 = this.sendTextWithRunnableClickAction(() -> {
                if (this.currentIndex - 1 > -1) {
                    this.prevPage(this.currentIndex);
                    this.send();
                }
            }, Component.literal((String)"\u00a7l<"));
            MutableComponent footer4 = this.sendTextWithRunnableClickAction(() -> {
                if (this.currentIndex + 1 < this.pages.size()) {
                    this.nextPage(this.currentIndex);
                    this.send();
                }
            }, Component.literal((String)"\u00a7l>"));
            currPage.append((Component)Component.literal((String)"\n"));
            currPage.append((Component)footer1);
            currPage.append((Component)footer2);
            currPage.append((Component)footer3);
            currPage.append((Component)footer4);
            currPage.append((Component)footer5);
            currPage.append((Component)Component.literal((String)"").withStyle(Style.EMPTY.withFont(ResourceLocation.fromNamespaceAndPath((String)"hennyessentials", (String)"invisible"))));
        }
        this.receiver.sendSystemMessage((Component)currPage);
    }

    public void nextPage(int currentPage) {
        if (this.pages.size() > currentPage && this.pages.get(currentPage) != null) {
            ++this.currentIndex;
        }
    }

    public void prevPage(int currentPage) {
        if (this.pages.size() > currentPage && this.pages.get(currentPage) != null) {
            --this.currentIndex;
        }
    }

    public MutableComponent sendTextWithRunnableClickAction(Runnable click, MutableComponent text) {
        MutableComponent newComp = text.copy();
        UUID runanbleID = UUID.randomUUID();
        callbackRunnables.put(runanbleID, click);
        return newComp.setStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/he pcallback " + String.valueOf(runanbleID))));
    }

    public static class PaginationBuilder {
        private final ServerPlayer receiver;
        private final List<MutableComponent> textPages;
        private List<PaginationPage> paginationPages = new ArrayList<PaginationPage>();
        private int linesPerPage = 15;
        private String paddingString;
        private String headerString = this.paddingString = "=";

        public PaginationBuilder(ServerPlayer receiver, List<MutableComponent> pages) {
            this.receiver = receiver;
            this.textPages = pages;
        }

        public PaginationBuilder linesPerPage(int linesPerPage) {
            this.linesPerPage = linesPerPage;
            return this;
        }

        public PaginationBuilder header(String headerString) {
            this.headerString = headerString;
            return this;
        }

        public PaginationBuilder padding(String paddingString) {
            this.paddingString = paddingString;
            return this;
        }

        public Pagination build() {
            ArrayList<MutableComponent> pages = new ArrayList<MutableComponent>();
            int headerSize = this.headerString.length();
            int paddingSize = 21 - headerSize / 2;
            String multipliedPadding = String.valueOf(this.paddingString).repeat(paddingSize);
            MutableComponent header = Component.literal((String)(multipliedPadding + this.headerString + multipliedPadding));
            MutableComponent parent = Component.literal((String)"");
            int counter = 0;
            parent.append((Component)header);
            parent.append("\n");
            for (Component component : this.textPages) {
                parent.append(component);
                parent.append("\n");
                if (++counter < this.linesPerPage) continue;
                pages.add(parent);
                parent = Component.literal((String)"");
                parent.append((Component)header);
                parent.append("\n");
                counter = 0;
            }
            if (counter > 0) {
                pages.add(parent);
            }
            for (MutableComponent mutableComponent : pages) {
                this.paginationPages.add(new PaginationPage(UUID.randomUUID(), mutableComponent, this.receiver));
            }
            return new Pagination(this);
        }
    }
}

