/*
 * Decompiled with CFR 0.152.
 */
package com.henny.hennyessentials.util;

import com.henny.hennyessentials.config.ConfigManager;
import java.time.Duration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class TextUtils {
    private static final String DURATION_REGEX = "(\\d+)([YMWDms])";
    private static final Pattern pattern = Pattern.compile("(\\d+)([YMWDms])");

    public static String readableDuration(long millis) {
        Duration duration = Duration.ofMillis(millis);
        long days = duration.toDays();
        long years = days / 365L;
        long months = days % 365L / 30L;
        long weeks = days % 365L % 30L / 7L;
        long remainingDays = days % 365L % 30L % 7L;
        long hours = duration.toHours() % 24L;
        long minutes = duration.toMinutes() % 60L;
        long seconds = duration.getSeconds() % 60L;
        LinkedHashMap<String, Long> timeMap = new LinkedHashMap<String, Long>();
        timeMap.put("Y", years);
        timeMap.put("M", months);
        timeMap.put("W", weeks);
        timeMap.put("d", remainingDays);
        timeMap.put("h", hours);
        timeMap.put("m", minutes);
        timeMap.put("s", seconds);
        StringBuilder readableTime = new StringBuilder();
        for (Map.Entry entry : timeMap.entrySet()) {
            long value = (Long)entry.getValue();
            if (value <= 0L) continue;
            readableTime.append(value).append((String)entry.getKey());
        }
        return readableTime.length() > 0 ? readableTime.toString() : "less than a second";
    }

    public static String serializeGlobalPos(GlobalPos pos) {
        ResourceLocation dimensionId = pos.dimension().location();
        BlockPos blockPos = pos.pos();
        return String.valueOf(dimensionId) + ":" + blockPos.getX() + "," + blockPos.getY() + "," + blockPos.getZ();
    }

    public static Set<Character> extractFormats(String rawMessage) {
        HashSet<Character> usedCodes = new HashSet<Character>();
        for (int i = 0; i < rawMessage.length() - 1; ++i) {
            if (rawMessage.charAt(i) != '\u00a7') continue;
            char code = Character.toLowerCase(rawMessage.charAt(i + 1));
            usedCodes.add(Character.valueOf(code));
        }
        return usedCodes;
    }

    public static GlobalPos deserializeGlobalPos(String str) {
        try {
            String[] parts = str.split(":");
            if (parts.length != 3) {
                return null;
            }
            ResourceLocation dimensionId = ResourceLocation.fromNamespaceAndPath((String)parts[0], (String)parts[1]);
            String[] coords = parts[2].split(",");
            if (coords.length != 3) {
                return null;
            }
            int x = Integer.parseInt(coords[0]);
            int y = Integer.parseInt(coords[1]);
            int z = Integer.parseInt(coords[2]);
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionId);
            return GlobalPos.of((ResourceKey)dimension, (BlockPos)new BlockPos(x, y, z));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MutableComponent formatMessage(String message) {
        Style grayBoldStyle = Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GRAY});
        Style greenStyle = Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.GREEN});
        MutableComponent prefix = Component.literal((String)"[").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GRAY});
        MutableComponent restOfPrefix = Component.literal((String)"HEssentials").withStyle(greenStyle);
        MutableComponent endOfPrefix = Component.literal((String)"]").withStyle(grayBoldStyle);
        MutableComponent resetComponent = Component.literal((String)"").withStyle(ChatFormatting.RESET);
        Style style = Style.EMPTY.withColor(ChatFormatting.GREEN).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Henny Essentials Mod").withStyle(ChatFormatting.GREEN)));
        MutableComponent prefixFull = Component.literal((String)"").append((Component)prefix).append((Component)resetComponent).withStyle(ChatFormatting.RESET).append((Component)restOfPrefix).append((Component)endOfPrefix).withStyle(style);
        MutableComponent returnComp = Component.literal((String)"");
        MutableComponent prefixComp = Component.literal((String)"");
        if (!ConfigManager.CONFIG.modMessagePrefix.isBlank()) {
            MutableComponent idk = Component.literal((String)ConfigManager.CONFIG.modMessagePrefix);
            Style style2 = idk.getStyle();
            style2 = style2.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Henny Essentials Mod").withStyle(ChatFormatting.GREEN)));
            idk = idk.withStyle(style2);
            prefixComp = Component.literal((String)"").append((Component)idk);
        }
        returnComp = !ConfigManager.CONFIG.modMessagePrefix.isBlank() ? Component.literal((String)"").append((Component)prefixComp).append((Component)Component.literal((String)(" " + message)).withStyle(ChatFormatting.GREEN)) : Component.literal((String)"").append((Component)Component.literal((String)message).withStyle(ChatFormatting.GREEN));
        return Component.literal((String)"").append((Component)prefixComp).append((Component)Component.literal((String)message).withStyle(ChatFormatting.GREEN));
    }

    public static MutableComponent formatAndHighlight(String message) {
        Style grayBoldStyle = Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GRAY});
        Style greenStyle = Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.GREEN});
        MutableComponent prefix = Component.literal((String)"[").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GRAY});
        MutableComponent restOfPrefix = Component.literal((String)"HEssentials").withStyle(greenStyle);
        MutableComponent endOfPrefix = Component.literal((String)"]").withStyle(grayBoldStyle);
        MutableComponent resetComponent = Component.literal((String)"").withStyle(ChatFormatting.RESET);
        Style style = Style.EMPTY.withColor(ChatFormatting.GREEN).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Henny Essentials Mod").withStyle(ChatFormatting.GREEN)));
        MutableComponent prefixComp = Component.literal((String)"");
        if (!ConfigManager.CONFIG.modMessagePrefix.isBlank()) {
            MutableComponent idk = Component.literal((String)ConfigManager.CONFIG.modMessagePrefix);
            Style style2 = idk.getStyle();
            style2 = style2.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Henny Essentials Mod").withStyle(ChatFormatting.GREEN)));
            idk = idk.withStyle(style2);
            prefixComp = Component.literal((String)"").append((Component)idk);
        }
        MutableComponent result = Component.literal((String)"").append((Component)prefixComp).append((Component)resetComponent);
        int index = 0;
        while (index < message.length()) {
            int end;
            int start = message.indexOf(91, index);
            if (start == -1) {
                result.append((Component)Component.literal((String)message.substring(index)).withStyle(ChatFormatting.GREEN));
                break;
            }
            if (start > index) {
                result.append((Component)Component.literal((String)message.substring(index, start)).withStyle(ChatFormatting.GREEN));
            }
            if ((end = message.indexOf(93, start)) == -1) {
                result.append((Component)Component.literal((String)message.substring(start)).withStyle(ChatFormatting.GREEN));
                break;
            }
            String inside = message.substring(start + 1, end);
            result.append((Component)Component.literal((String)("[" + inside + "]")).withStyle(ChatFormatting.GOLD));
            index = end + 1;
        }
        return result;
    }

    public static MutableComponent getModPrefix() {
        MutableComponent prefixComp = Component.literal((String)"");
        if (!ConfigManager.CONFIG.modMessagePrefix.isBlank()) {
            MutableComponent idk = Component.literal((String)ConfigManager.CONFIG.modMessagePrefix);
            Style style = idk.getStyle();
            style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Henny Essentials Mod").withStyle(ChatFormatting.GREEN)));
            idk = idk.withStyle(style);
            prefixComp = Component.literal((String)"").append((Component)idk);
        }
        return prefixComp;
    }

    public static MutableComponent formatMessageWithHighlight(String prefixStr, String highlight, String suffixStr) {
        Style grayBoldStyle = Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GRAY});
        Style greenStyle = Style.EMPTY.applyFormats(new ChatFormatting[]{ChatFormatting.GREEN});
        MutableComponent prefix = Component.literal((String)"[").withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_GRAY});
        MutableComponent restOfPrefix = Component.literal((String)"HEssentials").withStyle(greenStyle);
        MutableComponent endOfPrefix = Component.literal((String)"]").withStyle(grayBoldStyle);
        MutableComponent resetComponent = Component.literal((String)"").withStyle(ChatFormatting.RESET);
        MutableComponent prefixComp = Component.literal((String)"");
        if (!ConfigManager.CONFIG.modMessagePrefix.isBlank()) {
            MutableComponent idk = Component.literal((String)ConfigManager.CONFIG.modMessagePrefix);
            Style style = idk.getStyle();
            style = style.withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Henny Essentials Mod").withStyle(ChatFormatting.GREEN)));
            idk = idk.withStyle(style);
            prefixComp = Component.literal((String)"").append((Component)idk);
        }
        return Component.literal((String)"").append((Component)prefixComp).append((Component)resetComponent).withStyle(ChatFormatting.RESET).append((Component)resetComponent).append((Component)Component.literal((String)prefixStr).append((Component)Component.literal((String)highlight).withStyle(ChatFormatting.GOLD)).append((Component)resetComponent).append((Component)Component.literal((String)suffixStr).withStyle(ChatFormatting.GREEN)).withStyle(ChatFormatting.GREEN));
    }

    public static boolean canBeParsed(String input) {
        Matcher matcher = pattern.matcher(input);
        return matcher.find();
    }

    public static void sendParseError(CommandSourceStack src, String duration) {
        src.sendSystemMessage((Component)TextUtils.formatMessageWithHighlight("Could not find a valid time format in string: ", duration, "."));
        src.sendSystemMessage((Component)TextUtils.formatMessage("Valid time format examples:"));
        src.sendSystemMessage((Component)TextUtils.formatMessage("1M1W1D = 1 Month + 1 Week + 1 Day"));
        src.sendSystemMessage((Component)TextUtils.formatMessage("5m = 5 minutes"));
    }

    public static String parseToISO8601(String input) {
        Matcher matcher = pattern.matcher(input);
        if (!TextUtils.canBeParsed(input)) {
            throw new IllegalArgumentException("Invalid input format: " + input);
        }
        StringBuilder duration = new StringBuilder("P");
        boolean hasTime = false;
        while (matcher.find()) {
            String unit;
            int value = Integer.parseInt(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "Y": {
                    duration.append(value).append("Y");
                    break;
                }
                case "M": {
                    duration.append(value).append("M");
                    break;
                }
                case "W": {
                    duration.append(value).append("W");
                    break;
                }
                case "D": {
                    duration.append(value).append("D");
                    break;
                }
                case "m": 
                case "s": {
                    if (!hasTime) {
                        duration.append("T");
                        hasTime = true;
                    }
                    if (unit.equals("m")) {
                        duration.append(value).append("M");
                        break;
                    }
                    duration.append(value).append("S");
                }
            }
        }
        return duration.toString();
    }
}

