/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.connected;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public class CustomBlockModels {
    private final Multimap<ResourceLocation, Function<BakedModel, ? extends BakedModel>> modelFuncs = MultimapBuilder.hashKeys().arrayListValues().build();
    private final Map<Block, Function<BakedModel, ? extends BakedModel>> finalModelFuncs = new IdentityHashMap<Block, Function<BakedModel, ? extends BakedModel>>();
    private boolean funcsLoaded = false;

    public void register(ResourceLocation block, Function<BakedModel, ? extends BakedModel> func) {
        this.modelFuncs.put((Object)block, func);
    }

    public void forEach(BiConsumer<Block, Function<BakedModel, ? extends BakedModel>> consumer) {
        this.loadEntriesIfMissing();
        this.finalModelFuncs.forEach(consumer);
    }

    private void loadEntriesIfMissing() {
        if (!this.funcsLoaded) {
            this.loadEntries();
            this.funcsLoaded = true;
        }
    }

    private void loadEntries() {
        this.finalModelFuncs.clear();
        this.modelFuncs.asMap().forEach((? super K location, ? super V funcList) -> {
            if (!BuiltInRegistries.BLOCK.containsKey(location)) {
                return;
            }
            Block block = (Block)BuiltInRegistries.BLOCK.get(location);
            Function finalFunc = null;
            for (Function func : funcList) {
                if (finalFunc == null) {
                    finalFunc = func;
                    continue;
                }
                finalFunc = finalFunc.andThen(func);
            }
            this.finalModelFuncs.put(block, finalFunc);
        });
    }
}

