/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.ITileEntity;
import net.joefoxe.hexerei.block.custom.MixingCauldron;
import net.joefoxe.hexerei.tileentity.CandleDipperTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CandleDipper
extends BaseEntityBlock
implements ITileEntity<CandleDipperTile>,
EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<CandleDipper> CODEC = CandleDipper.simpleCodec(CandleDipper::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape SHAPE = Stream.of(Block.box((double)14.0, (double)1.0, (double)4.0, (double)16.0, (double)6.0, (double)12.0), Block.box((double)13.0, (double)-1.0, (double)3.5, (double)17.0, (double)1.0, (double)6.5), Block.box((double)13.0, (double)-1.0, (double)9.5, (double)17.0, (double)1.0, (double)12.5), Block.box((double)-1.0, (double)-1.0, (double)9.5, (double)3.0, (double)1.0, (double)12.5), Block.box((double)0.0, (double)1.0, (double)4.0, (double)2.0, (double)6.0, (double)12.0), Block.box((double)-1.0, (double)-1.0, (double)3.5, (double)3.0, (double)1.0, (double)6.5), Block.box((double)2.0, (double)-1.0, (double)2.0, (double)14.0, (double)0.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_TURNED = Stream.of(Block.box((double)4.0, (double)1.0, (double)0.0, (double)12.0, (double)6.0, (double)2.0), Block.box((double)3.5, (double)-1.0, (double)-1.0, (double)6.5, (double)1.0, (double)3.0), Block.box((double)9.5, (double)-1.0, (double)-1.0, (double)12.5, (double)1.0, (double)3.0), Block.box((double)9.5, (double)-1.0, (double)13.0, (double)12.5, (double)1.0, (double)17.0), Block.box((double)4.0, (double)1.0, (double)14.0, (double)12.0, (double)6.0, (double)16.0), Block.box((double)3.5, (double)-1.0, (double)13.0, (double)6.5, (double)1.0, (double)17.0), Block.box((double)2.0, (double)-1.0, (double)2.0, (double)14.0, (double)0.0, (double)14.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public RenderShape getRenderShape(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        if (this.defaultBlockState().canSurvive((LevelReader)context.getLevel(), context.getClickedPos()) && context.getLevel().getBlockState(context.getClickedPos().below()).getBlock() instanceof MixingCauldron) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER))).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection());
        }
        return null;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    public void destroy(LevelAccessor worldIn, BlockPos pos, BlockState p_49862_) {
        super.destroy(worldIn, pos, p_49862_);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.NORTH || state.getValue((Property)HorizontalDirectionalBlock.FACING) == Direction.SOUTH ? SHAPE : SHAPE_TURNED;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandleDipperTile) {
            CandleDipperTile candleDipperTile = (CandleDipperTile)blockEntity;
            return candleDipperTile.interactWithItem(player);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandleDipperTile) {
            CandleDipperTile candleDipperTile = (CandleDipperTile)blockEntity;
            return candleDipperTile.interactWithoutItem(player);
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public CandleDipper(BlockBehaviour.Properties properties) {
        super(properties.noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING, WATERLOGGED});
    }

    public boolean placeLiquid(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluidStateIn.getType() == Fluids.WATER) {
            worldIn.setBlock(pos, (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.TRUE), 3);
            worldIn.scheduleTick(pos, fluidStateIn.getType(), fluidStateIn.getType().getTickDelay((LevelReader)worldIn));
            return true;
        }
        return false;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileentity = level.getBlockEntity(pos);
            if (tileentity != null) {
                CandleDipperTile te = (CandleDipperTile)level.getBlockEntity(pos);
                if (!((ItemStack)te.getItems().get(0)).isEmpty()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), (ItemStack)te.getItems().get(0)));
                }
                if (!((ItemStack)te.getItems().get(1)).isEmpty()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), (ItemStack)te.getItems().get(1)));
                }
                if (!((ItemStack)te.getItems().get(2)).isEmpty()) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), (ItemStack)te.getItems().get(2)));
                }
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.canSurvive((LevelReader)worldIn, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return worldIn.getBlockState(pos.below()).getBlock() instanceof MixingCauldron;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.candle_dipper_shift_1").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.candle_dipper_shift_2").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
    }

    @Override
    public Class<CandleDipperTile> getTileEntityClass() {
        return CandleDipperTile.class;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CandleDipperTile((BlockEntityType)ModTileEntities.CANDLE_DIPPER_TILE.get(), pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.CANDLE_DIPPER_TILE.get() ? (world2, pos, state2, entity) -> ((CandleDipperTile)entity).tick() : null;
    }
}

