/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.block.custom;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.block.custom.HerbDryingRack;
import net.joefoxe.hexerei.tileentity.DryingRackTile;
import net.joefoxe.hexerei.tileentity.ModTileEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallDryingRack
extends HerbDryingRack {
    public static final VoxelShape SHAPE = Stream.of(Block.box((double)2.0, (double)6.0, (double)12.0, (double)14.0, (double)7.0, (double)14.0), Block.box((double)1.0, (double)5.0, (double)14.0, (double)15.0, (double)9.0, (double)15.0), Block.box((double)0.0, (double)4.0, (double)15.0, (double)16.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_90 = Stream.of(Block.box((double)2.0, (double)6.0, (double)2.0, (double)4.0, (double)7.0, (double)14.0), Block.box((double)1.0, (double)5.0, (double)1.0, (double)2.0, (double)9.0, (double)15.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_180 = Stream.of(Block.box((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)7.0, (double)4.0), Block.box((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)9.0, (double)2.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)10.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_270 = Stream.of(Block.box((double)12.0, (double)6.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0), Block.box((double)14.0, (double)5.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0), Block.box((double)15.0, (double)4.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    public static final VoxelShape SHAPE_LEFT = Shapes.join((VoxelShape)Block.box((double)14.0, (double)6.0, (double)12.0, (double)16.0, (double)7.0, (double)14.0), (VoxelShape)Block.box((double)15.0, (double)5.0, (double)14.0, (double)16.0, (double)9.0, (double)15.0), (BooleanOp)BooleanOp.OR);
    public static final VoxelShape SHAPE_LEFT_90 = Shapes.join((VoxelShape)Block.box((double)2.0, (double)6.0, (double)14.0, (double)4.0, (double)7.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)5.0, (double)15.0, (double)2.0, (double)9.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    public static final VoxelShape SHAPE_LEFT_180 = Shapes.join((VoxelShape)Block.box((double)0.0, (double)6.0, (double)2.0, (double)2.0, (double)7.0, (double)4.0), (VoxelShape)Block.box((double)0.0, (double)5.0, (double)1.0, (double)1.0, (double)9.0, (double)2.0), (BooleanOp)BooleanOp.OR);
    public static final VoxelShape SHAPE_LEFT_270 = Shapes.join((VoxelShape)Block.box((double)12.0, (double)6.0, (double)0.0, (double)14.0, (double)7.0, (double)2.0), (VoxelShape)Block.box((double)14.0, (double)5.0, (double)0.0, (double)15.0, (double)9.0, (double)1.0), (BooleanOp)BooleanOp.OR);
    public static final VoxelShape SHAPE_RIGHT = Shapes.join((VoxelShape)Block.box((double)0.0, (double)6.0, (double)12.0, (double)2.0, (double)7.0, (double)14.0), (VoxelShape)Block.box((double)0.0, (double)5.0, (double)14.0, (double)1.0, (double)9.0, (double)15.0), (BooleanOp)BooleanOp.OR);
    public static final VoxelShape SHAPE_RIGHT_90 = Shapes.join((VoxelShape)Block.box((double)2.0, (double)6.0, (double)0.0, (double)4.0, (double)7.0, (double)2.0), (VoxelShape)Block.box((double)1.0, (double)5.0, (double)0.0, (double)2.0, (double)9.0, (double)1.0), (BooleanOp)BooleanOp.OR);
    public static final VoxelShape SHAPE_RIGHT_180 = Shapes.join((VoxelShape)Block.box((double)14.0, (double)6.0, (double)2.0, (double)16.0, (double)7.0, (double)4.0), (VoxelShape)Block.box((double)15.0, (double)5.0, (double)1.0, (double)16.0, (double)9.0, (double)2.0), (BooleanOp)BooleanOp.OR);
    public static final VoxelShape SHAPE_RIGHT_270 = Shapes.join((VoxelShape)Block.box((double)12.0, (double)6.0, (double)14.0, (double)14.0, (double)7.0, (double)16.0), (VoxelShape)Block.box((double)14.0, (double)5.0, (double)15.0, (double)15.0, (double)9.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)SHAPE, (Object)Direction.NORTH, (Object)SHAPE_180, (Object)Direction.WEST, (Object)SHAPE_90, (Object)Direction.EAST, (Object)SHAPE_270));
    private static final Map<Direction, VoxelShape> AABBS_LEFT = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)SHAPE_LEFT, (Object)Direction.NORTH, (Object)SHAPE_LEFT_180, (Object)Direction.WEST, (Object)SHAPE_LEFT_90, (Object)Direction.EAST, (Object)SHAPE_LEFT_270));
    private static final Map<Direction, VoxelShape> AABBS_RIGHT = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.SOUTH, (Object)SHAPE_RIGHT, (Object)Direction.NORTH, (Object)SHAPE_RIGHT_180, (Object)Direction.WEST, (Object)SHAPE_RIGHT_90, (Object)Direction.EAST, (Object)SHAPE_RIGHT_270));
    public static BooleanProperty WEST = BooleanProperty.create((String)"west");
    public static BooleanProperty EAST = BooleanProperty.create((String)"east");
    public static BooleanProperty NORTH = BooleanProperty.create((String)"north");
    public static BooleanProperty SOUTH = BooleanProperty.create((String)"south");
    public static BooleanProperty RIGHT = BooleanProperty.create((String)"right");
    public static BooleanProperty LEFT = BooleanProperty.create((String)"left");

    @Override
    public RenderShape getRenderShape(BlockState iBlockState) {
        return RenderShape.MODEL;
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        Level iblockreader = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        return (BlockState)((BlockState)this.updateSides((BlockGetter)iblockreader, blockpos, super.getStateForPlacement(context)).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof DryingRackTile) {
            ((DryingRackTile)tileEntity).interactDryingRack(player, hitResult);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        boolean left = (Boolean)pState.getValue((Property)LEFT);
        boolean right = (Boolean)pState.getValue((Property)RIGHT);
        if (!left && right) {
            return Stream.of(AABBS_RIGHT.get(pState.getValue((Property)HorizontalDirectionalBlock.FACING)), AABBS.get(pState.getValue((Property)HorizontalDirectionalBlock.FACING))).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        }
        if (!right && left) {
            return Stream.of(AABBS_LEFT.get(pState.getValue((Property)HorizontalDirectionalBlock.FACING)), AABBS.get(pState.getValue((Property)HorizontalDirectionalBlock.FACING))).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        }
        if (right && left) {
            return Stream.of(AABBS_LEFT.get(pState.getValue((Property)HorizontalDirectionalBlock.FACING)), AABBS_RIGHT.get(pState.getValue((Property)HorizontalDirectionalBlock.FACING)), AABBS.get(pState.getValue((Property)HorizontalDirectionalBlock.FACING))).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        }
        return AABBS.get(pState.getValue((Property)HorizontalDirectionalBlock.FACING));
    }

    public WallDryingRack(BlockBehaviour.Properties properties) {
        super(properties.noCollission());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING, WATERLOGGED, NORTH, SOUTH, EAST, WEST, LEFT, RIGHT});
    }

    @Override
    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    protected BlockState updateSides(BlockGetter world, BlockPos pos, BlockState state) {
        BlockState bs_north = world.getBlockState(pos.north());
        BlockState bs_east = world.getBlockState(pos.east());
        BlockState bs_south = world.getBlockState(pos.south());
        BlockState bs_west = world.getBlockState(pos.west());
        Direction dir = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        boolean north = bs_north.getBlock() == this && bs_north.hasProperty((Property)HorizontalDirectionalBlock.FACING) && bs_north.getValue((Property)HorizontalDirectionalBlock.FACING) == dir;
        boolean south = bs_south.getBlock() == this && bs_south.hasProperty((Property)HorizontalDirectionalBlock.FACING) && bs_south.getValue((Property)HorizontalDirectionalBlock.FACING) == dir;
        boolean east = bs_east.getBlock() == this && bs_east.hasProperty((Property)HorizontalDirectionalBlock.FACING) && bs_east.getValue((Property)HorizontalDirectionalBlock.FACING) == dir;
        boolean west = bs_west.getBlock() == this && bs_west.hasProperty((Property)HorizontalDirectionalBlock.FACING) && bs_west.getValue((Property)HorizontalDirectionalBlock.FACING) == dir;
        boolean left = dir == Direction.NORTH && west || dir == Direction.WEST && south || dir == Direction.SOUTH && east || dir == Direction.EAST && north;
        boolean right = dir == Direction.NORTH && east || dir == Direction.WEST && north || dir == Direction.SOUTH && west || dir == Direction.EAST && south;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)Boolean.valueOf(north))).setValue((Property)EAST, (Comparable)Boolean.valueOf(east))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(south))).setValue((Property)WEST, (Comparable)Boolean.valueOf(west))).setValue((Property)LEFT, (Comparable)Boolean.valueOf(left))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(right));
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)));
    }

    @Override
    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (state.hasProperty((Property)WATERLOGGED) && ((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(this.updateSides((BlockGetter)world, pos, state), facing, facingState, world, pos, facingPos);
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Override
    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.relative((Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING))).isSolid();
    }

    @Override
    public Class<DryingRackTile> getTileEntityClass() {
        return DryingRackTile.class;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DryingRackTile((BlockEntityType)ModTileEntities.DRYING_RACK_TILE.get(), pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> entityType) {
        return entityType == ModTileEntities.DRYING_RACK_TILE.get() ? (world2, pos, state2, entity) -> ((DryingRackTile)entity).tick() : null;
    }
}

