/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.custom;

import javax.annotation.Nullable;
import net.joefoxe.hexerei.client.renderer.entity.ModEntityTypes;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HexereiPaintingEntity
extends HangingEntity {
    public static final EntityDataAccessor<String> PAINTING_LOCATION = SynchedEntityData.defineId(HexereiPaintingEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Float> U0 = SynchedEntityData.defineId(HexereiPaintingEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> U1 = SynchedEntityData.defineId(HexereiPaintingEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> V0 = SynchedEntityData.defineId(HexereiPaintingEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> V1 = SynchedEntityData.defineId(HexereiPaintingEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public HexereiPaintingEntity(EntityType<? extends HexereiPaintingEntity> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(PAINTING_LOCATION, (Object)"minecraft:missingno");
        builder.define(U0, (Object)Float.valueOf(0.0f));
        builder.define(U1, (Object)Float.valueOf(1.0f));
        builder.define(V0, (Object)Float.valueOf(0.0f));
        builder.define(V1, (Object)Float.valueOf(1.0f));
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
    }

    public void setU0(float value) {
        this.entityData.set(U0, (Object)Float.valueOf(value));
    }

    public float getU0() {
        return ((Float)this.entityData.get(U0)).floatValue();
    }

    public void setU1(float value) {
        this.entityData.set(U1, (Object)Float.valueOf(value));
    }

    public float getU1() {
        return ((Float)this.entityData.get(U1)).floatValue();
    }

    public void setV0(float value) {
        this.entityData.set(V0, (Object)Float.valueOf(value));
    }

    public float getV0() {
        return ((Float)this.entityData.get(V0)).floatValue();
    }

    public void setV1(float value) {
        this.entityData.set(V1, (Object)Float.valueOf(value));
    }

    public float getV1() {
        return ((Float)this.entityData.get(V1)).floatValue();
    }

    public void setPaintingLocation(String value) {
        this.entityData.set(PAINTING_LOCATION, (Object)value);
    }

    public String getPaintingLocation() {
        return (String)this.entityData.get(PAINTING_LOCATION);
    }

    public void setDirection(Direction facingDirection) {
        super.setDirection(facingDirection);
    }

    private HexereiPaintingEntity(Level level, BlockPos pos) {
        super((EntityType)ModEntityTypes.BOOK_CANVAS.get(), level, pos);
    }

    private HexereiPaintingEntity(Level level, BlockPos pos, Direction direction) {
        this(level, pos);
        this.setDirection(direction);
    }

    public static HexereiPaintingEntity create(Level level, BlockPos pos, Direction direction) {
        return new HexereiPaintingEntity(level, pos, direction);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("painting_location", this.getPaintingLocation());
        compound.putFloat("U0", this.getU0());
        compound.putFloat("U1", this.getU1());
        compound.putFloat("V0", this.getV0());
        compound.putFloat("V1", this.getV1());
        compound.putByte("facing", (byte)this.direction.get2DDataValue());
        super.addAdditionalSaveData(compound);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.setPaintingLocation(compound.getString("painting_location"));
        this.setU0(compound.getFloat("U0"));
        this.setU1(compound.getFloat("U1"));
        this.setV0(compound.getFloat("V0"));
        this.setV1(compound.getFloat("V1"));
        this.direction = Direction.from2DDataValue((int)compound.getByte("facing"));
        super.readAdditionalSaveData(compound);
        this.setDirection(this.direction);
    }

    protected AABB calculateBoundingBox(BlockPos pos, Direction p_direction) {
        float f = 0.46875f;
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos).relative(p_direction, -0.46875);
        double d0 = this.offsetForPaintingSize(1);
        double d1 = this.offsetForPaintingSize(1);
        Direction direction = p_direction.getCounterClockWise();
        Vec3 vec31 = vec3.relative(direction, d0).relative(Direction.UP, d1);
        Direction.Axis direction$axis = p_direction.getAxis();
        double d2 = direction$axis == Direction.Axis.X ? 0.0625 : 1.0;
        double d3 = 1.0;
        double d4 = direction$axis == Direction.Axis.Z ? 0.0625 : 1.0;
        return AABB.ofSize((Vec3)vec31, (double)d2, (double)d3, (double)d4);
    }

    private double offsetForPaintingSize(int size) {
        return size % 2 == 0 ? 0.5 : 0.0;
    }

    public void dropItem(@Nullable Entity brokenEntity) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Player player;
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (brokenEntity instanceof Player && (player = (Player)brokenEntity).hasInfiniteMaterials()) {
                return;
            }
            ItemStack stack = ((Item)ModItems.BOOK_CANVAS.get()).getDefaultInstance();
            if (!ResourceLocation.parse((String)this.getPaintingLocation()).equals((Object)ResourceLocation.withDefaultNamespace((String)"missingno"))) {
                CompoundTag tag = new CompoundTag();
                tag.putString("painting_location", this.getPaintingLocation());
                tag.putFloat("U0", this.getU0());
                tag.putFloat("U1", this.getU1());
                tag.putFloat("V0", this.getV0());
                tag.putFloat("V1", this.getV1());
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            }
            this.spawnAtLocation(stack);
        }
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.PAINTING_PLACE, 1.0f, 1.0f);
    }

    public void moveTo(double x, double y, double z, float yaw, float pitch) {
        this.setPos(x, y, z);
    }

    public void lerpTo(double x, double y, double z, float yRot, float xRot, int steps) {
        this.setPos(x, y, z);
    }

    public Vec3 trackingPosition() {
        return Vec3.atLowerCornerOf((Vec3i)this.pos);
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        this.setDirection(Direction.from3DDataValue((int)packet.getData()));
    }

    public ItemStack getPickResult() {
        return new ItemStack(ModItems.BOOK_CANVAS);
    }
}

