/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.client.renderer.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.Map;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.joml.Vector3f;

public class OwlModel<T extends OwlEntity>
extends ColorableAgeableListModel<T> {
    public final ModelPart owl;
    public final ModelPart head;
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(HexereiUtil.getResource("owl"), "main");

    public OwlModel(ModelPart root) {
        this.owl = root.getChild("owl");
        this.head = this.owl.getChild("head");
    }

    public static LayerDefinition createBodyLayerNone() {
        return OwlModel.createBodyLayer(CubeDeformation.NONE);
    }

    public static LayerDefinition createBodyLayerEnlarge() {
        return OwlModel.createBodyLayer(new CubeDeformation(0.1f));
    }

    public static LayerDefinition createBodyLayer(CubeDeformation cube) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition owl = partdefinition.addOrReplaceChild("owl", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)18.2166f, (float)-0.3823f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition body = owl.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -2.0f, -2.5f, 7.0f, 4.0f, 6.0f, cube), PartPose.offset((float)0.0f, (float)-0.9668f, (float)-0.6345f));
        PartDefinition chest_r1 = body.addOrReplaceChild("chest_r1", CubeListBuilder.create().texOffs(0, 11).addBox(-3.0f, -3.25f, -1.75f, 6.0f, 7.0f, 5.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)1.75f, (float)0.0f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition tailMid = body.addOrReplaceChild("tailMid", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)4.2502f, (float)3.0167f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition tailMid_r1 = tailMid.addOrReplaceChild("tailMid_r1", CubeListBuilder.create().texOffs(13, 39).addBox(-1.0f, -1.9983f, 2.6101f, 2.0f, 0.0f, 7.0f, cube).texOffs(0, 24).addBox(-1.0f, -2.0959f, 2.5885f, 2.0f, 0.0f, 7.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)1.6f, (float)-3.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftTail = body.addOrReplaceChild("leftTail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.75f, (float)4.7502f, (float)3.5167f, (float)-0.2618f, (float)0.2618f, (float)0.0f));
        PartDefinition leftTail_r1 = leftTail.addOrReplaceChild("leftTail_r1", CubeListBuilder.create().texOffs(9, 40).addBox(-0.0531f, -1.8441f, 2.0488f, 2.0f, 0.0f, 6.0f, cube), PartPose.offsetAndRotation((float)-0.75f, (float)1.5f, (float)-2.5f, (float)-0.1688f, (float)0.008f, (float)-0.0444f));
        PartDefinition leftTail_r2 = leftTail.addOrReplaceChild("leftTail_r2", CubeListBuilder.create().texOffs(0, 32).addBox(-0.0531f, -1.8441f, 2.0488f, 2.0f, 0.0f, 6.0f, cube), PartPose.offsetAndRotation((float)-0.75f, (float)1.4f, (float)-2.5f, (float)-0.1688f, (float)0.008f, (float)-0.0444f));
        PartDefinition rightTail = body.addOrReplaceChild("rightTail", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-0.75f, (float)4.7502f, (float)3.5167f, (float)-0.2618f, (float)-0.2618f, (float)0.0f));
        PartDefinition rightTail_r1 = rightTail.addOrReplaceChild("rightTail_r1", CubeListBuilder.create().texOffs(19, 40).addBox(-1.9481f, -1.7465f, 2.0706f, 2.0f, 0.0f, 6.0f, cube).texOffs(-5, 32).addBox(-1.9469f, -1.8441f, 2.0488f, 2.0f, 0.0f, 6.0f, cube), PartPose.offsetAndRotation((float)0.75f, (float)1.4f, (float)-2.5f, (float)-0.1688f, (float)-0.008f, (float)0.0444f));
        PartDefinition leftWingBase = body.addOrReplaceChild("leftWingBase", CubeListBuilder.create().texOffs(14, 30).mirror().addBox(-0.5f, 0.0f, -1.5f, 4.0f, 0.0f, 5.0f, cube).mirror(false).texOffs(-4, 41).mirror().addBox(-0.5f, 0.1f, -1.5f, 4.0f, 0.0f, 5.0f, cube).mirror(false), PartPose.offsetAndRotation((float)3.5f, (float)-0.7498f, (float)-0.4833f, (float)0.0f, (float)0.0f, (float)1.4835f));
        PartDefinition leftWing_r1 = leftWingBase.addOrReplaceChild("leftWing_r1", CubeListBuilder.create().texOffs(46, 33).mirror().addBox(-2.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f, cube).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)-0.1f, (float)-1.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftWingCloseMiddle = leftWingBase.addOrReplaceChild("leftWingCloseMiddle", CubeListBuilder.create().texOffs(21, 5).mirror().addBox(-0.25f, 0.0f, 0.5f, 4.0f, 0.0f, 6.0f, cube).mirror(false).texOffs(-5, 47).mirror().addBox(-0.25f, 0.1f, 0.5f, 4.0f, 0.0f, 6.0f, cube).mirror(false), PartPose.offsetAndRotation((float)3.5f, (float)0.0f, (float)-2.0f, (float)-0.0873f, (float)-0.5236f, (float)0.1745f));
        PartDefinition leftWing_r2 = leftWingCloseMiddle.addOrReplaceChild("leftWing_r2", CubeListBuilder.create().texOffs(54, 9).mirror().addBox(-2.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f, cube).mirror(false), PartPose.offsetAndRotation((float)1.75f, (float)-0.1f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftWingFarMiddle = leftWingCloseMiddle.addOrReplaceChild("leftWingFarMiddle", CubeListBuilder.create().texOffs(20, 0).mirror().addBox(-0.25f, 0.0f, 0.5f, 4.0f, 0.0f, 5.0f, cube).mirror(false).texOffs(-4, 55).mirror().addBox(-0.25f, 0.1f, 0.5f, 4.0f, 0.0f, 5.0f, cube).mirror(false), PartPose.offsetAndRotation((float)3.75f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)-1.0472f, (float)0.1745f));
        PartDefinition leftWing_r3 = leftWingFarMiddle.addOrReplaceChild("leftWing_r3", CubeListBuilder.create().texOffs(53, 3).mirror().addBox(-1.5f, 0.0f, -0.5f, 3.0f, 0.0f, 1.0f, cube).mirror(false), PartPose.offsetAndRotation((float)1.25f, (float)-0.1f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition leftWingTip = leftWingFarMiddle.addOrReplaceChild("leftWingTip", CubeListBuilder.create(), PartPose.offsetAndRotation((float)3.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.6109f));
        PartDefinition rightWingBase = body.addOrReplaceChild("rightWingBase", CubeListBuilder.create().texOffs(14, 30).addBox(-3.5f, 0.0f, -1.5f, 4.0f, 0.0f, 5.0f, cube).texOffs(-4, 41).addBox(-3.5f, 0.1f, -1.5f, 4.0f, 0.0f, 5.0f, cube), PartPose.offsetAndRotation((float)-3.5f, (float)-0.7498f, (float)-0.4833f, (float)0.0f, (float)0.0f, (float)-1.4835f));
        PartDefinition rightWing_r1 = rightWingBase.addOrReplaceChild("rightWing_r1", CubeListBuilder.create().texOffs(46, 33).addBox(-2.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-1.5f, (float)-0.1f, (float)-1.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightWingCloseMiddle = rightWingBase.addOrReplaceChild("rightWingCloseMiddle", CubeListBuilder.create().texOffs(21, 5).addBox(-3.75f, 0.0f, 0.5f, 4.0f, 0.0f, 6.0f, cube).texOffs(-5, 47).addBox(-3.75f, 0.1f, 0.5f, 4.0f, 0.0f, 6.0f, cube), PartPose.offsetAndRotation((float)-3.5f, (float)0.0f, (float)-2.0f, (float)-0.0873f, (float)0.5236f, (float)-0.1745f));
        PartDefinition rightWing_r2 = rightWingCloseMiddle.addOrReplaceChild("rightWing_r2", CubeListBuilder.create().texOffs(54, 9).addBox(-2.0f, 0.0f, -0.5f, 4.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-1.75f, (float)-0.1f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightWingFarMiddle = rightWingCloseMiddle.addOrReplaceChild("rightWingFarMiddle", CubeListBuilder.create().texOffs(20, 0).addBox(-3.75f, 0.0f, 0.5f, 4.0f, 0.0f, 5.0f, cube).texOffs(-4, 55).addBox(-3.75f, 0.1f, 0.5f, 4.0f, 0.0f, 5.0f, cube), PartPose.offsetAndRotation((float)-3.75f, (float)0.0f, (float)0.0f, (float)-0.1745f, (float)1.0472f, (float)-0.1745f));
        PartDefinition rightWing_r3 = rightWingFarMiddle.addOrReplaceChild("rightWing_r3", CubeListBuilder.create().texOffs(53, 3).addBox(-1.5f, 0.0f, -0.5f, 3.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-1.25f, (float)-0.2f, (float)0.5f, (float)0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition rightWingTip = rightWingFarMiddle.addOrReplaceChild("rightWingTip", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-3.75f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.6109f));
        PartDefinition rightLeg = owl.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(0, 11).addBox(-1.0f, 0.0f, 0.25f, 1.0f, 2.0f, 1.0f, cube).texOffs(12, 29).addBox(-1.5f, 2.0f, -0.75f, 2.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-1.0f, (float)3.567f, (float)-1.094f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = owl.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(12, 24).addBox(0.0f, 0.0f, 0.25f, 1.0f, 2.0f, 1.0f, cube).texOffs(37, 15).addBox(-0.5f, 2.0f, -0.75f, 2.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)1.0f, (float)3.567f, (float)-1.094f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition head = owl.addOrReplaceChild("head", CubeListBuilder.create().texOffs(18, 19).addBox(-3.0f, -3.5126f, -2.7186f, 6.0f, 5.0f, 5.0f, cube).texOffs(10, 50).addBox(-3.0f, -3.5126f, -2.7186f, 6.0f, 5.0f, 5.0f, new CubeDeformation(0.2f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.9001f, (float)0.3282f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition beak = head.addOrReplaceChild("beak", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.6835f, (float)-2.9962f));
        PartDefinition beak_r1 = beak.addOrReplaceChild("beak_r1", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.75f, 1.0f, 2.0f, 1.0f, cube), PartPose.offsetAndRotation((float)0.0f, (float)-0.6961f, (float)0.0276f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition rightBrow = head.addOrReplaceChild("rightBrow", CubeListBuilder.create(), PartPose.offset((float)-0.85f, (float)-3.2626f, (float)-2.8186f));
        PartDefinition rightBrow_r1 = rightBrow.addOrReplaceChild("rightBrow_r1", CubeListBuilder.create().texOffs(0, 27).addBox(-1.2462f, -1.4566f, 0.0f, 3.0f, 2.0f, 0.0f, cube), PartPose.offsetAndRotation((float)-1.15f, (float)1.0f, (float)-0.15f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition rightBrow_r2 = rightBrow.addOrReplaceChild("rightBrow_r2", CubeListBuilder.create().texOffs(11, 32).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0451f, (float)0.0834f, (float)0.1725f));
        PartDefinition rightBrow_r3 = rightBrow.addOrReplaceChild("rightBrow_r3", CubeListBuilder.create().texOffs(36, 20).addBox(-1.6f, -0.5f, -0.6f, 3.0f, 1.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-2.2437f, (float)-0.5276f, (float)1.2532f, (float)0.3589f, (float)1.0414f, (float)0.6033f));
        PartDefinition rightBrow_r4 = rightBrow.addOrReplaceChild("rightBrow_r4", CubeListBuilder.create().texOffs(11, 36).addBox(-2.1f, 0.0f, 0.4f, 4.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)-2.2437f, (float)-0.7776f, (float)1.2532f, (float)0.3589f, (float)1.0414f, (float)0.6033f));
        PartDefinition leftBrow = head.addOrReplaceChild("leftBrow", CubeListBuilder.create(), PartPose.offset((float)0.85f, (float)-3.2626f, (float)-2.8186f));
        PartDefinition leftBrow_r1 = leftBrow.addOrReplaceChild("leftBrow_r1", CubeListBuilder.create().texOffs(0, 24).addBox(-1.7538f, -1.4566f, 0.0f, 3.0f, 2.0f, 0.0f, cube), PartPose.offsetAndRotation((float)1.15f, (float)1.0f, (float)-0.15f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftBrow_r2 = leftBrow.addOrReplaceChild("leftBrow_r2", CubeListBuilder.create().texOffs(21, 37).addBox(-1.0f, -0.5f, -0.5f, 2.0f, 1.0f, 1.0f, cube), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0451f, (float)-0.0834f, (float)-0.1725f));
        PartDefinition leftBrow_r3 = leftBrow.addOrReplaceChild("leftBrow_r3", CubeListBuilder.create().texOffs(37, 12).addBox(-1.4f, -0.5f, -0.6f, 3.0f, 1.0f, 1.0f, cube), PartPose.offsetAndRotation((float)2.2437f, (float)-0.5276f, (float)1.2532f, (float)0.3589f, (float)-1.0414f, (float)-0.6033f));
        PartDefinition leftBrow_r4 = leftBrow.addOrReplaceChild("leftBrow_r4", CubeListBuilder.create().texOffs(36, 18).addBox(-1.9f, 0.0f, 0.4f, 4.0f, 0.0f, 1.0f, cube), PartPose.offsetAndRotation((float)2.2437f, (float)-0.7776f, (float)1.2532f, (float)0.3589f, (float)-1.0414f, (float)-0.6033f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(OwlEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupInitialAnimationValues(entity, netHeadYaw, headPitch);
        ModelPart body = this.owl.getChild("body");
        ModelPart leftWingBase = body.getChild("leftWingBase");
        ModelPart leftWingCloseMiddle = leftWingBase.getChild("leftWingCloseMiddle");
        ModelPart leftWingFarMiddle = leftWingCloseMiddle.getChild("leftWingFarMiddle");
        ModelPart rightWingBase = body.getChild("rightWingBase");
        ModelPart rightWingCloseMiddle = rightWingBase.getChild("rightWingCloseMiddle");
        ModelPart rightWingFarMiddle = rightWingCloseMiddle.getChild("rightWingFarMiddle");
        ModelPart rightLeg = this.owl.getChild("rightLeg");
        ModelPart leftLeg = this.owl.getChild("leftLeg");
        ModelPart head = this.owl.getChild("head");
        ModelPart rightTail = body.getChild("rightTail");
        ModelPart leftTail = body.getChild("leftTail");
        ModelPart tailMid = body.getChild("tailMid");
        ModelPart beak = head.getChild("beak");
        ModelPart rightBrow = head.getChild("rightBrow");
        ModelPart leftBrow = head.getChild("leftBrow");
        if (!entity.onGround() || !entity.isInSittingPose()) {
            this.owl.y = 18.5f;
        }
        float ticks = (float)entity.tickCount + (float)entity.getId() * 235.0f + ClientEvents.getPartial();
        float partial = ClientEvents.getPartial();
        rightWingBase.zRot = Mth.lerp((float)partial, (float)entity.rightWingAngleLast, (float)entity.rightWingAngle);
        leftWingBase.zRot = Mth.lerp((float)partial, (float)entity.leftWingAngleLast, (float)entity.leftWingAngle);
        rightWingCloseMiddle.zRot = Mth.lerp((float)partial, (float)entity.rightWingMiddleAngleLast, (float)entity.rightWingMiddleAngle);
        leftWingCloseMiddle.zRot = Mth.lerp((float)partial, (float)entity.leftWingMiddleAngleLast, (float)entity.leftWingMiddleAngle);
        rightWingBase.xRot = 0.0f;
        leftWingBase.xRot = 0.0f;
        rightWingBase.yRot = entity.rightWingFoldAngle;
        leftWingBase.yRot = entity.leftWingFoldAngle;
        rightWingCloseMiddle.yRot = entity.rightWingMiddleFoldAngle;
        leftWingCloseMiddle.yRot = entity.leftWingMiddleFoldAngle;
        rightWingFarMiddle.yRot = entity.rightWingTipAngle;
        leftWingFarMiddle.yRot = entity.leftWingTipAngle;
        this.owl.xRot = Mth.sin((float)(entity.peckAnimation.getPeckRot() / 100.0f));
        this.owl.zRot = 0.0f;
        this.owl.yRot = 0.0f;
        body.yRot = 0.0f;
        head.yRot = 0.0f;
        head.zRot = 0.0f;
        leftBrow.zRot = 0.0f;
        rightBrow.zRot = 0.0f;
        leftBrow.yRot = 0.0f;
        rightBrow.yRot = 0.0f;
        leftBrow.z = -2.81f;
        rightBrow.z = -2.81f;
        leftBrow.y = -3.26f;
        rightBrow.y = -3.26f;
        leftBrow.x = 0.85f;
        rightBrow.x = -0.85f;
        if (entity.browAnimation.getBrowAnim() == OwlEntity.BrowAnim.BOTH) {
            leftBrow.zRot += Mth.sin((float)(entity.browAnimation.getBrowRot() / 100.0f)) * 0.2f;
            rightBrow.zRot -= Mth.sin((float)(entity.browAnimation.getBrowRot() / 100.0f)) * 0.2f;
            leftBrow.y += Mth.sin((float)(entity.browAnimation.getBrowRot() / 50.0f)) * 0.3f;
            rightBrow.y += Mth.sin((float)(entity.browAnimation.getBrowRot() / 50.0f)) * 0.3f;
        }
        if (entity.browAnimation.getBrowAnim() == OwlEntity.BrowAnim.RIGHT) {
            rightBrow.zRot -= Mth.sin((float)(entity.browAnimation.getBrowRot() / 100.0f)) * 0.2f;
            rightBrow.y += Mth.sin((float)(entity.browAnimation.getBrowRot() / 50.0f)) * 0.3f;
        }
        if (entity.browAnimation.getBrowAnim() == OwlEntity.BrowAnim.LEFT) {
            leftBrow.zRot += Mth.sin((float)(entity.browAnimation.getBrowRot() / 100.0f)) * 0.2f;
            leftBrow.y += Mth.sin((float)(entity.browAnimation.getBrowRot() / 50.0f)) * 0.3f;
        }
        if (entity.emotionState != null) {
            leftBrow.zRot = (float)((double)leftBrow.zRot + Math.toRadians(entity.emotionState.getzRot()));
            rightBrow.zRot = (float)((double)rightBrow.zRot - Math.toRadians(entity.emotionState.getzRot()));
            leftBrow.y += entity.emotionState.getyOffset();
            rightBrow.y += entity.emotionState.getyOffset();
            leftBrow.x += entity.emotionState.getxOffset();
            rightBrow.x -= entity.emotionState.getxOffset();
        }
        rightLeg.z = 0.0f;
        leftLeg.z = 0.0f;
        if (entity.onGround() || !entity.isFlying()) {
            rightTail.xRot = Mth.sin((float)(ticks / 15.0f)) * 0.1f;
            leftTail.xRot = Mth.sin((float)(ticks / 15.0f)) * 0.1f;
            tailMid.xRot = Mth.sin((float)(ticks / 15.0f)) * 0.1f;
            if (entity.isInSittingPose()) {
                rightLeg.xRot = -0.7853982f;
                leftLeg.xRot = -0.7853982f;
                rightLeg.y = 2.25f;
                rightLeg.z = -2.0f;
                leftLeg.y = 2.25f;
                leftLeg.z = -2.0f;
                this.owl.y = 20.0f;
                rightTail.xRot += 0.3926991f;
                leftTail.xRot += 0.3926991f;
                tailMid.xRot += 0.3926991f;
            } else {
                rightLeg.y = 3.5f;
                leftLeg.y = 3.5f;
                rightLeg.xRot = Mth.cos((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
                leftLeg.xRot = Mth.cos((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
                if (entity.onGround()) {
                    this.owl.zRot = Mth.cos((float)(limbSwing * 2.0f)) * 0.1f * (float)Math.max(0.08, (double)limbSwingAmount);
                    this.owl.xRot += Mth.cos((float)(limbSwing * 4.0f)) * 0.1f * (float)Math.max(0.08, (double)limbSwingAmount);
                }
            }
            head.xRot = (float)Math.toRadians(headPitch);
            head.xRot += Mth.sin((float)(ticks / 15.0f)) * 0.1f;
            leftBrow.zRot += -Mth.sin((float)(ticks / 15.0f)) * 0.05f;
            rightBrow.zRot -= -Mth.sin((float)(ticks / 15.0f)) * 0.05f;
            leftBrow.y += -Mth.sin((float)(ticks / 15.0f)) * 0.15f;
            rightBrow.y += -Mth.sin((float)(ticks / 15.0f)) * 0.15f;
            rightTail.yRot = -Mth.sin((float)0.05f);
            leftTail.yRot = Mth.sin((float)0.05f);
            rightTail.yRot += Mth.sin((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            leftTail.yRot += Mth.sin((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            tailMid.yRot = Mth.sin((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            if (entity.tailWagAnimation.isActive()) {
                rightTail.yRot += Mth.sin((float)0.15f) * 0.5f;
                leftTail.yRot -= Mth.sin((float)0.15f) * 0.5f;
            }
            rightTail.yRot -= Mth.sin((float)(entity.tailFanAnimation.getFanRot() / 100.0f)) * 0.5f;
            leftTail.yRot += Mth.sin((float)(entity.tailFanAnimation.getFanRot() / 100.0f)) * 0.5f;
        } else if (entity.isPassenger()) {
            rightLeg.xRot = -0.5235988f;
            leftLeg.xRot = -0.5235988f;
            rightLeg.y = 2.5f;
            rightLeg.z = 1.5f;
            leftLeg.y = 2.5f;
            leftLeg.z = 1.5f;
            this.owl.y = 20.0f;
            head.xRot = (float)Math.toRadians(headPitch);
            head.xRot += Mth.sin((float)(ticks / 15.0f)) * 0.1f;
            leftBrow.zRot += -Mth.sin((float)(ticks / 15.0f)) * 0.05f;
            rightBrow.zRot -= -Mth.sin((float)(ticks / 15.0f)) * 0.05f;
            leftBrow.y += -Mth.sin((float)(ticks / 15.0f)) * 0.15f;
            rightBrow.y += -Mth.sin((float)(ticks / 15.0f)) * 0.15f;
            rightTail.xRot = Mth.sin((float)(ticks / 15.0f)) * 0.1f;
            leftTail.xRot = Mth.sin((float)(ticks / 15.0f)) * 0.1f;
            tailMid.xRot = Mth.sin((float)(ticks / 15.0f)) * 0.1f;
            rightTail.yRot = -Mth.sin((float)0.05f);
            leftTail.yRot = Mth.sin((float)0.05f);
            rightTail.yRot += Mth.sin((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            leftTail.yRot += Mth.sin((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            tailMid.yRot = Mth.sin((float)(entity.tailWagAnimation.getWagRot() / 100.0f)) * 0.2f;
            if (entity.tailWagAnimation.isActive()) {
                rightTail.yRot += Mth.sin((float)0.15f) * 0.5f;
                leftTail.yRot -= Mth.sin((float)0.15f) * 0.5f;
            }
            rightTail.yRot -= Mth.sin((float)(entity.tailFanAnimation.getFanRot() / 100.0f)) * 0.5f;
            leftTail.yRot += Mth.sin((float)(entity.tailFanAnimation.getFanRot() / 100.0f)) * 0.5f;
        } else {
            rightLeg.xRot = Mth.sin((float)20.0f);
            leftLeg.xRot = Mth.sin((float)20.0f);
            head.xRot = (float)Math.toRadians(headPitch);
            rightTail.yRot = -Mth.sin((float)0.15f);
            leftTail.yRot = Mth.sin((float)0.15f);
            this.owl.y = 18.5f + Mth.lerp((float)partial, (float)entity.bodyYOffsetLast, (float)entity.bodyYOffset);
            this.owl.xRot += (float)((double)Mth.lerp((float)partial, (float)entity.bodyXRotLast, (float)entity.bodyXRot) + Math.toRadians(Mth.lerp((float)partial, (float)entity.itemHeldSwingLast, (float)entity.itemHeldSwing) / 4.0f));
            head.xRot -= this.owl.xRot / 1.5f;
            head.zRot -= (float)(Math.toRadians(netHeadYaw) / 2.0);
            leftLeg.z = -1.0f;
            rightLeg.z = -1.0f;
            leftLeg.y = 4.5f;
            rightLeg.y = 4.5f;
            rightWingBase.xRot = -this.owl.xRot / 1.15f;
            leftWingBase.xRot = -this.owl.xRot / 1.15f;
            tailMid.xRot = -this.owl.xRot / 1.15f;
            leftTail.xRot = -this.owl.xRot / 1.15f;
            rightTail.xRot = -this.owl.xRot / 1.15f;
            rightWingBase.yRot += Mth.lerp((float)partial, (float)entity.rightWingAngleLast, (float)entity.rightWingAngle) / 2.0f;
            leftWingBase.yRot += Mth.lerp((float)partial, (float)entity.leftWingAngleLast, (float)entity.leftWingAngle) / 2.0f;
        }
        if (entity.emotions.isHappy()) {
            leftBrow.yRot = (float)((double)leftBrow.yRot - Math.toRadians(10.0));
            rightBrow.yRot = (float)((double)rightBrow.yRot + Math.toRadians(10.0));
            if (entity.browHappyAnimation.getBrowAnim() == OwlEntity.BrowAnim.BOTH) {
                leftBrow.yRot += Mth.sin((float)(entity.browHappyAnimation.getBrowRot() / 100.0f)) * 0.2f;
                rightBrow.yRot -= Mth.sin((float)(entity.browHappyAnimation.getBrowRot() / 100.0f)) * 0.2f;
            }
            if (entity.browHappyAnimation.getBrowAnim() == OwlEntity.BrowAnim.RIGHT) {
                rightBrow.yRot -= Mth.sin((float)(entity.browHappyAnimation.getBrowRot() / 100.0f)) * 0.2f;
                body.yRot += Mth.sin((float)(Mth.lerp((float)partial, (float)entity.browHappyAnimation.getBrowRotLast(), (float)entity.browHappyAnimation.getBrowRot()) / 90.0f)) * 0.2f;
            }
            if (entity.browHappyAnimation.getBrowAnim() == OwlEntity.BrowAnim.LEFT) {
                leftBrow.yRot += Mth.sin((float)(entity.browHappyAnimation.getBrowRot() / 100.0f)) * 0.2f;
                body.yRot += Mth.sin((float)(Mth.lerp((float)partial, (float)entity.browHappyAnimation.getBrowRotLast(), (float)entity.browHappyAnimation.getBrowRot()) / 90.0f)) * 0.2f;
            }
            if (entity.isInSittingPose() || entity.isFlying()) {
                rightLeg.xRot += Mth.sin((float)(entity.browHappyAnimation.getBrowRot() / 100.0f));
                leftLeg.xRot -= Mth.sin((float)(entity.browHappyAnimation.getBrowRot() / 100.0f));
            }
            leftBrow.y = (float)((double)leftBrow.y - 0.25);
            rightBrow.y = (float)((double)rightBrow.y - 0.25);
            leftBrow.z = (float)((double)leftBrow.z - 0.25);
            rightBrow.z = (float)((double)rightBrow.z - 0.25);
        }
        head.yRot += (float)Math.toRadians(netHeadYaw);
        head.zRot += Mth.sin((float)(entity.headTiltAnimation.getzTilt() / 100.0f)) / 2.0f;
        head.xRot += Mth.sin((float)(entity.headTiltAnimation.getxTilt() / 100.0f)) / 2.0f;
        if ((entity.onGround() || entity.isPassenger()) && entity.dance) {
            head.zRot = 0.0f;
            head.xRot = (float)Math.toRadians(headPitch) + Mth.sin((float)((float)entity.animationCounter / 1.5f)) / 12.0f;
            head.yRot = (float)Math.toRadians(netHeadYaw) + Mth.sin((float)((float)entity.animationCounter / 3.0f)) / 4.0f;
            rightTail.xRot = Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            leftTail.xRot = Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            tailMid.xRot = Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.1f;
            this.owl.yRot += Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.2f;
            rightTail.yRot = Mth.sin((float)0.1f);
            leftTail.yRot = -Mth.sin((float)0.1f);
            this.owl.y = 18.5f + Mth.abs((float)Mth.sin((float)((float)entity.animationCounter / 6.0f)));
            rightTail.yRot += Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            leftTail.yRot += Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            tailMid.yRot = Mth.sin((float)((float)entity.animationCounter / 3.0f)) * 0.4f;
            rightLeg.y = 3.5f - Mth.abs((float)Mth.sin((float)((float)entity.animationCounter / 6.0f)));
            rightLeg.z = 0.5f;
            leftLeg.y = 3.5f - Mth.abs((float)Mth.sin((float)((float)entity.animationCounter / 6.0f)));
            leftLeg.z = 0.5f;
            rightLeg.xRot = Mth.cos((float)(limbSwing * 2.0f + (float)Math.PI)) * 2.0f * limbSwingAmount;
            leftLeg.xRot = Mth.cos((float)(limbSwing * 2.0f)) * 2.0f * limbSwingAmount;
        }
        beak.xRot = Mth.sin((float)(-entity.hootAnimation.getHootRot() / 100.0f));
        if (entity.peckAnimation.getPeckRot() > 0.0f) {
            beak.xRot = Mth.sin((float)(-entity.peckAnimation.getPeckRot() / 100.0f));
        }
        head.visible = true;
        head.yRot += Mth.sin((float)(Mth.lerp((float)partial, (float)entity.headShakeAnimation.getzTiltLast(), (float)entity.headShakeAnimation.getzTilt()) / 100.0f)) * 1.5f;
        this.saveAnimationValues(entity);
    }

    private Vector3f getRotationVector(ModelPart pModelPart) {
        return new Vector3f(pModelPart.xRot, pModelPart.yRot, pModelPart.zRot);
    }

    private void setRotationFromVector(ModelPart pModelPart, Vector3f pRotationVector) {
        pModelPart.setRotation(pRotationVector.x(), pRotationVector.y(), pRotationVector.z());
    }

    private void saveAnimationValues(OwlEntity crow) {
        Map<String, Vector3f> map = crow.getModelRotationValues();
        map.put("owl", this.getRotationVector(this.owl));
    }

    private void setupInitialAnimationValues(OwlEntity crow, float pNetHeadYaw, float pHeadPitch) {
        this.owl.x = 0.0f;
        this.owl.y = 19.0f;
        Map<String, Vector3f> map = crow.getModelRotationValues();
        if (map.isEmpty()) {
            this.owl.setRotation(pHeadPitch * ((float)Math.PI / 180), pNetHeadYaw * ((float)Math.PI / 180), 0.0f);
        } else {
            this.setRotationFromVector(this.owl, map.get("owl"));
        }
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.owl.render(poseStack, buffer, packedLight, packedOverlay, color);
    }

    protected Iterable<ModelPart> headParts() {
        return Collections.singleton(this.head);
    }

    protected Iterable<ModelPart> bodyParts() {
        return Collections.singleton(this.owl);
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.xRot = x;
        modelRenderer.yRot = y;
        modelRenderer.zRot = z;
    }
}

