/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.container;

import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.container.ModContainers;
import net.joefoxe.hexerei.tileentity.MixingCauldronTile;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class MixingCauldronContainer
extends AbstractContainerMenu {
    public final BlockEntity tileEntity;
    private final Player playerEntity;
    private final IItemHandler playerInventory;
    private FluidStack fluid;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 10;

    public MixingCauldronContainer(int windowId, Level world, BlockPos pos, Inventory playerInventory, Player player) {
        super((MenuType)ModContainers.MIXING_CAULDRON_CONTAINER.get(), windowId);
        this.tileEntity = world.getBlockEntity(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((Container)playerInventory);
        this.layoutPlayerInventorySlots(14, 120);
        BlockEntity blockEntity = this.tileEntity;
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile cauldron = (MixingCauldronTile)blockEntity;
            InvWrapper handler = new InvWrapper((Container)cauldron);
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 9, 42, 24));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 0, 105, 17));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 1, 127, 26));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 2, 136, 48));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 3, 127, 70));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 4, 105, 79));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 5, 83, 70));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 6, 74, 48));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 7, 83, 26));
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 8, 178, 48));
        }
        if ((blockEntity = this.tileEntity) instanceof MixingCauldronTile) {
            MixingCauldronTile mixingTile = (MixingCauldronTile)blockEntity;
            this.fluid = mixingTile.getFluidStack();
        }
        this.addDataSlot(new DataSlot(){

            public void set(int value) {
                ((MixingCauldronTile)MixingCauldronContainer.this.tileEntity).setCraftDelay(value);
            }

            public int get() {
                return ((MixingCauldronTile)MixingCauldronContainer.this.tileEntity).getCraftDelay();
            }
        });
    }

    public void setFluid(FluidStack fluidStack) {
        this.fluid = fluidStack;
    }

    public FluidStack getFluid() {
        BlockEntity blockEntity = this.tileEntity;
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile mixingTile = (MixingCauldronTile)blockEntity;
            return mixingTile.getFluidStack();
        }
        return this.fluid;
    }

    public FluidStack getRenderedFluid() {
        BlockEntity blockEntity = this.tileEntity;
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile mixingTile = (MixingCauldronTile)blockEntity;
            return mixingTile.renderedFluid;
        }
        return this.fluid;
    }

    public float getCraftPercent() {
        MixingCauldronTile cauldronTile;
        BlockEntity blockEntity = this.tileEntity;
        if (blockEntity instanceof MixingCauldronTile && !(cauldronTile = (MixingCauldronTile)blockEntity).getCrafted()) {
            return (float)cauldronTile.craftDelay / 100.0f;
        }
        return 0.0f;
    }

    public float getCraftPercentHalf() {
        BlockEntity blockEntity = this.tileEntity;
        if (blockEntity instanceof MixingCauldronTile) {
            MixingCauldronTile cauldronTile = (MixingCauldronTile)blockEntity;
            float delayHalf = (float)cauldronTile.craftDelay - 50.0f;
            if (!cauldronTile.getCrafted()) {
                return delayHalf / 100.0f;
            }
        }
        return 0.0f;
    }

    public boolean stillValid(Player playerIn) {
        return MixingCauldronContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.tileEntity.getLevel(), (BlockPos)this.tileEntity.getBlockPos()), (Player)playerIn, (Block)((Block)ModBlocks.MIXING_CAULDRON.get()));
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.slots.get(index);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 46, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 46) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(this.playerEntity, sourceStack);
        return copyOfSourceStack;
    }
}

