/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookHyperlink;
import net.joefoxe.hexerei.data.books.BookPage;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.BookEntriesPacket;
import net.joefoxe.hexerei.util.message.BookPagesPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class BookManager {
    private static final Map<ResourceLocation, Map<ResourceLocation, BookPage>> BOOK_PAGES = new LinkedHashMap<ResourceLocation, Map<ResourceLocation, BookPage>>();
    private static final Map<String, BookHyperlink> BOOK_ITEM_HYPERLINKS = new LinkedHashMap<String, BookHyperlink>();
    private static final Map<ResourceLocation, BookEntries> BOOK_ENTRIES = new HashMap<ResourceLocation, BookEntries>();

    public static List<ResourceLocation> getBookLocations() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        BOOK_ENTRIES.forEach((resourceLocation, bookEntries) -> list.add((ResourceLocation)resourceLocation));
        return list;
    }

    public static void clearBookPages(ResourceLocation locationToClear) {
        if (BOOK_PAGES.containsKey(locationToClear)) {
            BOOK_PAGES.get(locationToClear).clear();
        }
    }

    public static void clearBookEntries(ResourceLocation locationToClear) {
        BOOK_ENTRIES.remove(locationToClear);
    }

    public static void addBookPage(ResourceLocation bookLoc, ResourceLocation loc, BookPage bookPage) {
        if (!BOOK_PAGES.containsKey(bookLoc)) {
            BOOK_PAGES.put(bookLoc, new HashMap());
            BOOK_PAGES.get(bookLoc).put(loc, bookPage);
        } else {
            BOOK_PAGES.get(bookLoc).put(loc, bookPage);
        }
    }

    public static void addBookItemHyperlink(String loc, BookHyperlink hyperlink) {
        BOOK_ITEM_HYPERLINKS.put(loc, hyperlink);
    }

    public static void addBookEntries(BookEntries bookEntry) {
        BOOK_ENTRIES.put(bookEntry.book, bookEntry);
    }

    public static void sendBookPagesToClient(List<ResourceLocation> books) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            HashMap<ResourceLocation, Map<ResourceLocation, BookPage>> booksToSend = new HashMap<ResourceLocation, Map<ResourceLocation, BookPage>>();
            for (ResourceLocation book : books) {
                if (!BOOK_PAGES.containsKey(book)) continue;
                booksToSend.put(book, BOOK_PAGES.get(book));
            }
            HexereiPacketHandler.sendToAllPlayers(new BookPagesPacket(booksToSend), ServerLifecycleHooks.getCurrentServer());
        }
    }

    public static void sendBookEntriesToClient(List<ResourceLocation> books) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            HashMap<ResourceLocation, BookEntries> booksToSend = new HashMap<ResourceLocation, BookEntries>();
            for (ResourceLocation book : books) {
                if (!BOOK_ENTRIES.containsKey(book)) continue;
                booksToSend.put(book, BOOK_ENTRIES.get(book));
            }
            HexereiPacketHandler.sendToAllPlayers(new BookEntriesPacket(booksToSend), ServerLifecycleHooks.getCurrentServer());
        }
    }

    public static void sendBookPagesToClient(ServerPlayer player) {
        HexereiPacketHandler.sendToPlayerClient(new BookPagesPacket(BOOK_PAGES), player);
    }

    public static void sendBookEntriesToClient(ServerPlayer player) {
        HexereiPacketHandler.sendToPlayerClient(new BookEntriesPacket(BOOK_ENTRIES), player);
    }

    public static BookPage getBookPages(ResourceLocation bookLoc, ResourceLocation loc) {
        if (BOOK_PAGES.containsKey(bookLoc) && BOOK_PAGES.get(bookLoc).containsKey(loc)) {
            return BOOK_PAGES.get(bookLoc).get(loc);
        }
        return null;
    }

    public static BookEntries getBookEntries(ResourceLocation bookLoc) {
        if (BOOK_ENTRIES.containsKey(bookLoc)) {
            return BOOK_ENTRIES.get(bookLoc);
        }
        return null;
    }

    public static Map<String, BookHyperlink> getBookItemHyperlinks() {
        return BOOK_ITEM_HYPERLINKS;
    }
}

