/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.data.books.BookBlocks;
import net.joefoxe.hexerei.data.books.BookEntity;
import net.joefoxe.hexerei.data.books.BookImage;
import net.joefoxe.hexerei.data.books.BookItemsAndFluids;
import net.joefoxe.hexerei.data.books.BookNonItemTooltip;
import net.joefoxe.hexerei.data.books.BookPaintElement;
import net.joefoxe.hexerei.data.books.BookParagraph;
import net.joefoxe.hexerei.data.books.BookWritableTextBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BookPage {
    public ResourceLocation location = null;
    public String name;
    public String itemHyperlink;
    public ArrayList<BookParagraph> paragraph;
    public ArrayList<BookItemsAndFluids> itemList;
    public ArrayList<BookBlocks> blockList;
    public ArrayList<BookEntity> entityList;
    public ArrayList<BookImage> imageList;
    public ArrayList<BookNonItemTooltip> nonItemTooltipList;
    public ArrayList<BookWritableTextBox> writableTextBoxes;
    public ArrayList<BookPaintElement> paintElements;
    public static final Codec<BookPage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(e -> e.name), (App)Codec.STRING.fieldOf("itemHyperlink").forGetter(e -> e.itemHyperlink), (App)BookParagraph.CODEC.listOf().fieldOf("paragraph").forGetter(e -> e.paragraph), (App)BookItemsAndFluids.CODEC.listOf().fieldOf("itemList").forGetter(e -> e.itemList), (App)BookBlocks.CODEC.listOf().fieldOf("blockList").forGetter(e -> e.blockList), (App)BookEntity.CODEC.listOf().fieldOf("entityList").forGetter(e -> e.entityList), (App)BookImage.CODEC.listOf().fieldOf("imageList").forGetter(e -> e.imageList), (App)BookNonItemTooltip.CODEC.listOf().fieldOf("nonItemTooltipList").forGetter(e -> e.nonItemTooltipList), (App)BookWritableTextBox.CODEC.listOf().fieldOf("writableTextBoxes").forGetter(e -> e.writableTextBoxes), (App)BookPaintElement.CODEC.listOf().fieldOf("paintElements").forGetter(e -> e.paintElements)).apply((Applicative)instance, BookPage::new));

    public BookPage(String name, String itemHyperlink, List<BookParagraph> paragraph, List<BookItemsAndFluids> itemList, List<BookBlocks> blockList, List<BookEntity> entityList, List<BookImage> imageList, List<BookNonItemTooltip> nonItemTooltipList, List<BookWritableTextBox> writableTextBoxes, List<BookPaintElement> paintElements) {
        this.name = name;
        this.itemHyperlink = itemHyperlink;
        this.paragraph = paragraph != null ? new ArrayList<BookParagraph>(paragraph) : new ArrayList();
        this.itemList = itemList != null ? new ArrayList<BookItemsAndFluids>(itemList) : new ArrayList();
        this.blockList = blockList != null ? new ArrayList<BookBlocks>(blockList) : new ArrayList();
        this.entityList = entityList != null ? new ArrayList<BookEntity>(entityList) : new ArrayList();
        this.imageList = imageList != null ? new ArrayList<BookImage>(imageList) : new ArrayList();
        this.nonItemTooltipList = nonItemTooltipList != null ? new ArrayList<BookNonItemTooltip>(nonItemTooltipList) : new ArrayList();
        this.writableTextBoxes = writableTextBoxes != null ? new ArrayList<BookWritableTextBox>(writableTextBoxes) : new ArrayList();
        this.paintElements = paintElements != null ? new ArrayList<BookPaintElement>(paintElements) : new ArrayList();
    }

    public static CompoundTag saveToTag(BookPage bookPage) {
        return CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)bookPage).resultOrPartial(System.err::println).orElse(new CompoundTag());
    }

    public static BookPage loadFromTag(CompoundTag tag) {
        return CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(System.err::println).map(Pair::getFirst).orElse(new BookPage("", "", new ArrayList<BookParagraph>(), new ArrayList<BookItemsAndFluids>(), new ArrayList<BookBlocks>(), new ArrayList<BookEntity>(), new ArrayList<BookImage>(), new ArrayList<BookNonItemTooltip>(), new ArrayList<BookWritableTextBox>(), new ArrayList<BookPaintElement>()));
    }

    private static <T extends Comparable<T>> BlockState setValueHelper(BlockState state, Property<T> property, String value) {
        return property.getValue(value).map(v -> (BlockState)state.setValue(property, v)).orElse(state);
    }
}

