/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.books;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.books.BookBlocks;
import net.joefoxe.hexerei.data.books.BookChapter;
import net.joefoxe.hexerei.data.books.BookEntity;
import net.joefoxe.hexerei.data.books.BookEntries;
import net.joefoxe.hexerei.data.books.BookImage;
import net.joefoxe.hexerei.data.books.BookItemsAndFluids;
import net.joefoxe.hexerei.data.books.BookManager;
import net.joefoxe.hexerei.data.books.BookNonItemTooltip;
import net.joefoxe.hexerei.data.books.BookPage;
import net.joefoxe.hexerei.data.books.BookPaintElement;
import net.joefoxe.hexerei.data.books.BookParagraph;
import net.joefoxe.hexerei.data.books.BookWritableTextBox;
import net.joefoxe.hexerei.data.books.PaintSystemSavedData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.fml.loading.FMLEnvironment;

public class BookReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static boolean askForUpdate = false;

    public BookReloadListener() {
        super(GSON, "book");
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller profile) {
        ArrayList<ResourceLocation> books = new ArrayList<ResourceLocation>();
        jsons.forEach((key, input) -> {
            if (input != null) {
                try {
                    String keyString;
                    ResourceLocation bookLoc = ResourceLocation.parse((String)key.toString().split("/")[0]);
                    if (!books.contains(bookLoc)) {
                        BookManager.clearBookPages(bookLoc);
                        books.add(bookLoc);
                    }
                    if ((keyString = key.getPath()).equals(bookLoc.getPath() + "/" + bookLoc.getPath())) {
                        BookReloadListener.addBookEntries(bookLoc, input);
                    } else {
                        BookReloadListener.addBookPage(bookLoc, key, input);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Hexerei.LOGGER.error("Failed to parse JSON object for book page {}", key);
                }
            }
        });
        if (!FMLEnvironment.dist.isClient()) {
            BookManager.sendBookEntriesToClient(books);
            BookManager.sendBookPagesToClient(books);
            PaintSystemSavedData.sendToClients();
        } else {
            askForUpdate = true;
        }
    }

    private static void addBookPage(ResourceLocation bookLoc, ResourceLocation key, JsonElement input) {
        JsonObject jsonObject = input.getAsJsonObject();
        String name = GsonHelper.getAsString((JsonObject)jsonObject, (String)"name", (String)"");
        ArrayList<BookParagraph> paragraphsList = new ArrayList<BookParagraph>();
        if (jsonObject.has("paragraphs")) {
            JsonArray paragraphs = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"paragraphs");
            for (int i = 0; i < paragraphs.size(); ++i) {
                JsonObject obj = paragraphs.get(i).getAsJsonObject();
                paragraphsList.add((BookParagraph)((Pair)BookParagraph.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow()).getFirst());
            }
        }
        ArrayList<BookWritableTextBox> writableTextBoxes = new ArrayList<BookWritableTextBox>();
        if (jsonObject.has("writable_text_box")) {
            JsonArray paragraphs = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"writable_text_box");
            for (int i = 0; i < paragraphs.size(); ++i) {
                JsonObject obj = paragraphs.get(i).getAsJsonObject();
                BookWritableTextBox box = (BookWritableTextBox)((Pair)BookWritableTextBox.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow()).getFirst();
                box.parentLocation = key;
                writableTextBoxes.add(box);
            }
        }
        ArrayList<BookPaintElement> paintElements = new ArrayList<BookPaintElement>();
        if (jsonObject.has("paint_element")) {
            JsonArray paragraphs = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"paint_element");
            for (int i = 0; i < paragraphs.size(); ++i) {
                JsonObject obj = paragraphs.get(i).getAsJsonObject();
                BookPaintElement paint = (BookPaintElement)((Pair)BookPaintElement.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).getOrThrow()).getFirst();
                paint.parentLocation = key;
                paintElements.add(paint);
            }
        }
        ArrayList<BookItemsAndFluids> itemsInSlotsList = new ArrayList<BookItemsAndFluids>();
        if (jsonObject.has("items_and_fluids")) {
            JsonArray itemsAndFluids = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"items_and_fluids");
            for (int i = 0; i < itemsAndFluids.size(); ++i) {
                JsonObject obj = itemsAndFluids.get(i).getAsJsonObject();
                Optional optional = BookItemsAndFluids.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).result();
                optional.ifPresent(bookItemsAndFluidsJsonElementPair -> itemsInSlotsList.add((BookItemsAndFluids)bookItemsAndFluidsJsonElementPair.getFirst()));
            }
        }
        ArrayList<BookBlocks> blocksList = new ArrayList<BookBlocks>();
        if (jsonObject.has("blocks")) {
            JsonArray blocks = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"blocks");
            for (int i = 0; i < blocks.size(); ++i) {
                JsonObject obj = blocks.get(i).getAsJsonObject();
                Optional optional = BookBlocks.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).result();
                optional.ifPresent(bookBlocksPair -> blocksList.add((BookBlocks)bookBlocksPair.getFirst()));
            }
        }
        ArrayList<BookEntity> entityList = new ArrayList<BookEntity>();
        if (jsonObject.has("entities")) {
            JsonArray entity = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"entities");
            for (int i = 0; i < entity.size(); ++i) {
                JsonObject obj = entity.get(i).getAsJsonObject();
                Optional optional = BookEntity.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).result();
                optional.ifPresent(bookEntityPair -> entityList.add((BookEntity)bookEntityPair.getFirst()));
            }
        }
        ArrayList<BookImage> imagesList = new ArrayList<BookImage>();
        if (jsonObject.has("images")) {
            JsonArray images = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"images");
            for (int i = 0; i < images.size(); ++i) {
                JsonObject obj = images.get(i).getAsJsonObject();
                Optional optional = BookImage.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).result();
                optional.ifPresent(bookImagePair -> imagesList.add((BookImage)bookImagePair.getFirst()));
            }
        }
        ArrayList<BookNonItemTooltip> nonItemTooltipsList = new ArrayList<BookNonItemTooltip>();
        if (jsonObject.has("non_item_tooltips")) {
            JsonArray non_item_tooltips = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"non_item_tooltips");
            for (int i = 0; i < non_item_tooltips.size(); ++i) {
                JsonObject obj = non_item_tooltips.get(i).getAsJsonObject();
                Optional optional = BookNonItemTooltip.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj).result();
                optional.ifPresent(bookNonItemTooltip -> nonItemTooltipsList.add((BookNonItemTooltip)bookNonItemTooltip.getFirst()));
            }
        }
        String itemHyperlink = GsonHelper.getAsString((JsonObject)jsonObject, (String)"item_hyperlink", (String)"none");
        BookPage page = new BookPage(name, itemHyperlink, paragraphsList, itemsInSlotsList, blocksList, entityList, imagesList, nonItemTooltipsList, writableTextBoxes, paintElements);
        page.location = key;
        BookManager.addBookPage(bookLoc, key, page);
    }

    private static void addBookEntries(ResourceLocation bookLoc, JsonElement input) {
        JsonObject jsonObject = input.getAsJsonObject();
        int numberOfPages = 0;
        ArrayList<BookChapter> chaptersList = new ArrayList<BookChapter>();
        if (jsonObject.has("chapters")) {
            JsonArray chapters = GsonHelper.getAsJsonArray((JsonObject)jsonObject, (String)"chapters");
            for (int i = 0; i < chapters.size(); ++i) {
                JsonObject obj = chapters.get(i).getAsJsonObject();
                BookChapter bookChapter = BookChapter.deserialize(i, obj, numberOfPages);
                numberOfPages += bookChapter.pages.size();
                chaptersList.add(bookChapter);
            }
        }
        BookManager.addBookEntries(new BookEntries(bookLoc, chaptersList, numberOfPages));
    }
}

