/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.candle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.candle.AbstractCandleEffect;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.message.CandleEffectParticlePacket;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PotionCandleEffect
extends AbstractCandleEffect {
    private static final int MAX_TIME = 160;
    @Nullable
    public MobEffect effect;

    public PotionCandleEffect(@Nullable MobEffect effect, ParticleOptions particleOptions) {
        super(particleOptions);
        this.effect = effect;
    }

    public PotionCandleEffect(@Nullable MobEffect effect) {
        this.effect = effect;
    }

    @Override
    public void tick(Level level, CandleTile blockEntity, CandleData candleData) {
        if (this.effect == null) {
            return;
        }
        if (candleData.lit) {
            if (candleData.cooldown >= 160) {
                int duration = 200;
                if (!level.isClientSide()) {
                    PotionCandleEffect.applyEffects(level, blockEntity.getBlockPos(), 5.0f, this.effect.isInstantenous() ? 1 : (int)((float)duration * candleData.getEffectDurationMultiplier()), Math.max(0, (int)candleData.getEffectAmplifierMultiplier() - 1), this.effect, candleData.effectParticle, candleData);
                }
                candleData.cooldown = 0;
            }
            if (candleData.effectParticle != null && level.isClientSide() && candleData.effectParticle != null && candleData.effectParticle.size() > 0) {
                String resourceLocation = candleData.effectParticle.get(new Random().nextInt(candleData.effectParticle.size()));
                try {
                    this.particle = ParticleArgument.readParticle((StringReader)new StringReader(resourceLocation), (HolderLookup.Provider)level.registryAccess());
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
            }
            candleData.cooldown = (candleData.cooldown + 1) % Integer.MAX_VALUE;
        }
    }

    private static void applyEffects(Level pLevel, BlockPos pPos, float size, int duration, int amplifier, @Nullable MobEffect pPrimary, List<String> particle, CandleData candleData) {
        if (pPrimary != null) {
            AABB aabb = new AABB(pPos).inflate((double)size).expandTowards(0.0, size * 4.0f < 4.0f ? 4.0 : (double)(size * 4.0f), 0.0);
            List list = pLevel.getEntitiesOfClass(LivingEntity.class, aabb);
            int id = BuiltInRegistries.MOB_EFFECT.getId((Object)pPrimary);
            Optional effectHolder = BuiltInRegistries.MOB_EFFECT.getHolder(id);
            for (LivingEntity living : list) {
                if (pLevel.isClientSide || !effectHolder.isPresent()) continue;
                living.addEffect(new MobEffectInstance((Holder)effectHolder.get(), duration, amplifier, true, false, true));
                if (particle == null || particle.isEmpty()) continue;
                HexereiPacketHandler.sendToNearbyClient(pLevel, pPos, (CustomPacketPayload)new CandleEffectParticlePacket(pPos, particle, living.getId(), 0));
            }
            if (particle != null && !particle.isEmpty()) {
                HexereiPacketHandler.sendToNearbyClient(pLevel, pPos, (CustomPacketPayload)new CandleEffectParticlePacket(pPos, particle, 0, 1));
            }
        }
    }

    public static void spawnParticles(Level pLevel, List<String> particle, LivingEntity living) {
        float heightOffset = living.getBbHeight() / 4.0f;
        for (int i = 0; i < 5; ++i) {
            float rotation = random.nextFloat() * 360.0f;
            Vec3 offset = new Vec3(random.nextDouble() * 2.0 * Math.cos(rotation), 0.0, random.nextDouble() * 2.0 * Math.sin(rotation));
            if (particle == null) continue;
            try {
                pLevel.addParticle(ParticleArgument.readParticle((StringReader)new StringReader(particle.get(random.nextInt(particle.size()))), (HolderLookup.Provider)pLevel.registryAccess()), living.getX(), living.getY() + (double)heightOffset, living.getZ(), offset.x / 32.0, (random.nextDouble() + 0.5) * 0.015, offset.z / 32.0);
                continue;
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public <T> AbstractCandleEffect getCopy() {
        return new PotionCandleEffect(this.effect, this.particle);
    }

    @Override
    public String getLocationName() {
        ResourceLocation loc = this.effect == null ? null : BuiltInRegistries.MOB_EFFECT.getKey((Object)this.effect);
        return loc != null ? loc.toString() : this.effect.getDescriptionId();
    }
}

