/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.datagen;

import javax.annotation.Nullable;
import net.joefoxe.hexerei.data.recipes.FluidMixingRecipe;
import net.joefoxe.hexerei.fluid.PotionFluid;
import net.joefoxe.hexerei.fluid.PotionFluidHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;

public class AddToCandleRecipeBuilder
implements RecipeBuilder {
    private final ItemStack result;
    private final Ingredient ingredient;
    private final Advancement.Builder advancement = Advancement.Builder.advancement();

    public AddToCandleRecipeBuilder(ItemLike ingredient, ItemStack result) {
        this.ingredient = Ingredient.of((ItemLike[])new ItemLike[]{ingredient});
        this.result = result;
    }

    public RecipeBuilder unlockedBy(String pCriterionName, Criterion<?> criterion) {
        this.advancement.addCriterion(pCriterionName, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String pGroupName) {
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation resourceLocation) {
        this.save(recipeOutput, resourceLocation.toString());
    }

    public void save(RecipeOutput recipeOutput, String id) {
        AdvancementHolder holder = recipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)ResourceLocation.parse((String)id))).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)ResourceLocation.parse((String)id))).requirements(AdvancementRequirements.Strategy.OR).build(ResourceLocation.withDefaultNamespace((String)"recipes/root"));
        FluidStack fls1 = PotionFluidHandler.getFluidFromPotion((Holder<Potion>)Potions.FIRE_RESISTANCE, PotionFluid.BottleType.SPLASH, 250);
        FluidStack fls2 = PotionFluidHandler.getFluidFromPotion((Holder<Potion>)Potions.WATER, PotionFluid.BottleType.SPLASH, 250);
        FluidMixingRecipe recipe = new FluidMixingRecipe((NonNullList<Ingredient>)NonNullList.withSize((int)8, (Object)Ingredient.EMPTY), fls1, fls2);
        String path = ResourceLocation.parse((String)id).getPath();
        recipeOutput.accept(ResourceLocation.fromNamespaceAndPath((String)"hexerei", (String)path.trim()), (Recipe)recipe, holder);
    }
}

