/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.owl;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.data.owl.OwlCourierDepotData;
import net.joefoxe.hexerei.util.message.ClientboundOwlCourierDepotDataInventoryPacket;
import net.joefoxe.hexerei.util.message.ClientboundOwlCourierDepotDataPacket;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;

public class ClientOwlCourierDepotData {
    public static Map<GlobalPos, OwlCourierDepotData> depots = new HashMap<GlobalPos, OwlCourierDepotData>();

    public static Map<GlobalPos, OwlCourierDepotData> getDepots() {
        return depots;
    }

    public static void update(ClientboundOwlCourierDepotDataPacket packet) {
        ClientOwlCourierDepotData.load(packet.getTag());
    }

    public static void update(ClientboundOwlCourierDepotDataInventoryPacket packet) {
        ClientOwlCourierDepotData.invLoad(packet.getTag());
    }

    public static void invLoad(CompoundTag pCompoundTag) {
        Optional pos = GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pCompoundTag.get("Pos")).result();
        NonNullList stacks = NonNullList.withSize((int)8, (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)pCompoundTag, (NonNullList)stacks, (HolderLookup.Provider)Hexerei.DynamicRegistries.get());
        pos.ifPresent(globalPos -> {
            ClientOwlCourierDepotData.getDepots().get((Object)globalPos).items = stacks;
        });
    }

    public static void load(CompoundTag pCompoundTag) {
        depots.clear();
        if (pCompoundTag.contains("depots")) {
            ListTag depotList = pCompoundTag.getList("depots", 10);
            for (int i = 0; i < depotList.size(); ++i) {
                CompoundTag depotTag = depotList.getCompound(i);
                String depotName = depotTag.getString("DepotName");
                Optional pos = GlobalPos.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)depotTag.get("Pos")).result();
                OwlCourierDepotData depotData = new OwlCourierDepotData(depotName);
                ContainerHelper.loadAllItems((CompoundTag)depotTag, depotData.items, (HolderLookup.Provider)Hexerei.DynamicRegistries.get());
                pos.ifPresent(globalPos -> depots.put((GlobalPos)globalPos, depotData));
            }
        }
    }
}

