/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.owl;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.joefoxe.hexerei.client.renderer.entity.custom.OwlEntity;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="hexerei")
public class OwlLoadedChunksSavedData
extends SavedData {
    protected static final String DATA_NAME = "hexerei_owl_loaded_chunks";
    Map<ResourceKey<Level>, Map<ChunkPos, List<UUID>>> chunkData = new HashMap<ResourceKey<Level>, Map<ChunkPos, List<UUID>>>();
    Map<ResourceKey<Level>, Set<ChunkPos>> selfLoadedChunks = new HashMap<ResourceKey<Level>, Set<ChunkPos>>();

    public OwlLoadedChunksSavedData addOwlLoading(ServerLevel level, OwlEntity owl, Set<ChunkPos> newChunks) {
        Map<ResourceKey<Level>, Set<ChunkPos>> lastChunksMap = owl.messagingController.getLastCheckedChunks();
        if (!this.chunkData.containsKey(level.dimension())) {
            this.chunkData.put((ResourceKey<Level>)level.dimension(), new HashMap());
        }
        for (ChunkPos chunkPos : newChunks) {
            List<Object> list = this.chunkData.get(level.dimension()).containsKey(chunkPos) ? this.chunkData.get(level.dimension()).get(chunkPos) : new ArrayList();
            if (list.contains(owl.getUUID())) continue;
            list.add(owl.getUUID());
            this.chunkData.get(level.dimension()).put(chunkPos, list);
        }
        lastChunksMap.forEach((key, lastChunks) -> {
            for (ChunkPos chunkPos : lastChunks) {
                if (newChunks.contains(chunkPos) || !key.equals(level.dimension()) || !this.chunkData.get(key).containsKey(chunkPos)) continue;
                List<UUID> list = this.chunkData.get(key).get(chunkPos);
                list.remove(owl.getUUID());
                if (!list.isEmpty()) continue;
                this.chunkData.get(key).remove(chunkPos);
                if (!this.selfLoadedChunks.containsKey(key)) {
                    this.selfLoadedChunks.put((ResourceKey<Level>)key, new HashSet());
                }
                if (!this.selfLoadedChunks.get(key).contains(chunkPos)) continue;
                level.setChunkForced(chunkPos.x, chunkPos.z, false);
                this.selfLoadedChunks.get(key).remove(chunkPos);
            }
        });
        this.setDirty();
        return this;
    }

    public void clearOwl(ServerLevel serverLevel, OwlEntity owl) {
        HashMap<ResourceKey, Set> _to_remove = new HashMap<ResourceKey, Set>();
        this.chunkData.forEach((dimension, data) -> data.forEach((chunkPos, uuids) -> {
            List list = (List)data.get(chunkPos);
            list.remove(owl.getUUID());
            if (list.isEmpty()) {
                if (!_to_remove.containsKey(dimension)) {
                    _to_remove.put((ResourceKey)dimension, new HashSet());
                }
                ((Set)_to_remove.get(dimension)).add(chunkPos);
                if (!this.selfLoadedChunks.containsKey(dimension)) {
                    this.selfLoadedChunks.put((ResourceKey<Level>)dimension, new HashSet());
                }
                if (this.selfLoadedChunks.get(dimension).contains(chunkPos)) {
                    ServerLevel level = serverLevel.getServer().getLevel(dimension);
                    if (level != null) {
                        level.setChunkForced(chunkPos.x, chunkPos.z, false);
                    }
                    this.selfLoadedChunks.get(dimension).remove(chunkPos);
                }
            }
        }));
        _to_remove.forEach((dim, posSet) -> {
            for (ChunkPos pos : posSet) {
                if (!this.chunkData.containsKey(dim)) continue;
                this.chunkData.get(dim).remove(pos);
            }
        });
        this.setDirty();
    }

    public void tick(ServerLevel serverLevel) {
        this.chunkData.forEach((dimension, data) -> data.forEach((chunkPos, uuids) -> {
            ServerLevel level = serverLevel.getServer().getLevel(dimension);
            if (level != null) {
                LongSet forcedChunks = level.getForcedChunks();
                if (!this.selfLoadedChunks.containsKey(dimension)) {
                    this.selfLoadedChunks.put((ResourceKey<Level>)dimension, new HashSet());
                }
                if (!this.selfLoadedChunks.get(dimension).contains(chunkPos) && !forcedChunks.contains(chunkPos.toLong())) {
                    level.setChunkForced(chunkPos.x, chunkPos.z, true);
                    this.selfLoadedChunks.get(dimension).add((ChunkPos)chunkPos);
                    this.setDirty();
                }
            }
        }));
    }

    @SubscribeEvent
    public static void serverTickEvent(ServerTickEvent.Pre event) {
        OwlLoadedChunksSavedData.get(event.getServer().overworld()).tick(event.getServer().overworld());
    }

    private static OwlLoadedChunksSavedData create(CompoundTag tag, HolderLookup.Provider registries) {
        OwlLoadedChunksSavedData data = new OwlLoadedChunksSavedData();
        data.load(tag, registries);
        return data;
    }

    public void load(CompoundTag pCompoundTag, HolderLookup.Provider registries) {
        this.selfLoadedChunks.clear();
        if (pCompoundTag.contains("selfLoadedChunks")) {
            CompoundTag selfLoadedChunksTag = pCompoundTag.getCompound("selfLoadedChunks");
            for (String key : selfLoadedChunksTag.getAllKeys()) {
                ListTag chunkListTag = selfLoadedChunksTag.getList(key, 10);
                ResourceKey levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)key));
                HashSet<ChunkPos> chunkPosSet = new HashSet<ChunkPos>();
                for (int i = 0; i < chunkListTag.size(); ++i) {
                    CompoundTag chunkTag = chunkListTag.getCompound(i);
                    int x = chunkTag.getInt("x");
                    int z = chunkTag.getInt("z");
                    chunkPosSet.add(new ChunkPos(x, z));
                }
                this.selfLoadedChunks.put((ResourceKey<Level>)levelKey, chunkPosSet);
            }
        }
        CompoundTag dataTag = pCompoundTag.getCompound("chunkData");
        dataTag.getAllKeys().forEach(resourceKeyString -> {
            ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)resourceKeyString));
            CompoundTag resourceTag = dataTag.getCompound(resourceKeyString);
            HashMap chunkMap = new HashMap();
            resourceTag.getAllKeys().forEach(chunkPosString -> {
                CompoundTag chunkTag = resourceTag.getCompound(chunkPosString);
                int x = chunkTag.getInt("x");
                int z = chunkTag.getInt("z");
                ChunkPos chunkPos = new ChunkPos(x, z);
                ListTag uuidTagList = chunkTag.getList("UUIDs", 8);
                ArrayList uuidList = new ArrayList();
                uuidTagList.forEach(uuidTag -> uuidList.add(UUID.fromString(uuidTag.getAsString())));
                chunkMap.put(chunkPos, uuidList);
            });
            this.chunkData.put((ResourceKey<Level>)resourceKey, chunkMap);
        });
    }

    public CompoundTag save(CompoundTag pCompoundTag, HolderLookup.Provider registries) {
        CompoundTag compoundTag = new CompoundTag();
        this.selfLoadedChunks.forEach((resourceKey, chunkSet) -> {
            ListTag chunkListTag = new ListTag();
            chunkSet.forEach(chunkPos -> {
                CompoundTag chunkNBT = new CompoundTag();
                chunkNBT.putInt("x", chunkPos.x);
                chunkNBT.putInt("z", chunkPos.z);
                chunkListTag.add((Object)chunkNBT);
            });
            compoundTag.put(resourceKey.location().toString(), (Tag)chunkListTag);
        });
        pCompoundTag.put("selfLoadedChunks", (Tag)compoundTag);
        CompoundTag dataTag = new CompoundTag();
        this.chunkData.forEach((resourceKey, chunkMap) -> {
            CompoundTag resourceTag = new CompoundTag();
            chunkMap.forEach((chunkPos, uuidList) -> {
                CompoundTag chunkTag = new CompoundTag();
                chunkTag.putInt("x", chunkPos.x);
                chunkTag.putInt("z", chunkPos.z);
                ListTag uuidTagList = new ListTag();
                uuidList.forEach(uuid -> uuidTagList.add((Object)StringTag.valueOf((String)uuid.toString())));
                chunkTag.put("UUIDs", (Tag)uuidTagList);
                resourceTag.put(chunkPos.x + "," + chunkPos.z, (Tag)chunkTag);
            });
            dataTag.put(resourceKey.location().toString(), (Tag)resourceTag);
        });
        pCompoundTag.put("chunkData", (Tag)dataTag);
        return pCompoundTag;
    }

    public static SavedData.Factory<OwlLoadedChunksSavedData> factory() {
        return new SavedData.Factory(OwlLoadedChunksSavedData::new, OwlLoadedChunksSavedData::create, null);
    }

    public static OwlLoadedChunksSavedData get(ServerLevel world) {
        return (OwlLoadedChunksSavedData)world.getServer().overworld().getDataStorage().computeIfAbsent(OwlLoadedChunksSavedData.factory(), DATA_NAME);
    }

    public static OwlLoadedChunksSavedData get() {
        return (OwlLoadedChunksSavedData)ServerLifecycleHooks.getCurrentServer().overworld().getDataStorage().computeIfAbsent(OwlLoadedChunksSavedData.factory(), DATA_NAME);
    }
}

