/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.joefoxe.hexerei.item.custom.CrowAmuletItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class CrowAmuletRecipe
extends CustomRecipe {
    public CrowAmuletRecipe(CraftingBookCategory cBc) {
        super(cBc);
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(CraftingInput inventory, Level world) {
        int amulet = 0;
        int other = 0;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof CrowAmuletItem) {
                CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                if (!tag.contains("Items")) {
                    ++amulet;
                }
            } else {
                ++other;
            }
            if (other <= 1 && amulet <= true) continue;
            return false;
        }
        return amulet == 1 && other == 1;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider registryAccess) {
        ItemStack amulet = ItemStack.EMPTY;
        ItemStack other = ItemStack.EMPTY;
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof CrowAmuletItem) {
                amulet = stack.copy();
                amulet.setCount(1);
                continue;
            }
            other = stack.copy();
            other.setCount(1);
        }
        if (amulet.getItem() instanceof CrowAmuletItem && !other.isEmpty()) {
            CompoundTag tag = ((CustomData)amulet.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            ListTag listtag = new ListTag();
            if (!other.isEmpty()) {
                listtag.add((Object)other.save(registryAccess));
            }
            tag.put("Items", (Tag)listtag);
            amulet.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
        return amulet;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 2 && height >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.CROW_AMULET_APPLY_SERIALIZER.get();
    }
}

