/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MoonPhases {

    public static enum MoonCondition implements StringRepresentable
    {
        NONE("none"),
        NEW_MOON("new_moon"),
        WAXING_CRESCENT("waxing_crescent"),
        FIRST_QUARTER("first_quarter"),
        WAXING_GIBBOUS("waxing_gibbous"),
        FULL_MOON("full_moon"),
        WANING_GIBBOUS("waning_gibbous"),
        LAST_QUARTER("last_quarter"),
        WANING_CRESCENT("waning_crescent");

        private final String name;
        public static final StringRepresentable.EnumCodec<MoonCondition> CODEC;

        private MoonCondition(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getNameTranslated() {
            return "tooltip.hexerei." + this.name;
        }

        public static MoonCondition getMoonCondition(String str) {
            return switch (str) {
                case "new_moon" -> NEW_MOON;
                case "waxing_crescent" -> WAXING_CRESCENT;
                case "first_quarter" -> FIRST_QUARTER;
                case "waxing_gibbous" -> WAXING_GIBBOUS;
                case "full_moon" -> FULL_MOON;
                case "waning_gibbous" -> WANING_GIBBOUS;
                case "last_quarter" -> LAST_QUARTER;
                case "waning_crescent" -> WANING_CRESCENT;
                default -> NONE;
            };
        }

        public static MoonCondition getMoonPhase(Level level) {
            if (level == null) {
                return NONE;
            }
            long time = level.getDayTime();
            int phase = level.getMoonPhase();
            if (time % 24000L < 12300L || time % 24000L > 23850L) {
                return NONE;
            }
            return switch (phase) {
                case 0 -> FULL_MOON;
                case 1 -> WANING_GIBBOUS;
                case 2 -> LAST_QUARTER;
                case 3 -> WANING_CRESCENT;
                case 4 -> NEW_MOON;
                case 5 -> WAXING_CRESCENT;
                case 6 -> FIRST_QUARTER;
                default -> WAXING_GIBBOUS;
            };
        }

        @NotNull
        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> "none";
                case 1 -> NEW_MOON.getName();
                case 2 -> WAXING_CRESCENT.getName();
                case 3 -> FIRST_QUARTER.getName();
                case 4 -> WAXING_GIBBOUS.getName();
                case 5 -> FULL_MOON.getName();
                case 6 -> WANING_GIBBOUS.getName();
                case 7 -> LAST_QUARTER.getName();
                case 8 -> WANING_CRESCENT.getName();
            };
        }

        static {
            CODEC = StringRepresentable.fromEnum(MoonCondition::values);
        }
    }
}

