/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.data.recipes.ModRecipeTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class WoodcutterRecipe
extends SingleItemRecipe {
    public int ingredientCount;

    public WoodcutterRecipe(String pGroup, Ingredient pIngredient, String itemId, int itemCount, int ingredientCount) {
        super((RecipeType)ModRecipeTypes.WOODCUTTING_TYPE.get(), (RecipeSerializer)ModRecipeTypes.WOODCUTTING_SERIALIZER.get(), pGroup, pIngredient, new ItemStack((ItemLike)BuiltInRegistries.ITEM.getOptional(ResourceLocation.parse((String)itemId)).orElse(Items.AIR), itemCount));
        this.ingredientCount = ingredientCount;
    }

    public WoodcutterRecipe(String pGroup, Ingredient pIngredient, int ingredientCount, ItemStack output) {
        super((RecipeType)ModRecipeTypes.WOODCUTTING_TYPE.get(), (RecipeSerializer)ModRecipeTypes.WOODCUTTING_SERIALIZER.get(), pGroup, pIngredient, output);
        this.ingredientCount = ingredientCount;
    }

    public boolean isSpecial() {
        return true;
    }

    public boolean matches(SingleRecipeInput pInv, Level pLevel) {
        return this.ingredient.test(pInv.getItem(0));
    }

    public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.WILLOW_WOODCUTTER.get());
    }

    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public static class Type
    implements RecipeType<WoodcutterRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<WoodcutterRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        private static final MapCodec<WoodcutterRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(SingleItemRecipe::getGroup), (App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> ((WoodcutterRecipe)recipe).ingredient), (App)Codec.STRING.fieldOf("result").forGetter(recipe -> BuiltInRegistries.ITEM.getKey((Object)((WoodcutterRecipe)recipe).result.getItem()).toString()), (App)Codec.INT.fieldOf("count").forGetter(recipe -> ((WoodcutterRecipe)recipe).result.getCount()), (App)Codec.INT.fieldOf("ingredient_count").forGetter(recipe -> recipe.ingredientCount)).apply((Applicative)instance, WoodcutterRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, WoodcutterRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<WoodcutterRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, WoodcutterRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static WoodcutterRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String group = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            Ingredient ingredient = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            String result = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            int count = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            int ingredient_count = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            return new WoodcutterRecipe(group, ingredient, result, count, ingredient_count);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, WoodcutterRecipe recipe) {
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)recipe.group);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.ingredient);
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)BuiltInRegistries.ITEM.getKey((Object)recipe.result.getItem()).toString());
            ByteBufCodecs.INT.encode((Object)buffer, (Object)recipe.result.getCount());
            ByteBufCodecs.INT.encode((Object)buffer, (Object)recipe.ingredientCount);
        }
    }
}

