/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.data.recipes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.joefoxe.hexerei.block.ModBlocks;
import net.joefoxe.hexerei.block.connected.ConnectedPillarBlock;
import net.joefoxe.hexerei.block.connected.LayeredBlock;
import net.joefoxe.hexerei.data.recipes.WoodcutterRecipe;
import net.joefoxe.hexerei.util.HexereiPacketHandler;
import net.joefoxe.hexerei.util.HexereiTags;
import net.joefoxe.hexerei.util.message.WoodcutterRecipesPacket;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.brewing.BrewingRecipe;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class WoodcutterRecipes {
    public static List<WoodcutterRecipe> ALL = new ArrayList<WoodcutterRecipe>();
    public static Map<Item, List<WoodcutterRecipe>> BY_ITEM;
    public static List<BrewingRecipe> recipes;

    public static void addSwappableRecipes(List<WoodcutterRecipe> recipes, List<Item> items) {
        for (Item part1 : items) {
            for (Item part2 : items) {
                if (part2 == part1) continue;
                recipes.add(WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)part1, 1), new ItemStack((ItemLike)part2, 1)));
            }
        }
    }

    public static void createRecipes(MinecraftServer server) {
        ArrayList<ItemStack> stacks;
        ArrayList<WoodcutterRecipe> recipes = new ArrayList<WoodcutterRecipe>();
        WoodcutterRecipes.addSwappableRecipes(recipes, List.of(((Block)ModBlocks.WILLOW_PLANKS.get()).asItem(), ((Block)ModBlocks.POLISHED_WILLOW_PLANKS.get()).asItem(), ((Block)ModBlocks.WILLOW_CONNECTED.get()).asItem(), ((Block)ModBlocks.POLISHED_WILLOW_CONNECTED.get()).asItem(), ((ConnectedPillarBlock)((Object)ModBlocks.POLISHED_WILLOW_PILLAR.get())).asItem(), ((LayeredBlock)((Object)ModBlocks.POLISHED_WILLOW_LAYERED.get())).asItem()));
        WoodcutterRecipes.addSwappableRecipes(recipes, List.of(((Block)ModBlocks.WITCH_HAZEL_PLANKS.get()).asItem(), ((Block)ModBlocks.POLISHED_WITCH_HAZEL_PLANKS.get()).asItem(), ((Block)ModBlocks.WITCH_HAZEL_CONNECTED.get()).asItem(), ((Block)ModBlocks.POLISHED_WITCH_HAZEL_CONNECTED.get()).asItem(), ((ConnectedPillarBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_PILLAR.get())).asItem(), ((LayeredBlock)((Object)ModBlocks.POLISHED_WITCH_HAZEL_LAYERED.get())).asItem()));
        WoodcutterRecipes.addSwappableRecipes(recipes, List.of(((Block)ModBlocks.MAHOGANY_PLANKS.get()).asItem(), ((Block)ModBlocks.POLISHED_MAHOGANY_PLANKS.get()).asItem(), ((Block)ModBlocks.MAHOGANY_CONNECTED.get()).asItem(), ((Block)ModBlocks.POLISHED_MAHOGANY_CONNECTED.get()).asItem(), ((ConnectedPillarBlock)((Object)ModBlocks.POLISHED_MAHOGANY_PILLAR.get())).asItem(), ((LayeredBlock)((Object)ModBlocks.POLISHED_MAHOGANY_LAYERED.get())).asItem()));
        recipes.add(WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)ModBlocks.WILLOW_PLANKS.get(), 3), new ItemStack((ItemLike)ModBlocks.WILLOW_ALTAR.get(), 1)));
        recipes.add(new WoodcutterRecipe("", Ingredient.of(HexereiTags.Items.WILLOW_PLANKS), 5, new ItemStack((ItemLike)ModBlocks.WILLOW_CHEST.get(), 1)));
        recipes.add(WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)ModBlocks.WITCH_HAZEL_PLANKS.get(), 3), new ItemStack((ItemLike)ModBlocks.WITCH_HAZEL_ALTAR.get(), 1)));
        recipes.add(new WoodcutterRecipe("", Ingredient.of(HexereiTags.Items.WITCH_HAZEL_PLANKS), 5, new ItemStack((ItemLike)ModBlocks.WITCH_HAZEL_CHEST.get(), 1)));
        recipes.add(WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)ModBlocks.MAHOGANY_PLANKS.get(), 3), new ItemStack((ItemLike)ModBlocks.BOOK_OF_SHADOWS_ALTAR.get(), 1)));
        recipes.add(new WoodcutterRecipe("", Ingredient.of(HexereiTags.Items.MAHOGANY_PLANKS), 5, new ItemStack((ItemLike)ModBlocks.MAHOGANY_CHEST.get(), 1)));
        List<Item> planksList = BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().is(ItemTags.PLANKS)).toList();
        List<Item> logList = BuiltInRegistries.ITEM.stream().filter(item -> item.getDefaultInstance().is(ItemTags.LOGS_THAT_BURN)).toList();
        for (Item logs : logList) {
            stacks = new ArrayList<ItemStack>(Stream.generate(() -> ((ItemStack)ItemStack.EMPTY).copy()).limit(9L).toList());
            stacks.set(0, logs.getDefaultInstance());
            ResourceLocation loc = BuiltInRegistries.ITEM.getKey((Object)logs);
            String prefix = "stripped_";
            if (!loc.getPath().startsWith(prefix)) continue;
            Item non_stripped = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)loc.getNamespace(), (String)loc.getPath().substring(prefix.length())));
            recipes.add(WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)non_stripped, 1), new ItemStack((ItemLike)logs, 1)));
        }
        for (Item logs : logList) {
            stacks = new ArrayList<ItemStack>(Stream.generate(() -> ((ItemStack)ItemStack.EMPTY).copy()).limit(9L).toList());
            stacks.set(0, logs.getDefaultInstance());
            for (RecipeHolder recipe : server.getRecipeManager().getRecipesFor(RecipeType.CRAFTING, (RecipeInput)CraftingInput.of((int)3, (int)3, stacks), (Level)server.overworld())) {
                ItemStack output;
                if (recipe.value().getType() != RecipeType.CRAFTING || !(output = recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess())).is(ItemTags.PLANKS)) continue;
                ItemStack[] itemStackArray = (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new);
                int n = itemStackArray.length;
                for (int i = 0; i < n; ++i) {
                    ItemStack ingredient = itemStackArray[i];
                    if (ingredient.getItem() != logs) continue;
                    recipes.add(WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)logs, 1), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 5)));
                }
            }
        }
        for (Item planks : planksList) {
            block5: for (RecipeHolder recipe : server.getRecipeManager().getRecipes()) {
                WoodcutterRecipe newRecipe;
                if (recipe.value().getType() != RecipeType.CRAFTING) continue;
                ItemStack output = recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess());
                if (output.is(ItemTags.BOATS)) {
                    for (ItemStack ingredient : (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new)) {
                        if (ingredient.getItem() != planks) continue;
                        recipes.add(WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 4), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 1)));
                        ArrayList<ItemStack> stacks2 = new ArrayList<ItemStack>(Stream.generate(() -> ((ItemStack)ItemStack.EMPTY).copy()).limit(9L).toList());
                        stacks2.set(0, Items.CHEST.getDefaultInstance());
                        stacks2.set(1, new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 1));
                        Optional recipe1 = server.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)CraftingInput.of((int)3, (int)3, stacks2), (Level)server.overworld());
                        recipe1.ifPresent(rec -> recipes.add(WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 8), new ItemStack((ItemLike)((CraftingRecipe)rec.value()).getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 1))));
                        break;
                    }
                }
                if (output.is(ItemTags.SIGNS)) {
                    for (ItemStack ingredient : (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new)) {
                        if (ingredient.getItem() != planks) continue;
                        newRecipe = WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 2), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 1));
                        recipes.add(newRecipe);
                        break;
                    }
                }
                if (output.is(ItemTags.WOODEN_SLABS)) {
                    for (ItemStack ingredient : (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new)) {
                        if (ingredient.getItem() != planks) continue;
                        newRecipe = WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 1), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 2));
                        recipes.add(newRecipe);
                        break;
                    }
                }
                if (output.is(ItemTags.WOODEN_STAIRS)) {
                    for (ItemStack ingredient : (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new)) {
                        if (ingredient.getItem() != planks) continue;
                        newRecipe = WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 1), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 2));
                        recipes.add(newRecipe);
                        break;
                    }
                }
                if (output.is(ItemTags.WOODEN_DOORS)) {
                    for (ItemStack ingredient : (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new)) {
                        if (ingredient.getItem() != planks) continue;
                        newRecipe = WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 2), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 1));
                        recipes.add(newRecipe);
                        break;
                    }
                }
                if (output.is(ItemTags.WOODEN_TRAPDOORS)) {
                    for (ItemStack ingredient : (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new)) {
                        if (ingredient.getItem() != planks) continue;
                        newRecipe = WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 2), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 1));
                        recipes.add(newRecipe);
                        break;
                    }
                }
                if (output.is(ItemTags.WOODEN_BUTTONS)) {
                    for (ItemStack ingredient : (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new)) {
                        if (ingredient.getItem() != planks) continue;
                        newRecipe = WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 1), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 2));
                        recipes.add(newRecipe);
                        break;
                    }
                }
                if (output.is(ItemTags.WOODEN_FENCES)) {
                    for (ItemStack ingredient : (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new)) {
                        if (ingredient.getItem() != planks) continue;
                        newRecipe = WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 2), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 1));
                        recipes.add(newRecipe);
                        break;
                    }
                }
                if (output.is(ItemTags.FENCE_GATES)) {
                    for (ItemStack ingredient : (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new)) {
                        if (ingredient.getItem() != planks) continue;
                        newRecipe = WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 2), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 1));
                        recipes.add(newRecipe);
                        break;
                    }
                }
                if (!output.is(ItemTags.WOODEN_PRESSURE_PLATES)) continue;
                for (ItemStack ingredient : (ItemStack[])recipe.value().getIngredients().stream().map(Ingredient::getItems).flatMap(Arrays::stream).toArray(ItemStack[]::new)) {
                    if (ingredient.getItem() != planks) continue;
                    newRecipe = WoodcutterRecipes.recipeOf(new ItemStack((ItemLike)planks, 2), new ItemStack((ItemLike)recipe.value().getResultItem((HolderLookup.Provider)server.registryAccess()).getItem(), 1));
                    recipes.add(newRecipe);
                    continue block5;
                }
            }
        }
        recipes.add(new WoodcutterRecipe("", Ingredient.of((TagKey)ItemTags.LOGS_THAT_BURN), 1, new ItemStack((ItemLike)Items.STICK, 15)));
        recipes.add(new WoodcutterRecipe("", Ingredient.of((TagKey)ItemTags.PLANKS), 1, new ItemStack((ItemLike)Items.STICK, 3)));
        recipes.add(new WoodcutterRecipe("", Ingredient.of((TagKey)ItemTags.PLANKS), 2, new ItemStack((ItemLike)Items.CRAFTING_TABLE, 1)));
        recipes.add(new WoodcutterRecipe("", Ingredient.of((TagKey)ItemTags.PLANKS), 4, new ItemStack((ItemLike)Items.BARREL, 1)));
        recipes.add(new WoodcutterRecipe("", Ingredient.of((TagKey)ItemTags.PLANKS), 5, new ItemStack((ItemLike)Items.CHEST, 1)));
        ALL = recipes;
    }

    private static WoodcutterRecipe recipeOf(ItemStack input, ItemStack output) {
        return new WoodcutterRecipe("", Ingredient.of((ItemStack[])new ItemStack[]{input}), input.getCount(), output);
    }

    public static void sendToClient(ServerPlayer player) {
        HexereiPacketHandler.sendToPlayerClient(new WoodcutterRecipesPacket(ALL), player);
    }

    @SubscribeEvent
    public static void serverStarted(ServerStartedEvent event) {
        if (ALL != null) {
            WoodcutterRecipes.createRecipes(event.getServer());
        }
    }

    static {
        recipes = new ArrayList<BrewingRecipe>();
    }
}

