/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import net.joefoxe.hexerei.command.ToggleLightCommand;
import net.joefoxe.hexerei.event.ITimedEvent;
import net.minecraft.commands.CommandSourceStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber(modid="hexerei")
public class EventQueue {
    List<ITimedEvent> events = new ArrayList<ITimedEvent>();
    private static EventQueue serverQueue;
    private static EventQueue clientQueue;

    public void tick(ClientTickEvent.Post tickEvent) {
        if (this.events == null || this.events.isEmpty()) {
            return;
        }
        ArrayList<ITimedEvent> stale = new ArrayList<ITimedEvent>();
        for (int i = 0; i < this.events.size(); ++i) {
            ITimedEvent event = this.events.get(i);
            if (event.isExpired()) {
                stale.add(event);
                continue;
            }
            event.tickEvent(tickEvent);
        }
        this.events.removeAll(stale);
    }

    public void tick(ServerTickEvent.Post tickEvent) {
        if (this.events == null || this.events.isEmpty()) {
            return;
        }
        ArrayList<ITimedEvent> stale = new ArrayList<ITimedEvent>();
        for (int i = 0; i < this.events.size(); ++i) {
            ITimedEvent event = this.events.get(i);
            if (event.isExpired()) {
                stale.add(event);
                continue;
            }
            event.tickEvent((ServerTickEvent)tickEvent);
        }
        this.events.removeAll(stale);
    }

    public void addEvent(ITimedEvent event) {
        if (this.events == null) {
            this.events = new ArrayList<ITimedEvent>();
        }
        this.events.add(event);
    }

    public static EventQueue getServerInstance() {
        if (serverQueue == null) {
            serverQueue = new EventQueue();
        }
        return serverQueue;
    }

    public static EventQueue getClientQueue() {
        if (clientQueue == null) {
            clientQueue = new EventQueue();
        }
        return clientQueue;
    }

    public void clear() {
        this.events = null;
    }

    private EventQueue() {
    }

    @SubscribeEvent
    public static void serverTick(ServerTickEvent.Post e) {
        EventQueue.getServerInstance().tick(e);
    }

    @SubscribeEvent
    public static void clientTickEvent(ClientTickEvent.Post e) {
        EventQueue.getClientQueue().tick(e);
    }

    @SubscribeEvent
    public static void commandRegister(RegisterCommandsEvent event) {
        ToggleLightCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

