/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.events;

import java.util.ArrayList;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.custom.SageBurningPlate;
import net.joefoxe.hexerei.config.HexConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

public class SageBurningPlateEvent {
    @SubscribeEvent
    public void onEntityJoin(MobSpawnEvent.SpawnPlacementCheck e) {
        Level world;
        Level level = e.getLevel().isClientSide() ? null : (world = e.getLevel() instanceof Level ? (Level)e.getLevel() : null);
        if (world == null) {
            return;
        }
        if (e.getSpawnType() != MobSpawnType.NATURAL) {
            return;
        }
        if ((Integer)HexConfig.SAGE_BURNING_PLATE_RANGE.get() == 0) {
            return;
        }
        boolean isHostile = e.getEntityType().getCategory().equals((Object)MobCategory.MONSTER);
        if (!e.getEntityType().getCategory().equals((Object)MobCategory.MONSTER)) {
            return;
        }
        ArrayList<BlockPos> nonSagePlatesInList = new ArrayList<BlockPos>();
        if (Hexerei.sageBurningPlateTileList.isEmpty()) {
            return;
        }
        BlockPos burning_plate = null;
        for (BlockPos nearbySageBurningPlate : Hexerei.sageBurningPlateTileList) {
            float dist = (float)Math.sqrt(e.getPos().distToCenterSqr((Position)nearbySageBurningPlate.getCenter()));
            if (!(dist < (float)((Integer)HexConfig.SAGE_BURNING_PLATE_RANGE.get() + 1))) continue;
            BlockState burning_platestate = world.getBlockState(nearbySageBurningPlate);
            Block block = burning_platestate.getBlock();
            if (!(block instanceof SageBurningPlate)) {
                nonSagePlatesInList.add(nearbySageBurningPlate);
                continue;
            }
            if (!((Boolean)burning_platestate.getValue((Property)SageBurningPlate.LIT)).booleanValue()) continue;
            burning_plate = nearbySageBurningPlate.immutable();
            break;
        }
        for (BlockPos nonSageBurninPlate : nonSagePlatesInList) {
            Hexerei.sageBurningPlateTileList.remove(nonSageBurninPlate);
        }
        if (burning_plate == null) {
            return;
        }
        e.setResult(MobSpawnEvent.SpawnPlacementCheck.Result.FAIL);
    }
}

