/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.joefoxe.hexerei.item.ModItems;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItemGroup {
    public static final DeferredRegister<CreativeModeTab> ITEM_GROUP = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"hexerei");
    private static final List<DeferredHolder<Item, Item>> BLACKLIST = List.of(ModItems.BROOM_KEYCHAIN_BASE, ModItems.CROW_BLANK_AMULET_TRINKET, ModItems.CROW_BLANK_AMULET_TRINKET_FRAME);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> HEXEREI_GROUP = ITEM_GROUP.register("hexerei_tab", () -> CreativeModeTab.builder().icon(() -> ((Item)ModItems.MIXING_CAULDRON.get()).getDefaultInstance()).title((Component)Component.translatable((String)"itemGroup.hexereiModTab")).displayItems(new CreativeModeTab.DisplayItemsGenerator(){

        public void accept(CreativeModeTab.ItemDisplayParameters itemDisplayParameters, CreativeModeTab.Output output) {
            ModItems.ITEMS.getEntries().forEach(entry -> {
                block4: {
                    ItemStack stack;
                    block3: {
                        stack = ((Item)entry.get()).getDefaultInstance();
                        if (!ModItemGroup.isBlacklist((Item)entry.get())) {
                            output.accept(stack);
                        }
                        if (!stack.is((Item)ModItems.INFUSED_FABRIC_BLOCK.get())) break block3;
                        for (DyeColor color : DyeColor.values()) {
                            if (color.getName().equals("white")) continue;
                            ItemStack newStack = ((Item)ModItems.INFUSED_FABRIC_BLOCK.get()).getDefaultInstance();
                            CompoundTag tag = ((CustomData)newStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                            tag.putString("color", color.getName());
                            newStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                            output.accept(newStack);
                        }
                        break block4;
                    }
                    if (!stack.is((Item)ModItems.INFUSED_FABRIC_CARPET.get())) break block4;
                    for (DyeColor color : DyeColor.values()) {
                        if (color.getName().equals("white")) continue;
                        ItemStack newStack = ((Item)ModItems.INFUSED_FABRIC_CARPET.get()).getDefaultInstance();
                        CompoundTag tag = ((CustomData)newStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
                        tag.putString("color", color.getName());
                        newStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
                        output.accept(newStack);
                    }
                }
            });
        }
    }).build());

    private static boolean isBlacklist(Item item) {
        AtomicBoolean blacklisted = new AtomicBoolean(false);
        BLACKLIST.forEach(registryObject -> {
            if (item == registryObject.get()) {
                blacklisted.set(true);
            }
        });
        return blacklisted.get();
    }
}

