/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.joefoxe.hexerei.Hexerei;
import net.joefoxe.hexerei.block.custom.Candle;
import net.joefoxe.hexerei.client.renderer.entity.model.CandleModel;
import net.joefoxe.hexerei.data.candle.CandleData;
import net.joefoxe.hexerei.data.candle.PotionCandleEffect;
import net.joefoxe.hexerei.event.ClientEvents;
import net.joefoxe.hexerei.item.custom.CandleItem;
import net.joefoxe.hexerei.item.custom.CustomItemRenderer;
import net.joefoxe.hexerei.tileentity.CandleTile;
import net.joefoxe.hexerei.tileentity.renderer.CandleRenderer;
import net.joefoxe.hexerei.util.DynamicTextureHandler;
import net.joefoxe.hexerei.util.HexereiUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.model.data.ModelData;

public class CandleItemRenderer
extends CustomItemRenderer {
    CandleModel herbLayer;
    CandleModel glowLayer;
    CandleModel swirlLayer;
    CandleModel candleModel;
    CandleModel baseModel;

    @OnlyIn(value=Dist.CLIENT)
    public static CandleTile loadBlockEntityFromItem(ItemStack stack) {
        Candle candle;
        BlockEntity blockEntity;
        BlockItem blockItem;
        Block block;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof Candle && (blockEntity = (candle = (Candle)block).newBlockEntity(BlockPos.ZERO, block.defaultBlockState())) instanceof CandleTile) {
            CandleTile te = (CandleTile)blockEntity;
            te.setHeight(CandleItem.getHeight(stack));
            te.setDyeColor(HexereiUtil.getDyeColor(stack, 13419416));
            if (!((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().isEmpty()) {
                ((CandleData)te.candles.get(0)).load(((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag(), (HolderLookup.Provider)Hexerei.DynamicRegistries.get());
                if (stack.has(DataComponents.DYED_COLOR)) {
                    ((CandleData)te.candles.get((int)0)).dyeColor = ((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb();
                }
            }
            return te;
        }
        return null;
    }

    @Override
    public void renderByItem(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderTileStuff(stack, itemDisplayContext, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
    }

    public static int getCustomColor(CompoundTag tag) {
        if (tag != null && !tag.isEmpty()) {
            CompoundTag compoundtag = tag.contains("display") ? tag.getCompound("display") : null;
            return compoundtag != null && compoundtag.contains("color", 99) ? compoundtag.getInt("color") : 13419416;
        }
        return 13419416;
    }

    private void renderItem(ItemStack stack, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn) {
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GUI, combinedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, (Level)Minecraft.getInstance().level, 1);
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state) {
        Minecraft.getInstance().getBlockRenderer().renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, null);
    }

    /*
     * Unable to fully structure code
     */
    public void renderTileStuff(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        block31: {
            block32: {
                tileEntityIn = CandleItemRenderer.loadBlockEntityFromItem(stack);
                if (tileEntityIn == null) {
                    return;
                }
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.2, -0.1, -0.1);
                matrixStackIn.translate(0.5f, 1.6875f, 0.5f);
                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                candleData = (CandleData)tileEntityIn.candles.get(0);
                v0 = hasBase = candleData.base.layer != null;
                if (this.herbLayer == null) {
                    this.herbLayer = new CandleModel<T>(Minecraft.getInstance().getEntityModels().bakeLayer(CandleModel.CANDLE_HERB_LAYER));
                }
                if (this.glowLayer == null) {
                    this.glowLayer = new CandleModel<T>(Minecraft.getInstance().getEntityModels().bakeLayer(CandleModel.CANDLE_GLOW_LAYER));
                }
                if (this.swirlLayer == null) {
                    this.swirlLayer = new CandleModel<T>(Minecraft.getInstance().getEntityModels().bakeLayer(CandleModel.CANDLE_SWIRL_LAYER));
                }
                if (this.candleModel == null) {
                    this.candleModel = new CandleModel<T>(Minecraft.getInstance().getEntityModels().bakeLayer(CandleModel.CANDLE_LAYER));
                }
                if (this.baseModel == null) {
                    this.baseModel = new CandleModel<T>(Minecraft.getInstance().getEntityModels().bakeLayer(CandleModel.CANDLE_BASE_LAYER));
                }
                col = HexereiUtil.rgbIntToFloatArray(candleData.dyeColor);
                height = 0;
                if (candleData.base.layer != null) {
                    if (candleData.base.layerFromBlockLocation) {
                        holder = BuiltInRegistries.BLOCK.getHolder(candleData.base.layer);
                        if (holder.isPresent()) {
                            blockState = ((Block)((Holder.Reference)holder.get()).value()).defaultBlockState();
                            loc = HexereiUtil.getResource("candle_base/" + candleData.base.layer.getPath());
                            if (DynamicTextureHandler.textures.containsKey(loc)) {
                                baseSprite = DynamicTextureHandler.textures.get(loc);
                                vertexConsumer2 = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)loc));
                                matrixStackIn.pushPose();
                                matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                                matrixStackIn.translate(0.0f, -1.4375f, 0.0f);
                                CandleRenderer.renderCube(matrixStackIn, vertexConsumer2, baseSprite.width, baseSprite.height, baseSprite.width, 16.0f, 16.0f, combinedLightIn, combinedOverlayIn);
                                matrixStackIn.popPose();
                                height = baseSprite.height;
                            } else {
                                DynamicTextureHandler.addNewSprite(loc, blockState);
                            }
                        }
                    } else {
                        vertexConsumer2 = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)candleData.base.layer));
                        height = 1;
                        matrixStackIn.pushPose();
                        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(180.0f));
                        matrixStackIn.translate(0.0f, -1.4375f, 0.0f);
                        CandleRenderer.renderCube(matrixStackIn, vertexConsumer2, 3.0f, height, 3.0f, 16.0f, 16.0f, combinedLightIn, combinedOverlayIn);
                        matrixStackIn.popPose();
                    }
                }
                matrixStackIn.translate(0.0f, (float)(-height) / 16.0f, 0.0f);
                vertexConsumer = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)HexereiUtil.getResource("textures/block/candle.png")));
                if (candleData.height != 0 && candleData.height <= 7) {
                    this.candleModel.wax[candleData.height - 1].render(matrixStackIn, vertexConsumer, combinedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(col[0], col[1], col[2], 1.0f));
                }
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.0f, (float)(7 - candleData.height) / 16.0f, 0.0f);
                this.candleModel.wick.render(matrixStackIn, vertexConsumer, combinedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 1.0f));
                matrixStackIn.popPose();
                if (candleData.herb.layer != null && candleData.height != 0 && candleData.height <= 7) {
                    if (candleData.herb.layerFromBlockLocation) {
                        holder = BuiltInRegistries.BLOCK.getHolder(candleData.herb.layer);
                        if (holder.isPresent() && (sprite = CandleRenderer.getFirstSprite(blockState = ((Block)((Holder.Reference)holder.get()).value()).defaultBlockState())) != null) {
                            vertexConsumer2 = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)(sprite.contents().name().getNamespace() + ":textures/" + sprite.contents().name().getPath() + ".png"))));
                            this.herbLayer.wax[candleData.height - 1].render(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 0.75f));
                        }
                    } else {
                        vertexConsumer2 = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)candleData.herb.layer));
                        this.herbLayer.wax[candleData.height - 1].render(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 0.75f));
                    }
                }
                if (candleData.glow.layer == null) break block31;
                if (!candleData.glow.layerFromBlockLocation) break block32;
                holder = BuiltInRegistries.BLOCK.getHolder(candleData.glow.layer);
                if (!holder.isPresent() || (sprite = CandleRenderer.getFirstSprite(blockState = ((Block)((Holder.Reference)holder.get()).value()).defaultBlockState())) == null) break block31;
                vertexConsumer2 = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)ResourceLocation.parse((String)(sprite.contents().name().getNamespace() + ":textures/" + sprite.contents().name().getPath() + ".png"))));
                var18_21 = candleData.effect;
                if (!(var18_21 instanceof PotionCandleEffect)) ** GOTO lbl-1000
                potionCandleEffect = (PotionCandleEffect)var18_21;
                if (potionCandleEffect.effect != null) {
                    color = potionCandleEffect.effect.getColor();
                    col2 = HexereiUtil.rgbIntToFloatArray(color);
                    if (candleData.height != 0 && candleData.height <= 7) {
                        this.glowLayer.wax[candleData.height - 1].render(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(col2[0], col2[1], col2[2], 0.75f));
                    }
                } else if (candleData.height != 0 && candleData.height <= 7) {
                    this.glowLayer.wax[candleData.height - 1].render(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 0.75f));
                }
                break block31;
            }
            vertexConsumer2 = bufferIn.getBuffer(RenderType.entityTranslucent((ResourceLocation)candleData.glow.layer));
            sprite = candleData.effect;
            if (!(sprite instanceof PotionCandleEffect)) ** GOTO lbl-1000
            potionCandleEffect = (PotionCandleEffect)sprite;
            if (potionCandleEffect.effect != null) {
                color = potionCandleEffect.effect.getColor();
                col2 = HexereiUtil.rgbIntToFloatArray(color);
                if (candleData.height != 0 && candleData.height <= 7) {
                    this.glowLayer.wax[candleData.height - 1].render(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(col2[0], col2[1], col2[2], 0.75f));
                }
            } else if (candleData.height != 0 && candleData.height <= 7) {
                this.glowLayer.wax[candleData.height - 1].render(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(1.0f, 1.0f, 1.0f, 0.75f));
            }
        }
        if (candleData.swirl.layer != null) {
            if (candleData.swirl.layerFromBlockLocation) {
                holder = BuiltInRegistries.BLOCK.getHolder(candleData.swirl.layer);
                if (holder.isPresent() && (sprite = CandleRenderer.getFirstSprite(blockState = ((Block)((Holder.Reference)holder.get()).value()).defaultBlockState())) != null) {
                    offset = ClientEvents.getClientTicksWithoutPartial() + (float)Minecraft.getInstance().getFrameTimeNs();
                    vertexConsumer2 = bufferIn.getBuffer(RenderType.energySwirl((ResourceLocation)ResourceLocation.parse((String)(sprite.contents().name().getNamespace() + ":textures/" + sprite.contents().name().getPath() + ".png")), (float)(offset * 0.01f % 1.0f), (float)(offset * 0.01f % 1.0f)));
                    if (candleData.height != 0 && candleData.height <= 7) {
                        this.swirlLayer.wax[candleData.height - 1].render(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(col[0], col[1], col[2], 0.75f));
                    }
                }
            } else {
                offset = ClientEvents.getClientTicksWithoutPartial() + (float)Minecraft.getInstance().getFrameTimeNs();
                vertexConsumer2 = bufferIn.getBuffer(RenderType.energySwirl((ResourceLocation)candleData.swirl.layer, (float)(offset * 0.01f % 1.0f), (float)(offset * 0.01f % 1.0f)));
                if (candleData.height != 0 && candleData.height <= 7) {
                    this.swirlLayer.wax[candleData.height - 1].render(matrixStackIn, vertexConsumer2, combinedLightIn, OverlayTexture.NO_OVERLAY, HexereiUtil.getColorValueAlpha(col[0], col[1], col[2], 0.75f));
                }
            }
        }
        matrixStackIn.popPose();
    }

    private void renderBlock(PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, BlockState state, int color) {
        this.renderSingleBlock(state, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, color);
    }

    public void renderSingleBlock(BlockState p_110913_, PoseStack p_110914_, MultiBufferSource p_110915_, int p_110916_, int p_110917_, ModelData modelData, int color) {
        RenderShape rendershape = p_110913_.getRenderShape();
        if (rendershape != RenderShape.INVISIBLE) {
            switch (rendershape) {
                case MODEL: {
                    BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
                    BakedModel bakedmodel = dispatcher.getBlockModel(p_110913_);
                    int i = color;
                    float f = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(i & 0xFF) / 255.0f;
                    dispatcher.getModelRenderer().renderModel(p_110914_.last(), p_110915_.getBuffer(ItemBlockRenderTypes.getRenderType((BlockState)p_110913_, (boolean)false)), p_110913_, bakedmodel, f, f1, f2, p_110916_, p_110917_, modelData, null);
                    break;
                }
                case ENTITYBLOCK_ANIMATED: {
                    ItemStack stack = new ItemStack((ItemLike)p_110913_.getBlock());
                    IClientItemExtensions.of((Item)stack.getItem()).getCustomRenderer().renderByItem(stack, ItemDisplayContext.NONE, p_110914_, p_110915_, p_110916_, p_110917_);
                }
            }
        }
    }
}

