/*
 * Decompiled with CFR 0.152.
 */
package net.joefoxe.hexerei.item.custom;

import java.util.List;
import net.joefoxe.hexerei.client.renderer.IThirdPersonItemAnimation;
import net.joefoxe.hexerei.client.renderer.TwoHandedItemAnimation;
import net.joefoxe.hexerei.config.ModKeyBindings;
import net.joefoxe.hexerei.events.GlassesZoomKeyPressEvent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class GlassesItem
extends Item
implements IThirdPersonItemAnimation {
    public GlassesItem(Item.Properties builder) {
        super(builder);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1200;
    }

    public UseAnim getUseAnimation(ItemStack p_151224_) {
        return UseAnim.SPYGLASS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player p_151219_, InteractionHand p_151220_) {
        p_151219_.playSound(SoundEvents.SPYGLASS_STOP_USING, 1.0f, 0.5f);
        p_151219_.awardStat(Stats.ITEM_USED.get((Object)this));
        if (level.isClientSide()) {
            GlassesZoomKeyPressEvent.zoomWithItemToggled = true;
        }
        if (level.isClientSide()) {
            GlassesZoomKeyPressEvent.zoomAmount = Minecraft.getInstance().gameRenderer.fov;
        }
        return ItemUtils.startUsingInstantly((Level)level, (Player)p_151219_, (InteractionHand)p_151220_);
    }

    public ItemStack finishUsingItem(ItemStack p_151209_, Level p_151210_, LivingEntity p_151211_) {
        this.stopUsing(p_151211_);
        return p_151209_;
    }

    public void releaseUsing(ItemStack p_151213_, Level p_151214_, LivingEntity p_151215_, int p_151216_) {
        this.stopUsing(p_151215_);
    }

    private void stopUsing(LivingEntity p_151207_) {
        if (p_151207_.level().isClientSide()) {
            GlassesZoomKeyPressEvent.zoomWithItemToggled = false;
        }
        p_151207_.playSound(SoundEvents.SPYGLASS_STOP_USING, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (Screen.hasShiftDown()) {
            tooltipComponents.add((Component)Component.translatable((String)"<%s>", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAA6600)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.hexerei.reading_glasses_shift", (Object[])new Object[]{ModKeyBindings.glassesZoom.getTranslatedKeyMessage()}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"[%s]", (Object[])new Object[]{Component.translatable((String)"tooltip.hexerei.shift").withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0xAAAA00)))}).withStyle(Style.EMPTY.withColor(TextColor.fromRgb((int)0x999999))));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand, TwoHandedItemAnimation twoHanded) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            this.animateHands(model, entity, false);
            twoHanded.bool = false;
            return true;
        }
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand, TwoHandedItemAnimation twoHanded) {
        if (entity.getUseItemRemainingTicks() > 0 && entity.getUseItem().getItem() == this) {
            this.animateHands(model, entity, true);
            twoHanded.bool = false;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private <T extends LivingEntity> void animateHands(HumanoidModel<T> model, T entity, boolean leftHand) {
        ModelPart mainHand = model.rightArm;
        ModelPart offHand = model.leftArm;
        ModelPart head = model.head;
        if (!leftHand) {
            mainHand.xRot = Mth.clamp((float)(head.xRot - 1.9198622f - (entity.isCrouching() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
            mainHand.yRot = head.yRot - 0.08726647f;
            AnimationUtils.bobModelPart((ModelPart)model.rightArm, (float)entity.tickCount, (float)-1.0f);
        }
        if (leftHand) {
            offHand.xRot = Mth.clamp((float)(head.xRot - 1.9198622f - (entity.isCrouching() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
            offHand.yRot = head.yRot + 0.08726647f;
            AnimationUtils.bobModelPart((ModelPart)model.leftArm, (float)entity.tickCount, (float)1.0f);
        }
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }
}

